/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.data;

import baguchan.frostrealm.data.FrostAdvancementData;
import baguchan.frostrealm.data.FrostDataMaps;
import baguchan.frostrealm.data.generator.BiomeTagGenerator;
import baguchan.frostrealm.data.generator.FrBlockTagGenerator;
import baguchan.frostrealm.data.generator.FrDamageTypeTagGenerator;
import baguchan.frostrealm.data.generator.FrEntityTagGenerator;
import baguchan.frostrealm.data.generator.FrFluidTagGenerator;
import baguchan.frostrealm.data.generator.FrItemTagGenerator;
import baguchan.frostrealm.data.generator.FrostEquipmentAssetProvider;
import baguchan.frostrealm.data.generator.FrostModelData;
import baguchan.frostrealm.data.generator.FrostPaintingTagsProvider;
import baguchan.frostrealm.data.generator.LootGenerator;
import baguchan.frostrealm.data.generator.RegistryDataGenerator;
import baguchan.frostrealm.data.generator.recipe.CraftingGenerator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="frostrealm")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        RegistryDataGenerator datapackProvider = new RegistryDataGenerator(packOutput, event.getLookupProvider());
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(true, (DataProvider)datapackProvider);
        event.getGenerator().addProvider(true, (DataProvider)new FrostAdvancementData(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new FrostEquipmentAssetProvider(packOutput));
        generator.addProvider(true, (DataProvider)new FrostModelData(packOutput));
        event.getGenerator().addProvider(true, (DataProvider)LootGenerator.create(packOutput, lookupProvider));
        event.getGenerator().addProvider(true, (DataProvider)new Runner(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new FrostDataMaps(packOutput, lookupProvider));
        FrBlockTagGenerator blocktags = new FrBlockTagGenerator(packOutput, lookupProvider);
        event.getGenerator().addProvider(true, (DataProvider)blocktags);
        event.getGenerator().addProvider(true, (DataProvider)new FrItemTagGenerator(packOutput, lookupProvider));
        event.getGenerator().addProvider(true, (DataProvider)new FrEntityTagGenerator(packOutput, lookupProvider));
        event.getGenerator().addProvider(true, (DataProvider)new FrFluidTagGenerator(packOutput, lookupProvider));
        event.getGenerator().addProvider(true, (DataProvider)new FrostPaintingTagsProvider(packOutput, lookupProvider));
        event.getGenerator().addProvider(true, (DataProvider)new BiomeTagGenerator(packOutput, lookupProvider));
        event.getGenerator().addProvider(true, (DataProvider)new FrDamageTypeTagGenerator(packOutput, lookupProvider));
    }

    public static final class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider lookupProvider, RecipeOutput output) {
            return new CraftingGenerator(lookupProvider, output);
        }

        public String getName() {
            return "frostrealmrecipes";
        }
    }
}

