/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.data.generator;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.data.generator.FrostEquipmentAssets;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.EquipmentAsset;

public class FrostEquipmentAssetProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;

    public FrostEquipmentAssetProvider(PackOutput p_387559_) {
        this.pathProvider = p_387559_.createPathProvider(PackOutput.Target.RESOURCE_PACK, "equipment");
    }

    private static void bootstrap(BiConsumer<ResourceKey<EquipmentAsset>, EquipmentClientInfo> p_387865_) {
        p_387865_.accept(FrostEquipmentAssets.ASTRIUM, FrostEquipmentAssetProvider.onlyHumanoidAndWolfflue("astrium"));
        p_387865_.accept(FrostEquipmentAssets.FROST_BOAR_FUR, FrostEquipmentAssetProvider.onlyHumanoidAndWolfflue("frost_boar_fur"));
        p_387865_.accept(FrostEquipmentAssets.YETI_FUR, FrostEquipmentAssetProvider.onlyHumanoid("yeti_fur"));
        EquipmentClientInfo.Layer equipmentclientinfo$layer = new EquipmentClientInfo.Layer(FrostRealm.prefix("saddle"));
        p_387865_.accept(FrostEquipmentAssets.WOLFFLUE_SADDLE, EquipmentClientInfo.builder().addLayers(EquipmentClientInfo.LayerType.valueOf((String)"FROSTREALM_WOLFFLUE_SADDLE"), new EquipmentClientInfo.Layer[]{equipmentclientinfo$layer}).build());
    }

    private static EquipmentClientInfo onlyHumanoid(String p_371738_) {
        return EquipmentClientInfo.builder().addHumanoidLayers(FrostRealm.prefix(p_371738_)).build();
    }

    private static EquipmentClientInfo onlyHumanoidAndWolfflue(String p_371738_) {
        return EquipmentClientInfo.builder().addHumanoidLayers(FrostRealm.prefix(p_371738_)).addLayers(EquipmentClientInfo.LayerType.valueOf((String)"FROSTREALM_WOLFFLUE"), new EquipmentClientInfo.Layer[]{EquipmentClientInfo.Layer.leatherDyeable((ResourceLocation)FrostRealm.prefix(p_371738_), (boolean)false)}).build();
    }

    public CompletableFuture<?> run(CachedOutput p_387304_) {
        HashMap map = new HashMap();
        FrostEquipmentAssetProvider.bootstrap((p_386976_, p_388942_) -> {
            if (map.putIfAbsent(p_386976_, p_388942_) != null) {
                throw new IllegalStateException("Tried to register equipment asset twice for id: " + String.valueOf(p_386976_));
            }
        });
        return DataProvider.saveAll((CachedOutput)p_387304_, (Codec)EquipmentClientInfo.CODEC, arg_0 -> ((PackOutput.PathProvider)this.pathProvider).json(arg_0), map);
    }

    public String getName() {
        return "Equipment Asset Definitions";
    }
}

