/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.data.generator.models;

import baguchan.frostrealm.data.builder.FrostBlockFamilies;
import baguchan.frostrealm.data.generator.FrostTextureMappings;
import baguchan.frostrealm.data.provider.FrBlockstateModelProvider;
import baguchan.frostrealm.registry.FrostBlocks;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.BlockModelDefinitionGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.data.BlockFamily;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class FrostBlockModels
extends FrBlockstateModelProvider {
    public FrostBlockModels(Consumer<BlockModelDefinitionGenerator> blockStateOutput, ItemModelOutput itemModelOutput, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        super(blockStateOutput, itemModelOutput, modelOutput);
    }

    public void run() {
        FrostBlockFamilies.getAllFamilies().filter(BlockFamily::shouldGenerateModel).forEach(family -> this.family(family.getBaseBlock()).generateFor(family));
        this.createGrassLikeFrostBlock((Block)FrostBlocks.FROZEN_GRASS_BLOCK.get(), (Block)FrostBlocks.FROZEN_DIRT.get());
        this.createGrassLikeFrostStoneBlock((Block)FrostBlocks.FRIGID_GRASS_BLOCK.get(), (Block)FrostBlocks.FRIGID_STONE.get());
        this.createFrostPortalBlock();
        this.createFrostFarmland();
        this.createPointedIce(this);
        this.createTrivialCube((Block)FrostBlocks.FROZEN_DIRT.get());
        this.createTrivialCube((Block)FrostBlocks.PERMA_SLATE.get());
        this.family((Block)FrostBlocks.PERMA_SLATE_BRICK.get()).slab((Block)FrostBlocks.PERMA_SLATE_BRICK_SLAB.get()).stairs((Block)FrostBlocks.PERMA_SLATE_BRICK_STAIRS.get()).wall((Block)FrostBlocks.PERMA_SLATE_BRICK_WALL.get());
        this.createTrivialCube((Block)FrostBlocks.PERMA_SLATE_SMOOTH.get());
        this.createGlowCube((Block)FrostBlocks.PERMA_MAGMA.get());
        this.family((Block)FrostBlocks.FRIGID_STONE.get()).slab((Block)FrostBlocks.FRIGID_STONE_SLAB.get()).stairs((Block)FrostBlocks.FRIGID_STONE_STAIRS.get());
        this.createTrivialCube((Block)FrostBlocks.FRIGID_STONE_SMOOTH.get());
        this.createTrivialCube((Block)FrostBlocks.CHISELED_FRIGID_STONE_BRICK.get());
        this.createTrivialCube((Block)FrostBlocks.MAGMA_CORE.get());
        this.family((Block)FrostBlocks.FRIGID_STONE_BRICK.get()).slab((Block)FrostBlocks.FRIGID_STONE_BRICK_SLAB.get()).stairs((Block)FrostBlocks.FRIGID_STONE_BRICK_STAIRS.get()).wall((Block)FrostBlocks.FRIGID_STONE_BRICK_WALL.get());
        this.family((Block)FrostBlocks.FRIGID_STONE_MOSSY.get()).slab((Block)FrostBlocks.FRIGID_STONE_MOSSY_SLAB.get()).stairs((Block)FrostBlocks.FRIGID_STONE_MOSSY_STAIRS.get());
        this.family((Block)FrostBlocks.FRIGID_STONE_BRICK_MOSSY.get()).slab((Block)FrostBlocks.FRIGID_STONE_BRICK_MOSSY_SLAB.get()).stairs((Block)FrostBlocks.FRIGID_STONE_BRICK_MOSSY_STAIRS.get());
        this.createTrivialCube((Block)FrostBlocks.SHERBET_SAND.get());
        this.familyWithExistingFullBlock((Block)FrostBlocks.SHERBET_SANDSTONE.get()).fullBlock((Block)FrostBlocks.SHERBET_SANDSTONE.get(), ModelTemplates.CUBE_BOTTOM_TOP).slab((Block)FrostBlocks.SHERBET_SANDSTONE_SLAB.get()).stairs((Block)FrostBlocks.SHERBET_SANDSTONE_STAIRS.get());
        this.createTrivialCube((Block)FrostBlocks.GLACINIUM_ORE.get());
        this.createTrivialCube((Block)FrostBlocks.GLACINIUM_BLOCK.get());
        this.createTrivialCube((Block)FrostBlocks.RAW_GLACINIUM_BLOCK.get());
        this.woodProvider((Block)FrostBlocks.FROSTROOT_LOG.get()).log((Block)FrostBlocks.FROSTROOT_LOG.get());
        this.woodProvider((Block)FrostBlocks.STRIPPED_FROSTROOT_LOG.get()).log((Block)FrostBlocks.STRIPPED_FROSTROOT_LOG.get());
        this.createTrivialBlock((Block)FrostBlocks.FROSTROOT_LEAVES.get(), LEAVES_PROVIDER);
        this.createCrossBlockWithDefaultItem((Block)FrostBlocks.FROSTROOT_SAPLING.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        this.woodProvider((Block)FrostBlocks.FROSTBITE_LOG.get()).log((Block)FrostBlocks.FROSTBITE_LOG.get());
        this.woodProvider((Block)FrostBlocks.STRIPPED_FROSTBITE_LOG.get()).log((Block)FrostBlocks.STRIPPED_FROSTBITE_LOG.get());
        this.woodProvider((Block)FrostBlocks.ROCK_WOOD.get()).wood((Block)FrostBlocks.ROCK_WOOD.get());
        this.createTrivialBlock((Block)FrostBlocks.FROSTBITE_LEAVES.get(), LEAVES_PROVIDER);
        this.createCrossBlockWithDefaultItem((Block)FrostBlocks.FROSTBITE_SAPLING.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        this.woodProvider((Block)FrostBlocks.DRIP_LOG.get()).log((Block)FrostBlocks.DRIP_LOG.get());
        this.createTrivialBlock((Block)FrostBlocks.DRIP_LEAVES.get(), LEAVES_PROVIDER);
        this.createCrossBlockWithDefaultItem((Block)FrostBlocks.DRIP_SAPLING.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        this.createCrossBlockWithDefaultItem((Block)FrostBlocks.VIGOROSHROOM.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        this.createCrossBlockWithDefaultItem((Block)FrostBlocks.ARCTIC_POPPY.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        this.createCrossBlockWithDefaultItem((Block)FrostBlocks.ARCTIC_WILLOW.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        this.createCrossBlock((Block)FrostBlocks.COLD_GRASS.get(), BlockModelGenerators.PlantType.TINTED);
        this.createItemWithGrassTint((Block)FrostBlocks.COLD_GRASS.get());
        this.createTintedDoublePlant((Block)FrostBlocks.COLD_TALL_GRASS.get());
        this.createCropBlock((Block)FrostBlocks.BEARBERRY_BUSH.get(), (Property<Integer>)BlockStateProperties.AGE_3, 0, 1, 2, 3);
        this.createCropBlock((Block)FrostBlocks.SUGARBEET.get(), (Property<Integer>)BlockStateProperties.AGE_3, 0, 1, 2, 3);
        this.createCropBlock((Block)FrostBlocks.RYE.get(), (Property<Integer>)BlockStateProperties.AGE_7, 0, 1, 2, 3, 4, 5, 6, 7);
        this.createGlowCube((Block)FrostBlocks.FROST_CRYSTAL_ORE.get());
        this.createGlowCube((Block)FrostBlocks.GLIMMERROCK_ORE.get());
        this.createTrivialCube((Block)FrostBlocks.FROST_CRYSTAL_BLOCK.get());
        this.createNormalTorch((Block)FrostBlocks.FROST_TORCH.get(), (Block)FrostBlocks.WALL_FROST_TORCH.get());
        this.createTrivialCube((Block)FrostBlocks.ASTRIUM_ORE.get());
        this.createGlowCube((Block)FrostBlocks.FROST_CRYSTAL_SLATE_ORE.get());
        this.createGlowCube((Block)FrostBlocks.GLIMMERROCK_SLATE_ORE.get());
        this.createTrivialCube((Block)FrostBlocks.ASTRIUM_SLATE_ORE.get());
        this.createTrivialCube((Block)FrostBlocks.ASTRIUM_BLOCK.get());
        this.createTrivialCube((Block)FrostBlocks.RAW_ASTRIUM_BLOCK.get());
        this.createTrivialCube((Block)FrostBlocks.GLIMMERROCK_BLOCK.get());
        this.createGlowCube((Block)FrostBlocks.STARDUST_CRYSTAL_ORE.get());
        this.createTranslucentCube((Block)FrostBlocks.STARDUST_CRYSTAL_CLUSTER.get());
        this.createTranslucentCube((Block)FrostBlocks.WARPED_CRYSTAL_BLOCK.get());
        this.createTrivialCube((Block)FrostBlocks.SILK_MOON_COCOON.get());
        this.createCampfires((Block)FrostBlocks.FROST_CAMPFIRE.get());
        this.createNonTemplateModelBlock((Block)FrostBlocks.HOT_SPRING.get());
        this.createAuroraInfuser((Block)FrostBlocks.AURORA_INFUSER.get());
        this.createWolfflue((Block)FrostBlocks.WOLFFLUE_BLOCK.get());
        this.createBlockEgg((Block)FrostBlocks.SILK_MOON_EGG.get());
        this.createEgg((Block)FrostBlocks.SNOWPILE_QUAIL_EGG.get());
        this.createRotatedPillarWithHorizontalVariant((Block)FrostBlocks.RYE_BLOCK.get(), TexturedModel.COLUMN, TexturedModel.COLUMN_HORIZONTAL);
        this.createFrostFire();
    }

    public void createAuroraInfuser(Block p_388054_) {
        TextureMapping texturemapping = FrostTextureMappings.auroraInfuser(p_388054_);
        this.blockStateOutput.accept(FrostBlockModels.createSimpleBlock(p_388054_, ModelTemplates.CUBE.create(p_388054_, texturemapping, this.modelOutput)));
    }

    public void createWolfflue(Block p_388054_) {
        TextureMapping texturemapping = FrostTextureMappings.wolfflue(p_388054_);
        MultiVariant multiVariant = FrostBlockModels.plainVariant((ResourceLocation)ModelTemplates.CUBE.create(p_388054_, texturemapping, this.modelOutput));
        this.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)p_388054_, (MultiVariant)multiVariant).with(ROTATION_HORIZONTAL_FACING));
    }
}

