/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.data.resource;

import baguchan.frostrealm.registry.FrostEntities;
import baguchan.frostrealm.registry.FrostSounds;
import baguchan.frostrealm.world.biome.FrostBiomeDefaultFeatures;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class FrostBiomeBuilders {
    public static Biome undergroundBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder builder1 = new MobSpawnSettings.Builder();
        FrostBiomeDefaultFeatures.addUnderGroundFeature(builder);
        FrostBiomeDefaultFeatures.underGroundMonsterSpawns(builder1);
        return FrostBiomeBuilders.makeDefaultHotBiome(builder, builder1, FrostSounds.FROST_MOON_BGM);
    }

    public static Biome iceBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder builder1 = new MobSpawnSettings.Builder();
        FrostBiomeDefaultFeatures.addIceCaveFeatures(builder);
        FrostBiomeDefaultFeatures.addWaterSpringOnlyFeatures(builder);
        FrostBiomeDefaultFeatures.monsterSpawns(builder1);
        return FrostBiomeBuilders.makeDefaultBiome(builder, builder1);
    }

    public static Biome waterFallBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder builder1 = new MobSpawnSettings.Builder();
        FrostBiomeDefaultFeatures.addWaterSpringOnlyFeatures(builder);
        FrostBiomeDefaultFeatures.addHotSpringDelta(builder);
        FrostBiomeDefaultFeatures.addCrystalFallPlantsFeatures(builder);
        FrostBiomeDefaultFeatures.crystalFallCreatureSpawns(builder1);
        FrostBiomeDefaultFeatures.monsterSpawns(builder1);
        return FrostBiomeBuilders.makeSkyBiome(builder, builder1, FrostSounds.FROST_MOON_BGM);
    }

    public static Biome sherbetDesert(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder builder1 = new MobSpawnSettings.Builder();
        FrostBiomeDefaultFeatures.addSpringFeatures(builder);
        FrostBiomeDefaultFeatures.monsterSpawns(builder1);
        return FrostBiomeBuilders.makeDesertBiome(builder, builder1, FrostSounds.FROST_MOON_BGM);
    }

    public static Biome hotrockBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder builder1 = new MobSpawnSettings.Builder();
        FrostBiomeDefaultFeatures.addHotRockFeatures(builder);
        FrostBiomeDefaultFeatures.mountainMonsterSpawns(builder1);
        return FrostBiomeBuilders.makeDefaultHotBiome(builder, builder1, FrostSounds.FROST_MOON_BGM);
    }

    public static Biome beachBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder builder1 = new MobSpawnSettings.Builder();
        FrostBiomeDefaultFeatures.addSpringFeatures(builder);
        FrostBiomeDefaultFeatures.monsterSpawns(builder1);
        return FrostBiomeBuilders.makeDefaultBiome(builder, builder1);
    }

    public static Biome forestBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder builder1 = new MobSpawnSettings.Builder();
        FrostBiomeDefaultFeatures.addForestFeatures(builder);
        FrostBiomeDefaultFeatures.forestCreatureSpawns(builder1);
        FrostBiomeDefaultFeatures.addSpringFeatures(builder);
        FrostBiomeDefaultFeatures.monsterSpawns(builder1);
        return FrostBiomeBuilders.makeDefaultBiome(builder, builder1);
    }

    public static Biome frostbiteBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder builder1 = new MobSpawnSettings.Builder();
        FrostBiomeDefaultFeatures.addFrostBiteFeatures(builder);
        FrostBiomeDefaultFeatures.frostBiteCreatureSpawns(builder1);
        FrostBiomeDefaultFeatures.addSpringFeatures(builder);
        FrostBiomeDefaultFeatures.monsterSpawns(builder1);
        return FrostBiomeBuilders.makeDefaultBiome(builder, builder1);
    }

    public static Biome dripBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder builder1 = new MobSpawnSettings.Builder();
        FrostBiomeDefaultFeatures.addDripFeatures(builder);
        FrostBiomeDefaultFeatures.forestCreatureSpawns(builder1);
        FrostBiomeDefaultFeatures.addSpringFeatures(builder);
        FrostBiomeDefaultFeatures.monsterSpawns(builder1);
        return FrostBiomeBuilders.makeDefaultBiome(builder, builder1);
    }

    public static Biome tundraBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder builder1 = new MobSpawnSettings.Builder();
        FrostBiomeDefaultFeatures.addPlainsFeatures(builder);
        FrostBiomeDefaultFeatures.plainCreatureSpawns(builder1);
        FrostBiomeDefaultFeatures.addSpringFeatures(builder);
        FrostBiomeDefaultFeatures.monsterSpawns(builder1);
        return FrostBiomeBuilders.makeDefaultBiome(builder, builder1);
    }

    public static Biome riverBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder builder1 = new MobSpawnSettings.Builder();
        FrostBiomeDefaultFeatures.addPlainsFeatures(builder);
        FrostBiomeDefaultFeatures.addSpringFeatures(builder);
        FrostBiomeDefaultFeatures.monsterSpawns(builder1);
        return FrostBiomeBuilders.makeDefaultBiome(builder, builder1);
    }

    public static Biome oceanBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder builder1 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.addIcebergs((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.addBlueIce((BiomeGenerationSettings.Builder)builder);
        FrostBiomeDefaultFeatures.addPlainsFeatures(builder);
        FrostBiomeDefaultFeatures.addSpringFeatures(builder);
        builder1.addSpawn(MobCategory.CREATURE, 10, new MobSpawnSettings.SpawnerData((EntityType)FrostEntities.SEAL.get(), 5, 6));
        FrostBiomeDefaultFeatures.monsterSpawns(builder1);
        return FrostBiomeBuilders.makeOceanBiome(builder, builder1, FrostSounds.FROST_MOON_BGM);
    }

    public static Biome warpedCliffBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder builder1 = new MobSpawnSettings.Builder();
        FrostBiomeDefaultFeatures.addWarpedCliffFeatures(builder);
        FrostBiomeDefaultFeatures.addSpringFeatures(builder);
        FrostBiomeDefaultFeatures.mountainCreatureSpawns(builder1);
        FrostBiomeDefaultFeatures.monsterSpawns(builder1);
        return FrostBiomeBuilders.makeDefaultBiome(builder, builder1, FrostSounds.FROST_MOON_BGM);
    }

    public static Biome mountainBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder builder1 = new MobSpawnSettings.Builder();
        FrostBiomeDefaultFeatures.mountainCreatureSpawns(builder1);
        FrostBiomeDefaultFeatures.addSpringFeatures(builder);
        FrostBiomeDefaultFeatures.monsterSpawns(builder1);
        return FrostBiomeBuilders.makeDefaultBiome(builder, builder1, FrostSounds.FROST_MOON_BGM);
    }

    public static Biome stardustPeakBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        MobSpawnSettings.Builder builder1 = new MobSpawnSettings.Builder();
        FrostBiomeDefaultFeatures.mountainCreatureSpawns(builder1);
        FrostBiomeDefaultFeatures.addSpringFeatures(builder);
        FrostBiomeDefaultFeatures.addStarDustHillFeatures(builder);
        FrostBiomeDefaultFeatures.monsterSpawns(builder1);
        return FrostBiomeBuilders.makeDefaultBiome(builder, builder1, FrostSounds.FROST_MOON_BGM);
    }

    public static Biome makeDefaultBiome(BiomeGenerationSettings.Builder builder, MobSpawnSettings.Builder mobSpawnSetting) {
        return FrostBiomeBuilders.makeDefaultBiome(builder, mobSpawnSetting, FrostSounds.FROST_MOON_BGM);
    }

    public static Biome makeOceanBiome(BiomeGenerationSettings.Builder builder, MobSpawnSettings.Builder mobSpawnSetting, Supplier<SoundEvent> soundEvent) {
        FrostBiomeDefaultFeatures.addDefaultCarvers(builder);
        FrostBiomeDefaultFeatures.addDefaultOres(builder);
        builder.addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, MiscOverworldPlacements.FREEZE_TOP_LAYER);
        return FrostBiomeBuilders.fullDefinition(-1.2f, 0.5f, new BiomeSpecialEffects.Builder().fogColor(4630224).skyColor(7907327).waterColor(4159204).waterFogColor(329011).grassColorOverride(7115607).foliageColorOverride(7115607).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.NONE).backgroundMusic(new Music(Holder.direct((Object)soundEvent.get()), 3600, 10800, false)).build(), mobSpawnSetting.build(), builder.build(), Biome.TemperatureModifier.FROZEN);
    }

    public static Biome makeDefaultBiome(BiomeGenerationSettings.Builder builder, MobSpawnSettings.Builder mobSpawnSetting, Supplier<SoundEvent> soundEvent) {
        FrostBiomeDefaultFeatures.addDefaultCarvers(builder);
        FrostBiomeDefaultFeatures.addDefaultOres(builder);
        builder.addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, MiscOverworldPlacements.FREEZE_TOP_LAYER);
        return FrostBiomeBuilders.fullDefinition(-1.2f, 0.5f, new BiomeSpecialEffects.Builder().fogColor(4630224).skyColor(7907327).waterColor(4159204).waterFogColor(329011).grassColorOverride(7115607).foliageColorOverride(7115607).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.NONE).backgroundMusic(new Music(Holder.direct((Object)soundEvent.get()), 3600, 10800, false)).build(), mobSpawnSetting.build(), builder.build(), Biome.TemperatureModifier.NONE);
    }

    public static Biome makeSkyBiome(BiomeGenerationSettings.Builder builder, MobSpawnSettings.Builder mobSpawnSetting, Supplier<SoundEvent> soundEvent) {
        FrostBiomeDefaultFeatures.addDefaultCarvers(builder);
        FrostBiomeDefaultFeatures.addDefaultOres(builder);
        builder.addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, MiscOverworldPlacements.FREEZE_TOP_LAYER);
        return FrostBiomeBuilders.fullDefinition(0.3f, 0.8f, new BiomeSpecialEffects.Builder().fogColor(4630224).skyColor(7907327).waterColor(4159204).waterFogColor(329011).grassColorOverride(7115607).foliageColorOverride(7115607).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.NONE).backgroundMusic(new Music(Holder.direct((Object)soundEvent.get()), 3600, 10800, false)).build(), mobSpawnSetting.build(), builder.build(), Biome.TemperatureModifier.NONE);
    }

    public static Biome makeDesertBiome(BiomeGenerationSettings.Builder builder, MobSpawnSettings.Builder mobSpawnSetting, Supplier<SoundEvent> soundEvent) {
        FrostBiomeDefaultFeatures.addDefaultCarvers(builder);
        FrostBiomeDefaultFeatures.addDesertFeature(builder);
        FrostBiomeDefaultFeatures.addDefaultOres(builder);
        builder.addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, MiscOverworldPlacements.FREEZE_TOP_LAYER);
        return FrostBiomeBuilders.fullDefinition(0.5f, 0.8f, new BiomeSpecialEffects.Builder().fogColor(16759275).skyColor(7907327).waterColor(4159204).waterFogColor(329011).grassColorOverride(7115607).foliageColorOverride(7115607).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.NONE).backgroundMusic(new Music(Holder.direct((Object)soundEvent.get()), 3600, 10800, false)).build(), mobSpawnSetting.build(), builder.build(), Biome.TemperatureModifier.NONE);
    }

    public static Biome makeDefaultHotBiome(BiomeGenerationSettings.Builder builder, MobSpawnSettings.Builder mobSpawnSetting, Supplier<SoundEvent> soundEvent) {
        FrostBiomeDefaultFeatures.addDefaultCarvers(builder);
        FrostBiomeDefaultFeatures.addDefaultOres(builder);
        builder.addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, MiscOverworldPlacements.FREEZE_TOP_LAYER);
        return FrostBiomeBuilders.fullDefinition(0.8f, 0.6f, new BiomeSpecialEffects.Builder().fogColor(4630224).skyColor(7907327).waterColor(4159204).waterFogColor(329011).grassColorOverride(7115607).foliageColorOverride(7115607).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.NONE).backgroundMusic(new Music(Holder.direct((Object)soundEvent.get()), 3600, 10800, false)).build(), mobSpawnSetting.build(), builder.build(), Biome.TemperatureModifier.NONE);
    }

    public static Biome fullDefinition(float temperature, float downfall, BiomeSpecialEffects effects, MobSpawnSettings spawnSettings, BiomeGenerationSettings generationSettings, Biome.TemperatureModifier temperatureModifier) {
        return new Biome.BiomeBuilder().temperature(temperature).downfall(downfall).specialEffects(effects).mobSpawnSettings(spawnSettings).generationSettings(generationSettings).temperatureAdjustment(temperatureModifier).build();
    }
}

