/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.data.resource;

import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.registry.FrostTags;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.LinearPosTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class FrostStructures {
    public static final ResourceKey<Structure> IGLOO = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"igloo"));
    public static final ResourceKey<Structure> FROST_CASTLE = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_castle"));
    public static final ResourceKey<StructureSet> IGLOO_SET = ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"igloo"));
    public static final ResourceKey<StructureSet> FROST_CASTLE_SET = ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_castle"));
    public static final ResourceKey<StructureTemplatePool> FROST_CASTLE_ENTRANCE = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_castle/entrance"));
    public static final ResourceKey<StructureTemplatePool> FROST_CASTLE_BRIDGE = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_castle/bridge"));
    public static final ResourceKey<StructureTemplatePool> FROST_CASTLE_BRIDGE_END = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_castle/bridge/bridge_end"));
    public static final ResourceKey<StructureTemplatePool> FROST_CASTLE_MAIN = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_castle/main_castle"));
    public static final ResourceKey<StructureTemplatePool> FROST_CASTLE_ROOM_1 = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_castle/room_1"));
    public static final ResourceKey<StructureTemplatePool> FROST_CASTLE_ROOM_2 = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_castle/room_2"));
    public static final ResourceKey<StructureTemplatePool> FROST_CASTLE_LESSER_WARRIOR = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_castle/mobs/lesser_warrior"));
    public static final ResourceKey<StructureTemplatePool> FROST_CASTLE_WARRIOR = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_castle/mobs/warrior"));
    public static final ResourceKey<StructureTemplatePool> FROST_CASTLE_WALKER = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_castle/mobs/walker"));
    public static final ResourceKey<StructureTemplatePool> FROST_CASTLE_SEEKER = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_castle/mobs/seeker"));
    public static final ResourceKey<StructureTemplatePool> IGLOO_ROAD = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"igloo/road"));
    public static final ResourceKey<StructureTemplatePool> IGLOO_HOUSE = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"igloo/igloo"));
    public static final ResourceKey<StructureTemplatePool> IGLOO_ENTRANCE = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"igloo/igloo_entrance"));
    public static final ResourceKey<StructureTemplatePool> YETI = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"igloo/mobs/yeti"));
    public static final ResourceKey<StructureProcessorList> IGLOO_ROAD_PROCESSOR = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"igloo_road"));
    public static final ResourceKey<StructureProcessorList> FROST_CASTLE_MAGMA_PROCESSOR = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_castle/magma"));

    public static void bootstrapStructures(BootstrapContext<Structure> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter pools = context.lookup(Registries.TEMPLATE_POOL);
        context.register(IGLOO, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)biomes.getOrThrow(FrostTags.Biomes.HAS_IGLOO)).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), (Holder)pools.getOrThrow(IGLOO_ENTRANCE), 8, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), false, Heightmap.Types.WORLD_SURFACE_WG));
        context.register(FROST_CASTLE, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)biomes.getOrThrow(FrostTags.Biomes.HAS_CASTLE)).generationStep(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).terrainAdapation(TerrainAdjustment.BEARD_THIN).spawnOverrides(Arrays.stream(MobCategory.values()).collect(Collectors.toMap(p_344252_ -> p_344252_, p_392604_ -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedList.of())))).build(), (Holder)pools.getOrThrow(FROST_CASTLE_ENTRANCE), Optional.empty(), 10, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)-46)), false, Optional.empty(), new JigsawStructure.MaxDistance(116), List.of(), new DimensionPadding(0), LiquidSettings.IGNORE_WATERLOGGING));
    }

    public static void bootstrapSets(BootstrapContext<StructureSet> context) {
        HolderGetter structures = context.lookup(Registries.STRUCTURE);
        context.register(IGLOO_SET, (Object)new StructureSet(List.of(StructureSet.entry((Holder)structures.getOrThrow(IGLOO), (int)1)), (StructurePlacement)new RandomSpreadStructurePlacement(26, 8, RandomSpreadType.LINEAR, 16324620)));
        context.register(FROST_CASTLE_SET, (Object)new StructureSet(List.of(StructureSet.entry((Holder)structures.getOrThrow(FROST_CASTLE), (int)1)), (StructurePlacement)new RandomSpreadStructurePlacement(32, 8, RandomSpreadType.LINEAR, 14284620)));
    }

    public static void bootstrapPools(BootstrapContext<StructureTemplatePool> context) {
        Holder.Reference emptyPool = context.lookup(Registries.TEMPLATE_POOL).getOrThrow(Pools.EMPTY);
        HolderGetter processors = context.lookup(Registries.PROCESSOR_LIST);
        HolderGetter holdergetter2 = context.lookup(Registries.TEMPLATE_POOL);
        context.register(IGLOO_ENTRANCE, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("igloo/igloo_entrance")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(IGLOO_HOUSE, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("igloo/igloo_1")), (Object)2), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("igloo/igloo_2")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("igloo/rest_place")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("igloo/igloo_3")), (Object)4)), StructureTemplatePool.Projection.RIGID));
        context.register(IGLOO_ROAD, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("igloo/road_1"), (Holder)processors.getOrThrow(IGLOO_ROAD_PROCESSOR)), (Object)5), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("igloo/road_2"), (Holder)processors.getOrThrow(IGLOO_ROAD_PROCESSOR)), (Object)2), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("igloo/road_3"), (Holder)processors.getOrThrow(IGLOO_ROAD_PROCESSOR)), (Object)2), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("igloo/road_4"), (Holder)processors.getOrThrow(IGLOO_ROAD_PROCESSOR)), (Object)4), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("igloo/road_5"), (Holder)processors.getOrThrow(IGLOO_ROAD_PROCESSOR)), (Object)1)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        context.register(YETI, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("igloo/mobs/yeti")), (Object)3), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("igloo/mobs/yeti_child")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(FROST_CASTLE_ENTRANCE, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/entrance/entrance"), (Holder)processors.getOrThrow(FROST_CASTLE_MAGMA_PROCESSOR)), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Holder.Reference holder7 = holdergetter2.getOrThrow(FROST_CASTLE_BRIDGE_END);
        context.register(FROST_CASTLE_MAIN, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/main_castle")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(FROST_CASTLE_ROOM_1, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/room/room_1_1")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/room/room_1_2")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/room/room_1_3")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/room/room_1_4")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(FROST_CASTLE_ROOM_2, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/room/room_2_1")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/room/room_2_2")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/room/room_2_3")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(FROST_CASTLE_BRIDGE_END, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/bridge/bridge_end"), (Holder)processors.getOrThrow(FROST_CASTLE_MAGMA_PROCESSOR)), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(FROST_CASTLE_BRIDGE, (Object)new StructureTemplatePool((Holder)holder7, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/bridge/bridge_watchtower"), (Holder)processors.getOrThrow(FROST_CASTLE_MAGMA_PROCESSOR)), (Object)2), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/bridge/bridge_1"), (Holder)processors.getOrThrow(FROST_CASTLE_MAGMA_PROCESSOR)), (Object)5), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/bridge/mini_watch_tower"), (Holder)processors.getOrThrow(FROST_CASTLE_MAGMA_PROCESSOR)), (Object)2), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/bridge/fogotten_legend"), (Holder)processors.getOrThrow(FROST_CASTLE_MAGMA_PROCESSOR)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/bridge/t_bridge"), (Holder)processors.getOrThrow(FROST_CASTLE_MAGMA_PROCESSOR)), (Object)2)), StructureTemplatePool.Projection.RIGID));
        context.register(FROST_CASTLE_LESSER_WARRIOR, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/mobs/lesser_warrior")), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/mobs/empty")), (Object)2)), StructureTemplatePool.Projection.RIGID));
        context.register(FROST_CASTLE_WARRIOR, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/mobs/lesser_warrior")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(FROST_CASTLE_WALKER, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/mobs/empty")), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(FROST_CASTLE_SEEKER, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)FrostStructures.name("frost_castle/mobs/seeker")), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    public static void bootstrapProcessors(BootstrapContext<StructureProcessorList> context) {
        context.register(IGLOO_ROAD_PROCESSOR, (Object)new StructureProcessorList((List)ImmutableList.of((Object)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockMatchTest((Block)FrostBlocks.FRIGID_STONE.get()), (RuleTest)new BlockMatchTest(Blocks.WATER), Blocks.WATER.defaultBlockState()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)FrostBlocks.FRIGID_STONE.get(), 0.2f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)FrostBlocks.FROZEN_GRASS_BLOCK.get()).defaultBlockState()), (Object)new ProcessorRule((RuleTest)new BlockMatchTest((Block)FrostBlocks.FROZEN_GRASS_BLOCK.get()), (RuleTest)new BlockMatchTest(Blocks.WATER), Blocks.WATER.defaultBlockState()))))));
        context.register(FROST_CASTLE_MAGMA_PROCESSOR, (Object)new StructureProcessorList((List)ImmutableList.of((Object)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)FrostBlocks.PERMA_MAGMA.get(), 1.0f), (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)new LinearPosTest(1.0f, 0.25f, 0, 500), Blocks.LAVA.defaultBlockState()))))));
    }

    private static String name(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)name).toString();
    }
}

