/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity;

import baguchan.frostrealm.entity.HasContainerEntity;
import baguchan.frostrealm.entity.SnowChargeMob;
import baguchan.frostrealm.entity.brain.YetiAi;
import baguchan.frostrealm.entity.path.FrostPathNavigation;
import baguchan.frostrealm.registry.FrostEntities;
import baguchan.frostrealm.registry.FrostItems;
import baguchan.frostrealm.registry.FrostMemoryModuleType;
import baguchan.frostrealm.registry.FrostSensors;
import baguchan.frostrealm.registry.FrostSounds;
import baguchi.bagus_lib.register.ModSensors;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class Yeti
extends AgeableMob
implements HasContainerEntity,
SnowChargeMob,
InventoryCarrier {
    private static final EntityDataAccessor<String> DATA_STATE = SynchedEntityData.defineId(Yeti.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Long> LAST_POSE_CHANGE_TICK = SynchedEntityData.defineId(Yeti.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Yeti>>> SENSOR_TYPES = ImmutableList.of((Object)((SensorType)ModSensors.SMART_NEAREST_LIVING_ENTITY_SENSOR.get()), (Object)SensorType.NEAREST_ADULT, (Object)SensorType.HURT_BY, FrostSensors.YETI_SENSOR.get(), FrostSensors.ENEMY_SENSOR.get(), (Object)SensorType.NEAREST_ITEMS);
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.NEAREST_VISIBLE_ADULT, (Object[])new MemoryModuleType[]{MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.NEAREST_ATTACKABLE, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.HAS_HUNTING_COOLDOWN, MemoryModuleType.IS_PANICKING, FrostMemoryModuleType.NEAREST_ENEMYS.get(), FrostMemoryModuleType.NEAREST_ENEMY_COUNT.get(), MemoryModuleType.AVOID_TARGET, FrostMemoryModuleType.NEAREST_YETIS.get(), FrostMemoryModuleType.YETI_COUNT.get(), MemoryModuleType.ANGRY_AT, MemoryModuleType.UNIVERSAL_ANGER, MemoryModuleType.HUNTED_RECENTLY, MemoryModuleType.HOME, MemoryModuleType.ADMIRING_ITEM, MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM, MemoryModuleType.ADMIRING_DISABLED, MemoryModuleType.DISABLE_WALK_TO_ADMIRE_ITEM, MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, FrostMemoryModuleType.TAKE_BACK_TARGET.get(), FrostMemoryModuleType.TAKE_BACK_COOLDOWN.get()});
    private static final EntityDimensions SITTING_DIMENSIONS = EntityDimensions.scalable((float)((EntityType)FrostEntities.YETI.get()).getWidth(), (float)(((EntityType)FrostEntities.YETI.get()).getHeight() - 0.35f)).withEyeHeight(1.4f);
    private final SimpleContainer inventory = new SimpleContainer(5);
    private int holdTime;
    public final AnimationState sitAnimationState = new AnimationState();
    public final AnimationState sitPoseAnimationState = new AnimationState();
    public final AnimationState sitUpAnimationState = new AnimationState();
    public final AnimationState noticedStealerAnimationState = new AnimationState();
    public final AnimationState snowChargeAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    private int ticksIdle = 1200;

    public Yeti(EntityType<? extends Yeti> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
        this.getNavigation().setCanFloat(true);
        this.setCanPickUpLoot(true);
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("yetiBrain");
        this.getBrain().tick(serverLevel, (LivingEntity)this);
        profiler.pop();
        profiler.push("yetiActivityUpdate");
        YetiAi.updateActivity(this);
        profiler.pop();
        if (this.isAlive()) {
            ItemStack offhand = this.getItemInHand(InteractionHand.MAIN_HAND);
            if (!this.isUsingItem() && offhand.isEmpty()) {
                ItemStack food = ItemStack.EMPTY;
                if (this.getHealth() < this.getMaxHealth() && this.random.nextFloat() < 0.0025f) {
                    food = this.findFood();
                }
                if (!food.isEmpty()) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, food);
                    this.startUsingItem(InteractionHand.MAIN_HAND);
                }
            }
            if (!this.isBaby() && --this.holdTime <= 0) {
                YetiAi.stopHoldingOffHandItem(serverLevel, this, true);
            }
            if (this.isYetiSitting()) {
                if (this.ticksIdle > 0) {
                    --this.ticksIdle;
                } else {
                    serverLevel.broadcastEntityEvent((Entity)this, (byte)5);
                    this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)FrostItems.YETI_FUR.asItem(), 1));
                    this.ticksIdle = 1200 + this.random.nextInt(600);
                }
            }
        }
    }

    protected Brain.Provider<Yeti> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> p_35064_) {
        return YetiAi.makeBrain(this, (Brain<Yeti>)this.brainProvider().makeBrain(p_35064_));
    }

    public Brain<Yeti> getBrain() {
        return super.getBrain();
    }

    @javax.annotation.Nullable
    public LivingEntity getTarget() {
        return this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_STATE, (Object)State.IDLING.name());
        builder.define(LAST_POSE_CHANGE_TICK, (Object)0L);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_312373_) {
        if (this.level().isClientSide() && DATA_STATE.equals(p_312373_)) {
            if (this.isSameStatue(State.CHASING)) {
                this.noticedStealerAnimationState.start(this.tickCount);
            }
            if (this.isSameStatue(State.SNOWBALL_MAKING)) {
                this.snowChargeAnimationState.start(this.tickCount);
            } else {
                this.snowChargeAnimationState.stop();
            }
        }
        super.onSyncedDataUpdated(p_312373_);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)FrostSounds.YETI_IDLE.get();
    }

    public boolean isYetiSitting() {
        return (Long)this.entityData.get(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public boolean isYetiVisuallySitting() {
        return this.getPoseTime() < 0L != this.isYetiSitting();
    }

    public boolean isInPoseTransition() {
        long i = this.getPoseTime();
        return i < (long)(this.isYetiSitting() ? 40 : 52);
    }

    private boolean isVisuallySittingDown() {
        return this.isYetiSitting() && this.getPoseTime() < 40L && this.getPoseTime() >= 0L;
    }

    public void sitDown() {
        if (!this.isYetiSitting()) {
            this.setPose(Pose.SITTING);
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.resetLastPoseChangeTick(-this.level().getGameTime());
        }
    }

    public void standUp() {
        if (this.isYetiSitting()) {
            this.setPose(Pose.STANDING);
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.resetLastPoseChangeTick(this.level().getGameTime());
        }
    }

    public void standUpInstantly() {
        this.setPose(Pose.STANDING);
        this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
        this.resetLastPoseChangeTickToFullStand(this.level().getGameTime());
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long p_248642_) {
        this.entityData.set(LAST_POSE_CHANGE_TICK, (Object)p_248642_);
    }

    private void resetLastPoseChangeTickToFullStand(long p_265447_) {
        this.resetLastPoseChangeTick(Math.max(0L, p_265447_ - 52L - 1L));
    }

    public long getPoseTime() {
        return this.level().getGameTime() - Math.abs((Long)this.entityData.get(LAST_POSE_CHANGE_TICK));
    }

    public boolean canYetiChangePose() {
        return this.wouldNotSuffocateAtTargetPose(this.isYetiSitting() ? Pose.STANDING : Pose.SITTING) && State.get(this.getState()) == State.IDLING && this.getTarget() == null;
    }

    public boolean refuseToMove() {
        return this.isYetiSitting() || this.isInPoseTransition();
    }

    public boolean isTrade() {
        return State.get((String)this.entityData.get(DATA_STATE)) == State.TRADE;
    }

    public boolean isSameStatue(State state) {
        return State.get((String)this.entityData.get(DATA_STATE)) == state;
    }

    public void setState(State state) {
        this.standUpInstantly();
        this.entityData.set(DATA_STATE, (Object)state.name());
    }

    private void setStateName(String state) {
        this.entityData.set(DATA_STATE, (Object)state);
    }

    public String getState() {
        return (String)this.entityData.get(DATA_STATE);
    }

    protected PathNavigation createNavigation(Level p_33348_) {
        return new FrostPathNavigation((Mob)this, p_33348_);
    }

    public static AttributeSupplier.Builder createAttributeMap() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.26f).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    protected void completeUsingItem() {
        ItemStack copy;
        InteractionHand hand = this.getUsedItemHand();
        if (this.useItem.equals(this.getItemInHand(hand)) && !this.useItem.isEmpty() && this.isUsingItem() && (copy = this.useItem.copy()).get(DataComponents.FOOD) != null) {
            FoodProperties foodproperties = (FoodProperties)copy.get(DataComponents.FOOD);
            float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
            this.heal(f);
        }
        super.completeUsingItem();
    }

    public InteractionResult mobInteract(Player p_34745_, InteractionHand p_34746_) {
        InteractionResult interactionresult = super.mobInteract(p_34745_, p_34746_);
        if (interactionresult.consumesAction()) {
            return interactionresult;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            return YetiAi.mobInteract(serverlevel, this, p_34745_, p_34746_);
        }
        boolean flag = YetiAi.canAdmire(this, p_34745_.getItemInHand(p_34746_)) && State.get(this.getState()) != State.TRADE;
        boolean flag2 = this.isTrade();
        return (InteractionResult)(flag || flag2 ? InteractionResult.SUCCESS : InteractionResult.PASS);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.isYetiSitting() && this.isInWater()) {
            this.standUpInstantly();
        }
    }

    public void handleEntityEvent(byte p_21375_) {
        super.handleEntityEvent(p_21375_);
        if (p_21375_ == 5) {
            this.idleAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(p_21375_);
        }
    }

    private void setupAnimationStates() {
        if (this.isYetiVisuallySitting()) {
            this.sitUpAnimationState.stop();
            if (this.isVisuallySittingDown()) {
                this.sitAnimationState.startIfStopped(this.tickCount);
                this.sitPoseAnimationState.stop();
            } else {
                this.sitAnimationState.stop();
                this.sitPoseAnimationState.startIfStopped(this.tickCount);
            }
        } else {
            this.sitAnimationState.stop();
            this.sitPoseAnimationState.stop();
            this.sitUpAnimationState.animateWhen(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.tickCount);
        }
    }

    public void aiStep() {
        this.updateSwingTime();
        super.aiStep();
    }

    public ItemStack hasFood() {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty() || itemstack.get(DataComponents.FOOD) == null) continue;
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack findFood() {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty() || itemstack.get(DataComponents.FOOD) == null) continue;
            return itemstack.split(1);
        }
        return ItemStack.EMPTY;
    }

    public boolean wantsToPickUp(ServerLevel serverLevel, ItemStack p_34777_) {
        return EventHooks.canEntityGrief((ServerLevel)serverLevel, (Entity)this) && this.canPickUpLoot() && YetiAi.wantsToPickup(this, p_34777_);
    }

    public void pickUpItem(ServerLevel serverLevel, ItemEntity p_175445_1_) {
        ItemStack itemstack = p_175445_1_.getItem();
        Item item = itemstack.getItem();
        if (itemstack.get(DataComponents.FOOD) != null) {
            this.onItemPickup(p_175445_1_);
            this.take((Entity)p_175445_1_, itemstack.getCount());
            ItemStack itemstack1 = this.inventory.addItem(itemstack);
            if (itemstack1.isEmpty()) {
                p_175445_1_.discard();
            } else {
                itemstack.setCount(itemstack1.getCount());
            }
        } else {
            super.pickUpItem(serverLevel, p_175445_1_);
        }
    }

    public void holdInOffHand(ItemStack p_34784_) {
        this.setItemSlotAndDropWhenKilled(EquipmentSlot.OFFHAND, p_34784_);
    }

    public ItemStack addToInventory(ItemStack p_34779_) {
        return this.inventory.addItem(p_34779_);
    }

    public boolean canAddToInventory(ItemStack p_34781_) {
        return this.inventory.canAddItem(p_34781_);
    }

    @Override
    public SimpleContainer getInventory() {
        return this.inventory;
    }

    protected void dropEquipment(ServerLevel serverLevel) {
        super.dropEquipment(serverLevel);
        this.inventory.removeAllItems().forEach(item -> this.spawnAtLocation(serverLevel, (ItemStack)item));
    }

    public void setHoldTime(int holdTime) {
        this.holdTime = holdTime;
    }

    public int getHoldTime() {
        return this.holdTime;
    }

    public void readAdditionalSaveData(ValueInput p_29541_) {
        super.readAdditionalSaveData(p_29541_);
        this.setHoldTime(p_29541_.getIntOr("HoldTime", 0));
        this.setStateName(p_29541_.getStringOr("State", "IDLING"));
        long i = p_29541_.getLongOr("LastPoseTick", 0L);
        if (i < 0L) {
            this.setPose(Pose.SITTING);
        }
        this.ticksIdle = p_29541_.getIntOr("IdleTime", 0);
        this.resetLastPoseChangeTick(i);
    }

    public void addAdditionalSaveData(ValueOutput p_29548_) {
        super.addAdditionalSaveData(p_29548_);
        p_29548_.putInt("HoldTime", this.holdTime);
        p_29548_.putInt("IdleTime", this.ticksIdle);
        p_29548_.putString("State", this.getState());
        p_29548_.putLong("LastPoseTick", ((Long)this.entityData.get(LAST_POSE_CHANGE_TICK)).longValue());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_29533_, DifficultyInstance p_29534_, EntitySpawnReason p_29535_, @javax.annotation.Nullable SpawnGroupData p_29536_) {
        if (p_29536_ == null) {
            p_29536_ = p_29535_ == EntitySpawnReason.PATROL ? new YetiGroupData(true, 0.0f) : new YetiGroupData(false, 1.0f);
        }
        this.inventory.addItem(new ItemStack((ItemLike)Items.SALMON, 4));
        YetiAi.initMemories(this, p_29533_.getRandom(), p_29535_);
        this.resetLastPoseChangeTickToFullStand(p_29533_.getLevel().getGameTime());
        if (p_29535_ == EntitySpawnReason.STRUCTURE) {
            GlobalPos globalpos = GlobalPos.of((ResourceKey)p_29533_.getLevel().dimension(), (BlockPos)this.blockPosition());
            this.getBrain().setMemory(MemoryModuleType.HOME, (Object)globalpos);
        }
        this.populateDefaultEquipmentSlots(p_29533_.getRandom(), p_29534_);
        this.populateDefaultEquipmentEnchantments(p_29533_, p_29533_.getRandom(), p_29534_);
        return super.finalizeSpawn(p_29533_, p_29534_, p_29535_, p_29536_);
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_219165_, DifficultyInstance p_219166_) {
        if (p_219165_.nextFloat() < 0.1f) {
            this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)FrostItems.FROST_BOAR_FUR_HELMET.get()));
        }
    }

    public boolean doHurtTarget(ServerLevel serverLevel, Entity p_21372_) {
        if (p_21372_ instanceof LivingEntity) {
            YetiAi.onHitTarget(this, (LivingEntity)p_21372_);
        }
        return super.doHurtTarget(serverLevel, p_21372_);
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource p_34503_, float p_34504_) {
        boolean flag = super.hurtServer(serverLevel, p_34503_, p_34504_);
        if (this.level().isClientSide()) {
            return false;
        }
        this.standUpInstantly();
        YetiAi.stopHoldingOffHandItem(serverLevel, this, false);
        if (flag && p_34503_.getEntity() instanceof LivingEntity) {
            YetiAi.wasHurtBy(serverLevel, this, (LivingEntity)p_34503_.getEntity());
        }
        return flag;
    }

    public EntityDimensions getDefaultDimensions(Pose p_316664_) {
        return p_316664_ == Pose.SITTING ? SITTING_DIMENSIONS.scale(this.getAgeScale()) : super.getDefaultDimensions(p_316664_);
    }

    @javax.annotation.Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        return (AgeableMob)((EntityType)FrostEntities.YETI.get()).create((Level)p_146743_, EntitySpawnReason.BREEDING);
    }

    public boolean removeWhenFarAway(double p_21542_) {
        return false;
    }

    public boolean isAdult() {
        return !this.isBaby();
    }

    public boolean isMeleeAttack() {
        return this.isAdult() && !this.isSnowCharge();
    }

    public boolean isSnowAttack() {
        return this.isAdult() && this.isSnowCharge();
    }

    public boolean canAttack(LivingEntity p_186270_) {
        return p_186270_ instanceof Yeti ? false : super.canAttack(p_186270_);
    }

    protected boolean considersEntityAsAlly(Entity p_360600_) {
        if (super.considersEntityAsAlly(p_360600_)) {
            return true;
        }
        return p_360600_.getType() != FrostEntities.YETI.get() ? false : this.getTeam() == null && p_360600_.getTeam() == null;
    }

    @Override
    public void setSnowCharge(boolean b) {
        if (b) {
            this.setState(State.SNOWBALL_MAKING);
        } else {
            this.setState(State.IDLING);
        }
    }

    @Override
    public boolean isSnowCharge() {
        return State.get(this.getState()) == State.SNOWBALL_MAKING;
    }

    public static enum State {
        IDLING,
        TRADE,
        PANIC,
        SNOWBALL_MAKING,
        CHASING,
        CHEER;


        public static State get(String nameIn) {
            for (State role : State.values()) {
                if (!role.name().equals(nameIn)) continue;
                return role;
            }
            return IDLING;
        }
    }

    public static class YetiGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final boolean isHunt;
        public final float child;

        public YetiGroupData(boolean p_34358_, float child) {
            super(false);
            this.isHunt = p_34358_;
            this.child = child;
        }
    }
}

