/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.animal;

import baguchan.frostrealm.block.crop.BearBerryBushBlock;
import baguchan.frostrealm.entity.animal.FrostAnimal;
import baguchan.frostrealm.entity.animal.Wolfflue;
import baguchan.frostrealm.entity.goal.FoxSittingGoal;
import baguchan.frostrealm.entity.goal.FoxSleepGoal;
import baguchan.frostrealm.entity.goal.SeekShelterEvenBlizzardGoal;
import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.registry.FrostEntities;
import baguchan.frostrealm.registry.FrostItems;
import baguchan.frostrealm.registry.FrostTags;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class CrystalFox
extends FrostAnimal
implements IShearable {
    private static final EntityDimensions BABY_DIMENSIONS = ((EntityType)FrostEntities.CRYSTAL_FOX.get()).getDimensions().scale(0.5f).withEyeHeight(0.2f);
    private static final Codec<List<EntityReference<LivingEntity>>> TRUSTED_LIST_CODEC = EntityReference.codec().listOf();
    private static final EntityDataAccessor<Boolean> SHEARABLE = SynchedEntityData.defineId(CrystalFox.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> DATA_STATE = SynchedEntityData.defineId(CrystalFox.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Optional<EntityReference<LivingEntity>>> DATA_TRUSTED_ID_0 = SynchedEntityData.defineId(CrystalFox.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_LIVING_ENTITY_REFERENCE);
    private static final EntityDataAccessor<Optional<EntityReference<LivingEntity>>> DATA_TRUSTED_ID_1 = SynchedEntityData.defineId(CrystalFox.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_LIVING_ENTITY_REFERENCE);
    public static final Predicate<LivingEntity> FROST_PREY_SELECTOR = p_30437_ -> {
        EntityType entitytype = p_30437_.getType();
        return entitytype == FrostEntities.SNOWPILE_QUAIL.get();
    };
    private static final Predicate<Entity> AVOID_PLAYERS = p_28463_ -> !p_28463_.isDiscrete() && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(p_28463_);
    public final AnimationState eatAnimationState = new AnimationState();
    private int ticksSinceEaten;

    public CrystalFox(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
        this.setCanPickUpLoot(true);
    }

    public EntityDimensions getDefaultDimensions(Pose p_316516_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_316516_);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, (double)2.2f));
        this.goalSelector.addGoal(2, (Goal)new FoxSittingGoal(this));
        this.goalSelector.addGoal(3, (Goal)new FoxSleepGoal(this));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 0.95));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 1.6, 1.4, p_28596_ -> AVOID_PLAYERS.test((Entity)p_28596_) && !this.trusts((LivingEntity)p_28596_)));
        this.goalSelector.addGoal(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolfflue.class, 8.0f, 1.55, 1.45, p_28590_ -> !((Wolfflue)((Object)p_28590_)).isTame()));
        this.goalSelector.addGoal(7, (Goal)new FoxMeleeAttackGoal(1.2f, true));
        this.goalSelector.addGoal(8, (Goal)new SeekShelterEvenBlizzardGoal((PathfinderMob)this, 1.25, true));
        this.goalSelector.addGoal(9, (Goal)new FoxEatBerriesGoal(1.25, 8, 4));
        this.goalSelector.addGoal(10, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(12, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, false, (living, serverlevel) -> FROST_PREY_SELECTOR.test(living)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.SAFE_FALL_DISTANCE, 9.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHEARABLE, (Object)true);
        builder.define(DATA_STATE, (Object)State.IDLING.name());
        builder.define(DATA_TRUSTED_ID_0, Optional.empty());
        builder.define(DATA_TRUSTED_ID_1, Optional.empty());
    }

    public void setState(State state) {
        this.entityData.set(DATA_STATE, (Object)state.name());
    }

    private void setStateName(String state) {
        this.entityData.set(DATA_STATE, (Object)state);
    }

    public String getState() {
        return (String)this.entityData.get(DATA_STATE);
    }

    public boolean isSleeping() {
        return Objects.equals(this.getState(), State.SLEEPING.name());
    }

    public boolean isShearable(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        return this.readyForShearing();
    }

    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby() && this.isShearableWithoutConditions();
    }

    public boolean isShearableWithoutConditions() {
        return (Boolean)this.entityData.get(SHEARABLE);
    }

    public void setShearable(boolean shear) {
        this.entityData.set(SHEARABLE, (Object)shear);
    }

    Stream<EntityReference<LivingEntity>> getTrustedEntities() {
        return Stream.concat(((Optional)this.entityData.get(DATA_TRUSTED_ID_0)).stream(), ((Optional)this.entityData.get(DATA_TRUSTED_ID_1)).stream());
    }

    void addTrustedEntity(LivingEntity p_393835_) {
        this.addTrustedEntity((EntityReference<LivingEntity>)EntityReference.of((UniquelyIdentifyable)p_393835_));
    }

    private void addTrustedEntity(EntityReference<LivingEntity> p_393599_) {
        if (((Optional)this.entityData.get(DATA_TRUSTED_ID_0)).isPresent()) {
            this.entityData.set(DATA_TRUSTED_ID_1, Optional.of(p_393599_));
        } else {
            this.entityData.set(DATA_TRUSTED_ID_0, Optional.of(p_393599_));
        }
    }

    boolean trusts(LivingEntity p_394151_) {
        return this.getTrustedEntities().anyMatch(p_393132_ -> p_393132_.matches((UniquelyIdentifyable)p_394151_));
    }

    public boolean isFood(ItemStack p_27600_) {
        return p_27600_.is(FrostTags.Items.CRYSTAL_FOX_FOODS);
    }

    public void aiStep() {
        if (!this.level().isClientSide() && this.isAlive() && this.isEffectiveAi()) {
            ++this.ticksSinceEaten;
            ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
            if (this.canEat(itemstack)) {
                if (this.ticksSinceEaten > 600) {
                    ItemStack itemstack1 = itemstack.finishUsingItem(this.level(), (LivingEntity)this);
                    this.heal(2.0f);
                    if (!itemstack1.isEmpty()) {
                        this.setItemSlot(EquipmentSlot.MAINHAND, itemstack1);
                    }
                    if (itemstack1.is((Item)FrostItems.BEARBERRY.get())) {
                        itemstack1.shrink(1);
                        this.setShearable(true);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.random.nextFloat() < 0.1f) {
                    this.playSound(SoundEvents.FOX_EAT, 1.0f, 1.0f);
                    this.level().broadcastEntityEvent((Entity)this, (byte)45);
                }
            }
            LivingEntity livingEntity = this.getTarget();
        }
        if (this.isSleeping() || this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        }
        super.aiStep();
    }

    protected void pickUpItem(ServerLevel serverLevel, ItemEntity p_28514_) {
        ItemStack itemstack = p_28514_.getItem();
        if (this.canHoldItem(itemstack)) {
            int i = itemstack.getCount();
            if (i > 1) {
                this.dropItemStack(itemstack.split(i - 1));
            }
            this.spitOutItem(this.getItemBySlot(EquipmentSlot.MAINHAND));
            this.onItemPickup(p_28514_);
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack.split(1));
            this.setGuaranteedDrop(EquipmentSlot.MAINHAND);
            this.take((Entity)p_28514_, itemstack.getCount());
            p_28514_.discard();
            this.ticksSinceEaten = 0;
        }
    }

    private void spitOutItem(ItemStack p_28602_) {
        if (!p_28602_.isEmpty() && !this.level().isClientSide()) {
            ItemEntity itementity = new ItemEntity(this.level(), this.getX() + this.getLookAngle().x, this.getY() + 1.0, this.getZ() + this.getLookAngle().z, p_28602_);
            itementity.setPickUpDelay(40);
            itementity.setThrower((Entity)this);
            this.playSound(SoundEvents.FOX_SPIT, 1.0f, 1.0f);
            this.level().addFreshEntity((Entity)itementity);
        }
    }

    private void dropItemStack(ItemStack p_28606_) {
        ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), p_28606_);
        this.level().addFreshEntity((Entity)itementity);
    }

    public boolean canHoldItem(ItemStack p_28578_) {
        Item item = p_28578_.getItem();
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        return itemstack.isEmpty() || this.ticksSinceEaten > 0 && (p_28578_.get(DataComponents.FOOD) != null || item == FrostItems.BEARBERRY.get()) && p_28578_.get(DataComponents.FOOD) == null && !itemstack.is((Item)FrostItems.BEARBERRY.get());
    }

    private boolean canEat(ItemStack p_28598_) {
        return (p_28598_.get(DataComponents.FOOD) != null || p_28598_.is((Item)FrostItems.BEARBERRY.get())) && this.getTarget() == null && this.onGround() && !this.isSleeping();
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        if (player == null || this.trusts((LivingEntity)player)) {
            level.playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
            this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
            if (!level.isClientSide()) {
                this.setShearable(false);
                int i = 1 + this.random.nextInt(3);
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (int j = 0; j < i; ++j) {
                    items.add(new ItemStack((ItemLike)FrostItems.CRYONITE.get()));
                }
                return items;
            }
        } else if (player != null) {
            player.hurt(this.damageSources().thorns((Entity)this), 2.0f);
            player.getCooldowns().addCooldown(item, 80);
        }
        return Collections.emptyList();
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource p_32820_, float p_32821_) {
        Entity entity;
        if (this.isShearableWithoutConditions() && !p_32820_.is(DamageTypes.MAGIC) && (entity = p_32820_.getDirectEntity()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            if (!p_32820_.is(DamageTypeTags.IS_EXPLOSION)) {
                livingentity.hurtServer(serverLevel, this.damageSources().thorns((Entity)this), 2.0f);
            }
        }
        return super.hurtServer(serverLevel, p_32820_, p_32821_);
    }

    @javax.annotation.Nullable
    @Nullable
    protected SoundEvent getAmbientSound() {
        List list;
        if (this.isSleeping()) {
            return SoundEvents.FOX_SLEEP;
        }
        if (!this.level().isBrightOutside() && this.random.nextFloat() < 0.1f && (list = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(16.0, 16.0, 16.0), EntitySelector.NO_SPECTATORS)).isEmpty()) {
            return SoundEvents.FOX_SCREECH;
        }
        return SoundEvents.FOX_AMBIENT;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_21239_) {
        return SoundEvents.FOX_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.FOX_DEATH;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        return (AgeableMob)((EntityType)FrostEntities.CRYSTAL_FOX.get()).create((Level)p_146743_, EntitySpawnReason.BREEDING);
    }

    public InteractionResult mobInteract(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
        Item item = itemstack.getItem();
        if (this.trusts((LivingEntity)p_30412_)) {
            if (this.isFood(itemstack) && (this.getHealth() < this.getMaxHealth() || !this.isShearableWithoutConditions())) {
                if (!p_30412_.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                if (!this.level().isClientSide() && !this.isShearableWithoutConditions()) {
                    if (this.random.nextInt(3) == 0) {
                        this.setShearable(true);
                    }
                    this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
                    return InteractionResult.SUCCESS_SERVER;
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)5);
                this.playSound(SoundEvents.FOX_EAT, 1.0f, 1.0f);
                this.heal(itemstack.get(DataComponents.FOOD) != null ? (float)((FoodProperties)itemstack.get(DataComponents.FOOD)).nutrition() : 1.0f);
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)this);
                return InteractionResult.SUCCESS;
            }
        } else if (itemstack.is(FrostTags.Items.CRYSTAL_FOX_FOODS) && this.getTarget() == null) {
            if (!p_30412_.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            if (this.random.nextInt(5) == 0) {
                this.addTrustedEntity((LivingEntity)p_30412_);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.mobInteract(p_30412_, p_30413_);
    }

    protected void spawnTamingParticles(boolean p_21835_) {
        SimpleParticleType particleoptions = ParticleTypes.HEART;
        if (!p_21835_) {
            particleoptions = ParticleTypes.SMOKE;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)particleoptions, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    public void handleEntityEvent(byte p_21807_) {
        if (p_21807_ == 5) {
            this.eatAnimationState.start(this.tickCount);
        } else if (p_21807_ == 7) {
            this.spawnTamingParticles(true);
        } else if (p_21807_ == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.handleEntityEvent(p_21807_);
        }
    }

    public void readAdditionalSaveData(ValueInput p_27576_) {
        super.readAdditionalSaveData(p_27576_);
        this.clearTrusted();
        p_27576_.read("Trusted", TRUSTED_LIST_CODEC).orElse(List.of()).forEach(this::addTrustedEntity);
        this.setShearable(p_27576_.getBooleanOr("Shearable", false));
        this.setStateName(p_27576_.getStringOr("State", "IDLING"));
    }

    private void clearTrusted() {
        this.entityData.set(DATA_TRUSTED_ID_0, Optional.empty());
        this.entityData.set(DATA_TRUSTED_ID_1, Optional.empty());
    }

    public void addAdditionalSaveData(ValueOutput p_27587_) {
        super.addAdditionalSaveData(p_27587_);
        p_27587_.store("Trusted", TRUSTED_LIST_CODEC, this.getTrustedEntities().toList());
        p_27587_.putBoolean("Shearable", this.isShearableWithoutConditions());
        p_27587_.putString("State", this.getState());
    }

    class FoxMeleeAttackGoal
    extends MeleeAttackGoal {
        public FoxMeleeAttackGoal(double p_28720_, boolean p_28721_) {
            super((PathfinderMob)CrystalFox.this, p_28720_, p_28721_);
        }

        protected void checkAndPerformAttack(LivingEntity p_28724_) {
            if (this.canPerformAttack(p_28724_)) {
                this.resetAttackCooldown();
                this.mob.doHurtTarget(FoxMeleeAttackGoal.getServerLevel((Level)this.mob.level()), (Entity)p_28724_);
                CrystalFox.this.playSound(SoundEvents.FOX_BITE, 1.0f, 1.0f);
            }
        }

        public void start() {
            super.start();
        }

        public boolean canUse() {
            return super.canUse();
        }
    }

    public class FoxEatBerriesGoal
    extends MoveToBlockGoal {
        private static final int WAIT_TICKS = 40;
        protected int ticksWaited;

        public FoxEatBerriesGoal(double p_28675_, int p_28676_, int p_28677_) {
            super((PathfinderMob)CrystalFox.this, p_28675_, p_28676_, p_28677_);
        }

        public double acceptedDistance() {
            return 2.0;
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 100 == 0;
        }

        protected boolean isValidTarget(LevelReader p_28680_, BlockPos p_28681_) {
            BlockState blockstate = p_28680_.getBlockState(p_28681_);
            return blockstate.is((Block)FrostBlocks.BEARBERRY_BUSH.get()) && (Integer)blockstate.getValue((Property)BearBerryBushBlock.AGE) > 2;
        }

        public void tick() {
            if (this.isReachedTarget()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            } else if (!this.isReachedTarget() && CrystalFox.this.random.nextFloat() < 0.05f) {
                CrystalFox.this.playSound(SoundEvents.FOX_SNIFF, 1.0f, 1.0f);
            }
            super.tick();
        }

        protected void onReachedTarget() {
            BlockState blockstate;
            if (EventHooks.canEntityGrief((ServerLevel)FoxEatBerriesGoal.getServerLevel((Level)CrystalFox.this.level()), (Entity)CrystalFox.this) && (blockstate = CrystalFox.this.level().getBlockState(this.blockPos)).is((Block)FrostBlocks.BEARBERRY_BUSH.get())) {
                this.pickBearBerry(blockstate);
            }
        }

        private void pickBearBerry(BlockState p_148929_) {
            int i = (Integer)p_148929_.getValue((Property)BearBerryBushBlock.AGE);
            p_148929_.setValue((Property)BearBerryBushBlock.AGE, (Comparable)Integer.valueOf(1));
            int j = 1 + CrystalFox.this.level().random.nextInt(2) + (i == 3 ? 1 : 0);
            ItemStack itemstack = CrystalFox.this.getItemBySlot(EquipmentSlot.MAINHAND);
            if (itemstack.isEmpty()) {
                CrystalFox.this.heal(1.0f);
                CrystalFox.this.setShearable(true);
                --j;
            }
            if (j > 0) {
                Block.popResource((Level)CrystalFox.this.level(), (BlockPos)this.blockPos, (ItemStack)new ItemStack((ItemLike)FrostItems.BEARBERRY.get(), j));
            }
            CrystalFox.this.level().broadcastEntityEvent((Entity)CrystalFox.this, (byte)5);
            CrystalFox.this.playSound(SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, 1.0f, 1.0f);
            CrystalFox.this.level().setBlock(this.blockPos, (BlockState)p_148929_.setValue((Property)BearBerryBushBlock.AGE, (Comparable)Integer.valueOf(1)), 2);
        }

        public boolean canUse() {
            return !CrystalFox.this.isSleeping() && super.canUse();
        }

        public void start() {
            this.ticksWaited = 0;
            super.start();
        }
    }

    public static enum State {
        IDLING,
        SITTING,
        SLEEPING,
        JUMPING,
        FACE_PLANTING;


        public static State get(String nameIn) {
            for (State role : State.values()) {
                if (!role.name().equals(nameIn)) continue;
                return role;
            }
            return IDLING;
        }
    }
}

