/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.animal;

import baguchan.frostrealm.entity.animal.FrostAnimal;
import baguchan.frostrealm.entity.brain.FrostBoarAi;
import baguchan.frostrealm.registry.FrostEntities;
import baguchan.frostrealm.registry.FrostMemoryModuleType;
import baguchan.frostrealm.registry.FrostSensors;
import baguchan.frostrealm.registry.FrostTags;
import baguchi.bagus_lib.register.ModSensors;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FrostBoar
extends FrostAnimal {
    private static final EntityDimensions BABY_DIMENSIONS = ((EntityType)FrostEntities.FROST_BOAR.get()).getDimensions().scale(0.5f).withEyeHeight(0.75f);
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super FrostBoar>>> SENSOR_TYPES = ImmutableList.of((Object)((SensorType)ModSensors.SMART_NEAREST_LIVING_ENTITY_SENSOR.get()), (Object)SensorType.NEAREST_ADULT, (Object)SensorType.HURT_BY, FrostSensors.FROST_BOAR_SENSOR.get(), FrostSensors.ENEMY_SENSOR.get());
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.NEAREST_VISIBLE_ADULT, (Object[])new MemoryModuleType[]{MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.ANGRY_AT, MemoryModuleType.NEAREST_ATTACKABLE, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.HAS_HUNTING_COOLDOWN, MemoryModuleType.IS_PANICKING, FrostMemoryModuleType.NEAREST_ENEMYS.get(), FrostMemoryModuleType.NEAREST_ENEMY_COUNT.get(), MemoryModuleType.AVOID_TARGET, FrostMemoryModuleType.NEAREST_FROST_BOARS.get(), FrostMemoryModuleType.FROST_BOAR_COUNT.get()});
    private float runningScale;
    public AnimationState attackAnimation = new AnimationState();

    public FrostBoar(EntityType<? extends FrostBoar> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
        this.getNavigation().setCanFloat(true);
    }

    public EntityDimensions getDefaultDimensions(Pose p_316516_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_316516_);
    }

    public boolean isFood(ItemStack p_248671_) {
        return p_248671_.is(FrostTags.Items.FROST_BOAR_FOODS);
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("boarBrain");
        this.getBrain().tick(serverLevel, (LivingEntity)this);
        profiler.pop();
        profiler.push("boarActivityUpdate");
        FrostBoarAi.updateActivity(this);
        profiler.pop();
    }

    protected Brain.Provider<FrostBoar> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> p_35064_) {
        return FrostBoarAi.makeBrain(this, (Brain<FrostBoar>)this.brainProvider().makeBrain(p_35064_));
    }

    public Brain<FrostBoar> getBrain() {
        return super.getBrain();
    }

    @javax.annotation.Nullable
    public LivingEntity getTarget() {
        return this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MAX_HEALTH, 50.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.7f).add(Attributes.ATTACK_KNOCKBACK, 0.5).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    protected SoundEvent getAmbientSound() {
        return this.level().isClientSide() ? null : (SoundEvent)FrostBoarAi.getSoundForCurrentActivity(this).orElse(null);
    }

    protected SoundEvent getHurtSound(DamageSource p_34548_) {
        return SoundEvents.HOGLIN_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.HOGLIN_DEATH;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.HOSTILE_SWIM;
    }

    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.HOSTILE_SPLASH;
    }

    public void tick() {
        if (this.level().isClientSide() && this.isMoving()) {
            this.runningScale = this.isDashing() ? Mth.clamp((float)(this.runningScale + 0.1f), (float)0.0f, (float)1.0f) : Mth.clamp((float)(this.runningScale - 0.1f), (float)0.0f, (float)1.0f);
        }
        super.tick();
    }

    public float getRunningScale() {
        return this.runningScale;
    }

    private boolean isDashing() {
        return this.getDeltaMovement().horizontalDistanceSqr() > 0.02;
    }

    private boolean isMoving() {
        return this.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6;
    }

    public boolean doHurtTarget(ServerLevel serverLevel, Entity p_34491_) {
        if (!(p_34491_ instanceof LivingEntity)) {
            return false;
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound(SoundEvents.HOGLIN_ATTACK, 1.0f, this.getVoicePitch());
        FrostBoarAi.onHitTarget(this, (LivingEntity)p_34491_);
        return HoglinBase.hurtAndThrowTarget((ServerLevel)serverLevel, (LivingEntity)this, (LivingEntity)((LivingEntity)p_34491_));
    }

    public void handleEntityEvent(byte p_219360_) {
        if (p_219360_ == 4) {
            this.attackAnimation.start(this.tickCount);
        } else {
            super.handleEntityEvent(p_219360_);
        }
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource p_34503_, float p_34504_) {
        boolean flag = super.hurtServer(serverLevel, p_34503_, p_34504_);
        if (flag && p_34503_.getEntity() instanceof LivingEntity) {
            FrostBoarAi.wasHurtBy(serverLevel, this, (LivingEntity)p_34503_.getEntity());
        }
        return flag;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        FrostBoar frostboar = (FrostBoar)((EntityType)FrostEntities.FROST_BOAR.get()).create((Level)p_146743_, EntitySpawnReason.BREEDING);
        if (frostboar != null) {
            frostboar.setPersistenceRequired();
        }
        return frostboar;
    }

    public boolean isAdult() {
        return !this.isBaby();
    }

    public boolean canAttack(LivingEntity p_186270_) {
        return p_186270_ instanceof FrostBoar ? false : super.canAttack(p_186270_);
    }
}

