/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.animal;

import baguchan.frostrealm.block.SilkMoonEggBlock;
import baguchan.frostrealm.entity.IHasEgg;
import baguchan.frostrealm.entity.animal.FrostAnimal;
import baguchan.frostrealm.entity.goal.BreedAndEggGoal;
import baguchan.frostrealm.entity.goal.FindAndPlaceEggGoal;
import baguchan.frostrealm.entity.goal.RestrictFlyingSunGoal;
import baguchan.frostrealm.entity.goal.SeekShelterEvenBlizzardGoal;
import baguchan.frostrealm.entity.path.SunAvoidFlyingPathNavigation;
import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.registry.FrostEntities;
import baguchan.frostrealm.registry.FrostTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SilkMoon
extends FrostAnimal
implements IHasEgg {
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.defineId(SilkMoon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public SilkMoon(EntityType<? extends SilkMoon> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    public static boolean checkSilkSpawnRules(EntityType<? extends Animal> p_27578_, LevelAccessor p_27579_, EntitySpawnReason p_27580_, BlockPos p_27581_, RandomSource p_27582_) {
        return p_27579_.getBlockState(p_27581_.below()).is(FrostTags.Blocks.ANIMAL_SPAWNABLE) && p_27579_.getRawBrightness(p_27581_, 0) > 8;
    }

    @Override
    public float getWalkTargetValue(BlockPos p_27573_, LevelReader p_27574_) {
        return p_27574_.getPathfindingCostFromLightLevels(p_27573_) * 3.0f;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        return (AgeableMob)((EntityType)FrostEntities.SILK_MOON.get()).create((Level)p_146743_, EntitySpawnReason.BREEDING);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_EGG, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FindAndPlaceEggGoal<SilkMoon>(this, 0.85){

            @Override
            public void afterPlaceEgg() {
                SilkMoon.this.level().playSound(null, this.blockPos, SoundEvents.TURTLE_LAY_EGG, SoundSource.BLOCKS, 0.3f, 0.9f + SilkMoon.this.level().random.nextFloat() * 0.2f);
                SilkMoon.this.level().setBlock(this.blockPos, (BlockState)((Block)FrostBlocks.SILK_MOON_EGG.get()).defaultBlockState().setValue((Property)SilkMoonEggBlock.EGGS, (Comparable)Integer.valueOf(SilkMoon.this.random.nextInt(1) + 1)), 3);
            }

            protected boolean isValidTarget(LevelReader p_25619_, BlockPos p_25620_) {
                return SilkMoonEggBlock.onDirt((BlockGetter)p_25619_, p_25620_) && p_25619_.getBlockState(p_25620_).isAir();
            }
        });
        this.goalSelector.addGoal(1, new BreedAndEggGoal<SilkMoon>(this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.1, item -> item.is(ItemTags.LEAVES), false));
        this.goalSelector.addGoal(3, (Goal)new RestrictFlyingSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(4, (Goal)new SeekShelterEvenBlizzardGoal((PathfinderMob)this, 1.1, true){

            protected Vec3 getHidePos() {
                RandomSource randomsource = this.mob.getRandom();
                BlockPos blockpos = this.mob.blockPosition();
                for (int i = 0; i < 10; ++i) {
                    BlockPos blockpos1 = blockpos.offset(randomsource.nextInt(20) - 10, randomsource.nextInt(6) - 3, randomsource.nextInt(20) - 10);
                    if (SilkMoon.this.level().canSeeSky(blockpos1)) continue;
                    return Vec3.atBottomCenterOf((Vec3i)blockpos1);
                }
                return null;
            }
        });
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 0.95));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected PathNavigation createNavigation(Level p_29417_) {
        SunAvoidFlyingPathNavigation flyingpathnavigation = new SunAvoidFlyingPathNavigation((PathfinderMob)this, p_29417_);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        return flyingpathnavigation;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.21f).add(Attributes.FLYING_SPEED, (double)0.24f).add(Attributes.MAX_HEALTH, 12.0);
    }

    public void aiStep() {
        super.aiStep();
    }

    @Override
    public boolean hasEgg() {
        return (Boolean)this.entityData.get(HAS_EGG);
    }

    @Override
    public void setHasEgg(boolean hasEgg) {
        this.entityData.set(HAS_EGG, (Object)hasEgg);
    }

    public void travel(Vec3 p_21280_) {
        if (this.isLocalInstanceAuthoritative()) {
            if (this.isInWater()) {
                this.moveRelative(0.02f, p_21280_);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
            } else if (this.isInLava()) {
                this.moveRelative(0.02f, p_21280_);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            } else {
                this.moveRelative(this.getSpeed() * 0.21f, p_21280_);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.91f));
            }
        }
        this.calculateEntityAnimation(false);
    }

    public void addAdditionalSaveData(ValueOutput p_218709_) {
        super.addAdditionalSaveData(p_218709_);
    }

    public void readAdditionalSaveData(ValueInput p_218698_) {
        super.readAdditionalSaveData(p_218698_);
    }

    public boolean isFood(ItemStack p_27600_) {
        return p_27600_.is(ItemTags.LEAVES);
    }

    public boolean isBaby() {
        return false;
    }

    public void setBaby(boolean p_218500_) {
    }

    protected void checkFallDamage(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }
}

