/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.animal;

import baguchan.frostrealm.entity.goal.RandomMoveGoal;
import baguchan.frostrealm.entity.movecontrol.SnowMoveControl;
import baguchan.frostrealm.entity.path.SnowPathNavigation;
import baguchan.frostrealm.registry.FrostEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SnowMole
extends Animal {
    private static final EntityDimensions BABY_DIMENSIONS = ((EntityType)FrostEntities.SNOW_MOLE.get()).getDimensions().scale(0.5f).withEyeHeight(0.15f);

    public SnowMole(EntityType<? extends SnowMole> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
        this.moveControl = new SnowMoveControl((Mob)this, 85, 10, 3.0f);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
        this.setPathfindingMalus(PathType.POWDER_SNOW, 0.0f);
    }

    public EntityDimensions getDefaultDimensions(Pose p_316516_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_316516_);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new PanicGoal((PathfinderMob)this, (double)1.2f));
        this.goalSelector.addGoal(3, (Goal)new RandomMoveGoal((PathfinderMob)this, 1.0, 10));
    }

    public float getWalkTargetValue(BlockPos p_27573_, LevelReader p_27574_) {
        return p_27574_.getBlockState(p_27573_).is(Blocks.POWDER_SNOW) ? 10.0f : super.getWalkTargetValue(p_27573_, p_27574_);
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    protected PathNavigation createNavigation(Level p_27480_) {
        return new SnowPathNavigation((Mob)this, p_27480_);
    }

    public void travel(Vec3 p_27490_) {
        if (this.isEffectiveAi() && this.wasInPowderSnow) {
            this.moveRelative(this.getSpeed(), p_27490_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.6));
        } else {
            super.travel(p_27490_);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.MOVEMENT_SPEED, 0.24);
    }

    public static boolean checkSnowMoleSpawnRules(EntityType<? extends Animal> p_27578_, LevelAccessor p_27579_, EntitySpawnReason p_27580_, BlockPos p_27581_, RandomSource p_27582_) {
        return p_27579_.getBlockState(p_27581_.below()).is(Blocks.SNOW_BLOCK) && p_27579_.getBlockState(p_27581_).isAir();
    }

    public boolean checkSpawnObstruction(LevelReader p_30348_) {
        return p_30348_.isUnobstructed((Entity)this);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        return (AgeableMob)((EntityType)FrostEntities.SNOW_MOLE.get()).create((Level)p_146743_, EntitySpawnReason.BREEDING);
    }
}

