/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.animal;

import baguchan.frostrealm.block.SnowPileQuailEggBlock;
import baguchan.frostrealm.entity.IHasEgg;
import baguchan.frostrealm.entity.Yeti;
import baguchan.frostrealm.entity.animal.CrystalFox;
import baguchan.frostrealm.entity.animal.Ferret;
import baguchan.frostrealm.entity.animal.FrostAnimal;
import baguchan.frostrealm.entity.animal.Wolfflue;
import baguchan.frostrealm.entity.goal.BreedAndEggGoal;
import baguchan.frostrealm.entity.goal.FindAndPlaceEggGoal;
import baguchan.frostrealm.entity.goal.StealFromYetiGoal;
import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.registry.FrostEntities;
import baguchan.frostrealm.registry.FrostItems;
import baguchan.frostrealm.registry.FrostSounds;
import baguchan.frostrealm.registry.FrostTags;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SnowPileQuail
extends FrostAnimal
implements IHasEgg {
    private static final EntityDimensions BABY_DIMENSIONS = ((EntityType)FrostEntities.SNOWPILE_QUAIL.get()).getDimensions().scale(0.5f).withEyeHeight(0.2f);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.defineId(SnowPileQuail.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.defineId(SnowPileQuail.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    private float nextFlap = 1.0f;
    @Nullable
    private BlockPos homeTarget;
    @Nullable
    private LivingEntity stealTarget;
    private int ticksShake = 24000;
    private int ticksSinceEaten;
    public final AnimationState shakeAnimationState = new AnimationState();
    public final AnimationState popEggAnimationState = new AnimationState();

    public SnowPileQuail(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
        this.setCanPickUpLoot(true);
    }

    public EntityDimensions getDefaultDimensions(Pose p_316516_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_316516_);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, CrystalFox.class, 8.0f, 1.55, 1.45));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolfflue.class, 8.0f, 1.55, 1.45, p_28590_ -> !((Wolfflue)((Object)p_28590_)).isTame()));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ferret.class, 8.0f, 1.55, 1.45, p_28590_ -> !((Ferret)((Object)p_28590_)).isTame()));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Yeti.class, 8.0f, 1.55, 1.45, p_28590_ -> p_28590_ == this.getStealTarget()));
        this.goalSelector.addGoal(3, (Goal)new FindAndPlaceEggGoal<SnowPileQuail>(this, 0.8){

            @Override
            public void afterPlaceEgg() {
                SnowPileQuail.this.level().playSound(null, this.blockPos, SoundEvents.TURTLE_LAY_EGG, SoundSource.BLOCKS, 0.3f, 0.9f + SnowPileQuail.this.level().random.nextFloat() * 0.2f);
                SnowPileQuail.this.level().setBlock(this.blockPos, (BlockState)((Block)FrostBlocks.SNOWPILE_QUAIL_EGG.get()).defaultBlockState().setValue((Property)SnowPileQuailEggBlock.EGGS, (Comparable)Integer.valueOf(SnowPileQuail.this.random.nextInt(1) + 1)), 3);
                SnowPileQuail.this.setHomeTarget(this.blockPos);
                SnowPileQuail.this.level().broadcastEntityEvent((Entity)this.mob, (byte)7);
            }

            protected boolean isValidTarget(LevelReader p_25619_, BlockPos p_25620_) {
                return SnowPileQuailEggBlock.onDirt((BlockGetter)p_25619_, p_25620_) && p_25619_.getBlockState(p_25620_).isAir();
            }
        });
        this.goalSelector.addGoal(4, new BreedAndEggGoal<SnowPileQuail>(this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, item -> item.is(FrostTags.Items.SNOWPILE_FOODS), false));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(7, (Goal)new StealFromYetiGoal(this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new MoveToGoal(this, 8.0, 1.1));
        this.goalSelector.addGoal(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANGRY, (Object)false);
        builder.define(HAS_EGG, (Object)false);
    }

    public void handleEntityEvent(byte p_21807_) {
        if (p_21807_ == 5) {
            this.shakeAnimationState.start(this.tickCount);
        } else if (p_21807_ == 7) {
            this.popEggAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(p_21807_);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, EntitySpawnReason p_146748_, @Nullable SpawnGroupData p_146749_) {
        this.populateDefaultEquipmentSlots(p_146746_.getRandom(), p_146747_);
        return super.finalizeSpawn(p_146746_, p_146747_, p_146748_, p_146749_);
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_218171_, DifficultyInstance p_218172_) {
        float f = p_218171_.nextFloat();
        if (f < 0.25f) {
            ItemStack itemstack = f < 0.1f ? new ItemStack((ItemLike)FrostItems.YETI_FUR.get()) : new ItemStack((ItemLike)Items.STICK);
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)FrostSounds.SNOWPILE_QUAIL_IDLE.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_21239_) {
        return (SoundEvent)FrostSounds.SNOWPILE_QUAIL_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)FrostSounds.SNOWPILE_QUAIL_DEATH.get();
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        super.customServerAiStep(serverLevel);
        if (this.isAlive() && this.isEffectiveAi()) {
            ++this.ticksSinceEaten;
            ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
            if (this.canEat(itemstack)) {
                if (this.ticksSinceEaten > 600) {
                    ItemStack itemstack1 = itemstack.finishUsingItem(this.level(), (LivingEntity)this);
                    this.heal(2.0f);
                    if (!itemstack1.isEmpty()) {
                        this.setItemSlot(EquipmentSlot.MAINHAND, itemstack1);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.random.nextFloat() < 0.1f) {
                    this.playSound(SoundEvents.PARROT_EAT, 1.0f, 1.0f);
                    this.level().broadcastEntityEvent((Entity)this, (byte)45);
                }
            }
            if (--this.ticksShake <= 0) {
                this.level().broadcastEntityEvent((Entity)this, (byte)5);
                this.playSound(SoundEvents.WOLF_SHAKE);
                this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)Items.FEATHER, 1 + this.random.nextInt(2)));
                this.ticksShake = 12000 + this.random.nextIntBetweenInclusive(6000, 12000);
            }
        }
    }

    public void aiStep() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (this.onGround() ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        this.flap += this.flapping * 2.0f;
        if (this.isSleeping() || this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        }
        super.aiStep();
        Vec3 vec3 = this.getDeltaMovement();
        if (!this.onGround() && vec3.y < 0.0) {
            this.setDeltaMovement(vec3.multiply(1.0, 0.6, 1.0));
        }
        if (this.homeTarget != null && !this.level().getBlockState(this.homeTarget).is((Block)FrostBlocks.SNOWPILE_QUAIL_EGG.get())) {
            this.setHomeTarget(null);
        }
    }

    protected void pickUpItem(ServerLevel serverLevel, ItemEntity p_28514_) {
        ItemStack itemstack = p_28514_.getItem();
        if (this.canHoldItem(itemstack)) {
            int i = itemstack.getCount();
            if (i > 1) {
                this.dropItemStack(itemstack.split(i - 1));
            }
            this.spitOutItem(this.getItemBySlot(EquipmentSlot.MAINHAND));
            this.onItemPickup(p_28514_);
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack.split(1));
            this.setGuaranteedDrop(EquipmentSlot.MAINHAND);
            this.take((Entity)p_28514_, itemstack.getCount());
            p_28514_.discard();
            this.ticksSinceEaten = 0;
        }
    }

    private void spitOutItem(ItemStack p_28602_) {
        if (!p_28602_.isEmpty() && !this.level().isClientSide()) {
            ItemEntity itementity = new ItemEntity(this.level(), this.getX() + this.getLookAngle().x, this.getY() + 1.0, this.getZ() + this.getLookAngle().z, p_28602_);
            itementity.setPickUpDelay(40);
            itementity.setThrower((Entity)this);
            this.playSound(SoundEvents.FOX_SPIT, 1.0f, 1.0f);
            this.level().addFreshEntity((Entity)itementity);
        }
    }

    private void dropItemStack(ItemStack p_28606_) {
        ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), p_28606_);
        this.level().addFreshEntity((Entity)itementity);
    }

    public boolean canHoldItem(ItemStack p_28578_) {
        Item item = p_28578_.getItem();
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        if (p_28578_.is(Items.FEATHER) || p_28578_.is(FrostBlocks.SNOWPILE_QUAIL_EGG.asItem()) || p_28578_.is(FrostItems.COOKED_SNOWPILE_QUAIL_EGG.asItem())) {
            return false;
        }
        return itemstack.isEmpty() || this.ticksSinceEaten > 0 && p_28578_.get(DataComponents.FOOD) != null && !p_28578_.is(ItemTags.MEAT) && p_28578_.get(DataComponents.FOOD) == null;
    }

    private boolean canEat(ItemStack p_28598_) {
        return p_28598_.get(DataComponents.FOOD) != null && !p_28598_.is(ItemTags.MEAT) && this.getTarget() == null && this.onGround() && !this.isSleeping();
    }

    public boolean isFood(ItemStack p_28271_) {
        return p_28271_.is(FrostTags.Items.SNOWPILE_FOODS);
    }

    public void addAdditionalSaveData(ValueOutput compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        if (this.homeTarget != null) {
            compoundTag.store("HomeTarget", BlockPos.CODEC, (Object)this.homeTarget);
        }
        compoundTag.putBoolean("HasEgg", this.hasEgg());
        compoundTag.putInt("TickShake", this.ticksShake);
    }

    public void readAdditionalSaveData(ValueInput compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.homeTarget = compoundTag.read("HomeTarget", BlockPos.CODEC).orElse(null);
        this.setHasEgg(compoundTag.getBooleanOr("HasEgg", false));
        this.ticksShake = compoundTag.getIntOr("TickShake", 0);
    }

    public void setHomeTarget(@Nullable BlockPos pos) {
        this.homeTarget = pos;
    }

    @Nullable
    private BlockPos getHomeTarget() {
        return this.homeTarget;
    }

    public void setStealTarget(@Nullable LivingEntity stealTarget) {
        this.stealTarget = stealTarget;
    }

    @Nullable
    public LivingEntity getStealTarget() {
        return this.stealTarget;
    }

    @Override
    public boolean hasEgg() {
        return (Boolean)this.entityData.get(HAS_EGG);
    }

    @Override
    public void setHasEgg(boolean hasEgg) {
        this.entityData.set(HAS_EGG, (Object)hasEgg);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)FrostEntities.SNOWPILE_QUAIL.get()).create((Level)level, EntitySpawnReason.BREEDING);
    }

    protected void checkFallDamage(double p_20809_, boolean p_20810_, BlockState p_20811_, BlockPos p_20812_) {
    }

    class MoveToGoal
    extends Goal {
        final SnowPileQuail quail;
        final double stopDistance;
        final double speedModifier;

        MoveToGoal(SnowPileQuail snowPileQuail, double distance, double speed) {
            this.quail = snowPileQuail;
            this.stopDistance = distance;
            this.speedModifier = speed;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public void stop() {
            SnowPileQuail.this.navigation.stop();
        }

        public boolean canUse() {
            BlockPos blockpos = this.quail.getHomeTarget();
            double distance = this.quail.level().isBrightOutside() ? this.stopDistance : this.stopDistance / 4.0;
            return blockpos != null && this.isTooFarAway(blockpos, distance);
        }

        public void tick() {
            BlockPos blockpos = this.quail.getHomeTarget();
            if (blockpos != null && SnowPileQuail.this.navigation.isDone()) {
                if (this.isTooFarAway(blockpos, 10.0)) {
                    Vec3 vector3d = new Vec3((double)blockpos.getX() - this.quail.getX(), (double)blockpos.getY() - this.quail.getY(), (double)blockpos.getZ() - this.quail.getZ()).normalize();
                    Vec3 vector3d1 = vector3d.scale(10.0).add(this.quail.getX(), this.quail.getY(), this.quail.getZ());
                    SnowPileQuail.this.navigation.moveTo(vector3d1.x, vector3d1.y, vector3d1.z, this.speedModifier);
                } else {
                    SnowPileQuail.this.navigation.moveTo((double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(BlockPos pos, double distance) {
            return !pos.closerThan((Vec3i)this.quail.blockPosition(), distance);
        }
    }
}

