/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.animal;

import baguchan.frostrealm.api.entity.WolfflueVariant;
import baguchan.frostrealm.data.resource.registries.WolfflueVariants;
import baguchan.frostrealm.entity.animal.TamableBiggerAnimal;
import baguchan.frostrealm.entity.goal.LeapAtTargetWolfflueGoal;
import baguchan.frostrealm.entity.goal.WolfflueBegGoal;
import baguchan.frostrealm.registry.FrostEntities;
import baguchan.frostrealm.registry.FrostEntityDatas;
import baguchan.frostrealm.registry.FrostItems;
import baguchan.frostrealm.registry.FrostTags;
import baguchi.bagus_lib.entity.ISmartJump;
import baguchi.bagus_lib.entity.path.node.SmartNodeEvaluator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariants;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;

public class Wolfflue
extends TamableBiggerAnimal
implements NeutralMob,
PlayerRideableJumping,
ISmartJump {
    private static final EntityDataAccessor<Boolean> DATA_INTERESTED_ID = SynchedEntityData.defineId(Wolfflue.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.defineId(Wolfflue.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(Wolfflue.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Holder<WolfflueVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(Wolfflue.class, (EntityDataSerializer)((EntityDataSerializer)FrostEntityDatas.WOLFFLUE_VARIANT.get()));
    private static final EntityDataAccessor<Holder<WolfSoundVariant>> DATA_SOUND_VARIANT_ID = SynchedEntityData.defineId(Wolfflue.class, (EntityDataSerializer)EntityDataSerializers.WOLF_SOUND_VARIANT);
    private int ticksSinceEaten;
    public static final Predicate<LivingEntity> PREY_SELECTOR = p_348295_ -> {
        EntityType entitytype = p_348295_.getType();
        return entitytype == FrostEntities.CRYSTAL_FOX.get() || entitytype == FrostEntities.SNOWPILE_QUAIL.get() || entitytype == EntityType.FOX || entitytype == EntityType.SHEEP;
    };
    private static final float START_HEALTH = 20.0f;
    private static final float TAME_HEALTH = 80.0f;
    private static final float ARMOR_REPAIR_UNIT = 0.125f;
    private float interestedAngle;
    private float interestedAngleO;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    public final AnimationState idleSitAnimationState = new AnimationState();
    public final AnimationState idleSit2AnimationState = new AnimationState();
    public final AnimationState jumpAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private int idleAnimationRemainTick = 0;
    private float runningScale;
    private float runningScaleO;
    protected float playerJumpPendingScale;
    private boolean isJumping;

    public Wolfflue(EntityType<? extends Wolfflue> p_30369_, Level p_30370_) {
        super(p_30369_, p_30370_);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    private Holder<WolfSoundVariant> getSoundVariant() {
        return (Holder)this.entityData.get(DATA_SOUND_VARIANT_ID);
    }

    private void setSoundVariant(Holder<WolfSoundVariant> p_406324_) {
        this.entityData.set(DATA_SOUND_VARIANT_ID, p_406324_);
    }

    protected PathNavigation createNavigation(Level p_21480_) {
        return new GroundPathNavigation(this, (Mob)this, p_21480_){

            protected PathFinder createPathFinder(int p_219479_) {
                this.nodeEvaluator = new SmartNodeEvaluator();
                this.nodeEvaluator.setCanPassDoors(true);
                this.nodeEvaluator.setCanOpenDoors(false);
                this.nodeEvaluator.setCanFloat(true);
                return new PathFinder(this.nodeEvaluator, p_219479_);
            }
        };
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_312373_) {
        if (this.level().isClientSide() && DATA_POSE.equals(p_312373_)) {
            this.stopAllAnimation();
            Pose pose = this.getPose();
            switch (pose) {
                case LONG_JUMPING: {
                    this.jumpAnimationState.startIfStopped(this.tickCount);
                }
            }
        }
        super.onSyncedDataUpdated(p_312373_);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TamableAnimal.TamableAnimalPanicGoal((TamableAnimal)this, 1.5, DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetWolfflueGoal((Mob)this, 2.0f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.2f, true));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.5, 12.0f, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, (double)0.8f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, (double)0.8f));
        this.goalSelector.addGoal(9, (Goal)new WolfflueBegGoal(this, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, (arg_0, arg_1) -> ((Wolfflue)this).isAngryAt(arg_0, arg_1)));
        this.targetSelector.addGoal(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, (living, serverLevel) -> PREY_SELECTOR.test(living)).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.SAFE_FALL_DISTANCE, 8.0).add(Attributes.FOLLOW_RANGE, 18.0).add(Attributes.ATTACK_DAMAGE, 5.0);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(80) + 80;
            if (this.isInSittingPose()) {
                if (this.random.nextBoolean()) {
                    this.stopIdleAnimation();
                    this.idleSitAnimationState.start(this.tickCount);
                    this.idleAnimationRemainTick = 40;
                } else {
                    this.stopIdleAnimation();
                    this.idleSit2AnimationState.start(this.tickCount);
                    this.idleAnimationRemainTick = 35;
                }
            }
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.idleAnimationRemainTick <= 0) {
            this.stopIdleAnimation();
        } else {
            --this.idleAnimationRemainTick;
        }
        if (!this.isInSittingPose()) {
            this.stopIdleAnimation();
        }
    }

    private boolean isDashing() {
        return this.getDeltaMovement().horizontalDistanceSqr() > 0.02;
    }

    private boolean isMoving() {
        return this.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6;
    }

    public float getRunningScale(float p_29570_) {
        return Mth.lerp((float)p_29570_, (float)this.runningScaleO, (float)this.runningScale);
    }

    protected void stopIdleAnimation() {
        if (this.idleSitAnimationState.isStarted()) {
            this.idleSitAnimationState.stop();
        }
        if (this.idleSit2AnimationState.isStarted()) {
            this.idleSit2AnimationState.stop();
        }
    }

    protected void stopAllAnimation() {
        this.jumpAnimationState.stop();
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326027_) {
        super.defineSynchedData(p_326027_);
        p_326027_.define(DATA_INTERESTED_ID, (Object)false);
        p_326027_.define(DATA_COLLAR_COLOR, (Object)DyeColor.RED.getId());
        p_326027_.define(DATA_REMAINING_ANGER_TIME, (Object)0);
        RegistryAccess registryaccess = this.registryAccess();
        Registry registry = this.registryAccess().lookupOrThrow(Registries.WOLF_SOUND_VARIANT);
        p_326027_.define(DATA_VARIANT_ID, (Object)VariantUtils.getDefaultOrAny((RegistryAccess)this.registryAccess(), WolfflueVariants.DEFAULT));
        p_326027_.define(DATA_SOUND_VARIANT_ID, (Object)((Holder)registry.get(WolfSoundVariants.CLASSIC).or(() -> ((Registry)registry).getAny()).orElseThrow()));
    }

    public void setCustomName(@org.jetbrains.annotations.Nullable Component p_20053_) {
        super.setCustomName(p_20053_);
        if (!this.getVariant().is(WolfflueVariants.YUZUKI) && p_20053_ != null && (p_20053_.getString().equals("Yuzuki") || p_20053_.getString().equals("YuzukiYukari") || p_20053_.getString().equals("Yukari") || p_20053_.getString().equals("\u7d50\u6708\u3086\u304b\u308a") || p_20053_.getString().equals("\u7d50\u6708") || p_20053_.getString().equals("\u3086\u304b\u308a"))) {
            Holder.Reference holder = this.registryAccess().lookupOrThrow(WolfflueVariants.WOLFFLUE_VARIANT_REGISTRY_KEY).getOrThrow(WolfflueVariants.YUZUKI);
            this.setVariant((Holder<WolfflueVariant>)holder);
        }
    }

    public ResourceLocation getTexture() {
        WolfflueVariant wolfvariant = (WolfflueVariant)this.getVariant().value();
        if (this.isTame()) {
            return wolfvariant.wildTexture();
        }
        return this.isAngry() ? wolfvariant.angryTexture() : wolfvariant.wildTexture();
    }

    public Holder<WolfflueVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    public void setVariant(Holder<WolfflueVariant> p_332777_) {
        this.entityData.set(DATA_VARIANT_ID, p_332777_);
    }

    protected void playStepSound(BlockPos p_30415_, BlockState p_30416_) {
        this.playSound(SoundEvents.WOLF_STEP, 0.5f, 1.0f);
    }

    public void addAdditionalSaveData(ValueOutput p_30418_) {
        super.addAdditionalSaveData(p_30418_);
        p_30418_.putByte("CollarColor", (byte)this.getCollarColor().getId());
        this.getVariant().unwrapKey().ifPresent(p_344339_ -> p_30418_.putString("variant", p_344339_.location().toString()));
        this.getSoundVariant().unwrapKey().ifPresent(p_409350_ -> p_30418_.store("sound_variant", ResourceKey.codec((ResourceKey)Registries.WOLF_SOUND_VARIANT), p_409350_));
        this.addPersistentAngerSaveData(p_30418_);
    }

    public void readAdditionalSaveData(ValueInput p_30402_) {
        super.readAdditionalSaveData(p_30402_);
        this.setCollarColor(DyeColor.byId((int)p_30402_.getIntOr("CollarColor", -1)));
        Optional.ofNullable(ResourceLocation.tryParse((String)((String)p_30402_.getString("variant").orElseThrow()))).map(p_332608_ -> ResourceKey.create(WolfflueVariants.WOLFFLUE_VARIANT_REGISTRY_KEY, (ResourceLocation)p_332608_)).flatMap(p_352803_ -> this.registryAccess().lookupOrThrow(WolfflueVariants.WOLFFLUE_VARIANT_REGISTRY_KEY).get(p_352803_)).ifPresent(this::setVariant);
        p_30402_.read("sound_variant", ResourceKey.codec((ResourceKey)Registries.WOLF_SOUND_VARIANT)).flatMap(p_409348_ -> this.registryAccess().lookupOrThrow(Registries.WOLF_SOUND_VARIANT).get(p_409348_)).ifPresent(this::setSoundVariant);
        this.readPersistentAngerSaveData(this.level(), p_30402_);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, EntitySpawnReason mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        Holder<WolfflueVariant> holder1;
        Holder holder = serverLevelAccessor.getBiome(this.blockPosition());
        if (spawnGroupData instanceof WolffluePackData) {
            WolffluePackData wolf$wolfpackdata = (WolffluePackData)((Object)spawnGroupData);
            holder1 = wolf$wolfpackdata.type;
        } else {
            holder1 = WolfflueVariants.getSpawnVariant(this.registryAccess(), (Holder<Biome>)holder);
            spawnGroupData = new WolffluePackData(this, holder1);
        }
        this.setVariant(holder1);
        this.setSoundVariant((Holder<WolfSoundVariant>)WolfSoundVariants.pickRandomSoundVariant((RegistryAccess)this.registryAccess(), (RandomSource)this.random));
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.populateDefaultEquipmentEnchantments(serverLevelAccessor, this.random, difficultyInstance);
        return super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    protected void populateDefaultEquipmentSlots(RandomSource randomSource, DifficultyInstance p_217056_) {
        if (randomSource.nextFloat() < 0.05f) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)FrostItems.SILVER_MOON.get()));
        }
    }

    protected SoundEvent getAmbientSound() {
        if (this.isAngry()) {
            return (SoundEvent)((WolfSoundVariant)this.getSoundVariant().value()).growlSound().value();
        }
        if (this.random.nextInt(3) == 0) {
            return this.isTame() && this.getHealth() < 20.0f ? (SoundEvent)((WolfSoundVariant)this.getSoundVariant().value()).whineSound().value() : (SoundEvent)((WolfSoundVariant)this.getSoundVariant().value()).pantSound().value();
        }
        return (SoundEvent)((WolfSoundVariant)this.getSoundVariant().value()).ambientSound().value();
    }

    protected SoundEvent getHurtSound(DamageSource p_406243_) {
        return this.canArmorAbsorb(p_406243_) ? SoundEvents.WOLF_ARMOR_DAMAGE : (SoundEvent)((WolfSoundVariant)this.getSoundVariant().value()).hurtSound().value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)((WolfSoundVariant)this.getSoundVariant().value()).deathSound().value();
    }

    protected float getSoundVolume() {
        return 1.2f;
    }

    public void tick() {
        super.tick();
        if (this.isAlive()) {
            this.interestedAngleO = this.interestedAngle;
            this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
        }
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        this.setupRunning();
    }

    private void setupRunning() {
        this.runningScaleO = this.runningScale;
        if (this.isMoving()) {
            this.runningScale = this.isDashing() ? Mth.clamp((float)(this.runningScale + 0.1f), (float)0.0f, (float)1.0f) : Mth.clamp((float)(this.runningScale - 0.1f), (float)0.0f, (float)1.0f);
        }
    }

    public void aiStep() {
        if (!this.level().isClientSide() && this.isAlive() && this.isEffectiveAi()) {
            ++this.ticksSinceEaten;
            ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
            if (this.isFood(itemstack)) {
                if (this.ticksSinceEaten > 600) {
                    FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                    float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(f);
                    ItemStack itemstack1 = itemstack.finishUsingItem(this.level(), (LivingEntity)this);
                    if (!itemstack1.isEmpty()) {
                        this.setItemSlot(EquipmentSlot.MAINHAND, itemstack1);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.ticksSinceEaten % 5 == 0) {
                    this.playSound((SoundEvent)SoundEvents.GENERIC_EAT.value(), 1.0f, 1.0f);
                    this.level().broadcastEntityEvent((Entity)this, (byte)45);
                }
            }
        }
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
            if (this.onGround() && this.getPose() == Pose.LONG_JUMPING) {
                this.setPose(Pose.STANDING);
            }
        }
        super.aiStep();
    }

    protected void pickUpItem(ServerLevel serverLevel, ItemEntity p_28514_) {
        ItemStack itemstack = p_28514_.getItem();
        if (this.canHoldItem(itemstack)) {
            int i = itemstack.getCount();
            if (i > 1) {
                this.dropItemStack(itemstack.split(i - 1));
            }
            this.spitOutItem(this.getItemBySlot(EquipmentSlot.MAINHAND));
            this.onItemPickup(p_28514_);
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack.split(1));
            this.setGuaranteedDrop(EquipmentSlot.MAINHAND);
            this.take((Entity)p_28514_, itemstack.getCount());
            p_28514_.discard();
            this.ticksSinceEaten = 0;
        }
    }

    private void spitOutItem(ItemStack p_28602_) {
        if (!p_28602_.isEmpty() && !this.level().isClientSide()) {
            ItemEntity itementity = new ItemEntity(this.level(), this.getX() + this.getLookAngle().x, this.getY() + 1.0, this.getZ() + this.getLookAngle().z, p_28602_);
            itementity.setPickUpDelay(40);
            itementity.setThrower((Entity)this);
            this.playSound(SoundEvents.FOX_SPIT, 1.0f, 1.0f);
            this.level().addFreshEntity((Entity)itementity);
        }
    }

    private void dropItemStack(ItemStack p_28606_) {
        ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), p_28606_);
        this.level().addFreshEntity((Entity)itementity);
    }

    public boolean canHoldItem(ItemStack p_28578_) {
        Item item = p_28578_.getItem();
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        return itemstack.isEmpty() && this.isFood(p_28578_);
    }

    public float getHeadRollAngle(float p_30449_) {
        return Mth.lerp((float)p_30449_, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    public int getMaxHeadXRot() {
        return this.isInSittingPose() ? 20 : super.getMaxHeadXRot();
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource p_30386_, float p_30387_) {
        if (this.isInvulnerableTo(serverLevel, p_30386_)) {
            return false;
        }
        if (!this.level().isClientSide()) {
            this.setOrderedToSit(false);
        }
        return super.hurtServer(serverLevel, p_30386_, p_30387_);
    }

    public boolean doHurtTarget(ServerLevel serverLevel, Entity p_21372_) {
        boolean flag;
        float f = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        DamageSource damagesource = this.damageSources().mobAttack((LivingEntity)this);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)p_21372_, (DamageSource)damagesource, (float)f);
            if (!this.getMainHandItem().isEmpty()) {
                f += this.getMainHandItem().getItem().getAttackDamageBonus(p_21372_, f, damagesource);
            }
        }
        if (flag = p_21372_.hurtServer(serverLevel, damagesource, f)) {
            Level level2;
            float f1 = this.getKnockback(p_21372_, damagesource);
            if (f1 > 0.0f && p_21372_ instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)p_21372_;
                livingentity.knockback((double)(f1 * 0.5f), (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if ((level2 = this.level()) instanceof ServerLevel) {
                ServerLevel serverlevel1 = (ServerLevel)level2;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel1, (Entity)p_21372_, (DamageSource)damagesource);
            }
            this.setLastHurtMob(p_21372_);
            this.playAttackSound();
        }
        return flag;
    }

    protected void actuallyHurt(ServerLevel serverLevel, DamageSource p_331935_, float p_330695_) {
        if (!this.canArmorAbsorb(p_331935_)) {
            super.actuallyHurt(serverLevel, p_331935_, p_330695_);
        } else {
            ItemStack itemstack = this.getBodyArmorItem();
            int i = itemstack.getDamageValue();
            int j = itemstack.getMaxDamage();
            itemstack.hurtAndBreak(Mth.ceil((float)p_330695_), (LivingEntity)this, EquipmentSlot.BODY);
            if (Crackiness.WOLF_ARMOR.byDamage(i, j) != Crackiness.WOLF_ARMOR.byDamage(this.getBodyArmorItem())) {
                this.playSound(SoundEvents.WOLF_ARMOR_CRACK);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    serverlevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, Items.ARMADILLO_SCUTE.getDefaultInstance()), this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.2, 0.1, 0.2, 0.1);
                }
            }
        }
    }

    private boolean canArmorAbsorb(DamageSource p_331524_) {
        return false;
    }

    protected Holder<SoundEvent> getEquipSound(EquipmentSlot p_397157_, ItemStack p_397978_, Equippable p_397221_) {
        return p_397157_ == EquipmentSlot.SADDLE ? SoundEvents.STRIDER_SADDLE : super.getEquipSound(p_397157_, p_397978_, p_397221_);
    }

    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(80.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(6.0);
            this.setHealth(80.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(20.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(5.0);
        }
    }

    protected void hurtArmor(DamageSource p_332118_, float p_330593_) {
        this.doHurtEquipment(p_332118_, p_330593_, new EquipmentSlot[]{EquipmentSlot.BODY});
    }

    protected void dropEquipment(ServerLevel p_376551_) {
        super.dropEquipment(p_376551_);
    }

    protected void doPlayerRide(Player p_30634_) {
        this.setOrderedToSit(false);
        if (!this.level().isClientSide()) {
            p_30634_.setYRot(this.getYRot());
            p_30634_.setXRot(this.getXRot());
            p_30634_.startRiding((Entity)this);
        }
    }

    public InteractionResult mobInteract(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
        Item item = itemstack.getItem();
        if (this.isTame()) {
            if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                this.heal(4.0f * f);
                itemstack.consume(1, (LivingEntity)p_30412_);
                this.gameEvent((Holder)GameEvent.EAT);
                return InteractionResult.SUCCESS_SERVER;
            }
            if (item instanceof DyeItem) {
                DyeItem dyeitem = (DyeItem)item;
                if (this.isOwnedBy((LivingEntity)p_30412_)) {
                    DyeColor dyecolor = dyeitem.getDyeColor();
                    if (dyecolor != this.getCollarColor()) {
                        this.setCollarColor(dyecolor);
                        itemstack.consume(1, (LivingEntity)p_30412_);
                        return InteractionResult.SUCCESS;
                    }
                    return super.mobInteract(p_30412_, p_30413_);
                }
            }
            if (itemstack.is(FrostItems.SILVER_MOON) && this.isOwnedBy((LivingEntity)p_30412_) && this.getMainHandItem().isEmpty() && !this.isBaby()) {
                this.setItemSlot(EquipmentSlot.MAINHAND, itemstack.copyWithCount(1));
                itemstack.consume(1, (LivingEntity)p_30412_);
                this.setGuaranteedDrop(EquipmentSlot.MAINHAND);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.isEmpty() && p_30412_.isSecondaryUseActive() && p_30412_.getMainHandItem().isEmpty() && this.isOwnedBy((LivingEntity)p_30412_) && !this.getMainHandItem().isEmpty()) {
                ItemStack itemstack1 = this.getMainHandItem();
                this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.spawnAtLocation(serverLevel, itemstack1);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.isEquippableInSlot(itemstack, EquipmentSlot.SADDLE) && this.isOwnedBy((LivingEntity)p_30412_) && !this.isBaby()) {
                return itemstack.interactLivingEntity(p_30412_, (LivingEntity)this, p_30413_);
            }
            if (this.isEquippableInSlot(itemstack, EquipmentSlot.BODY) && this.isOwnedBy((LivingEntity)p_30412_) && this.getBodyArmorItem().isEmpty() && !this.isBaby()) {
                this.setBodyArmorItem(itemstack.copyWithCount(1));
                this.setGuaranteedDrop(EquipmentSlot.BODY);
                itemstack.consume(1, (LivingEntity)p_30412_);
                return InteractionResult.SUCCESS;
            }
            if (!this.getItemBySlot(EquipmentSlot.SADDLE).isEmpty() && !p_30412_.isSecondaryUseActive() && this.isOwnedBy((LivingEntity)p_30412_)) {
                this.doPlayerRide(p_30412_);
                if (this.isInSittingPose()) {
                    this.setInSittingPose(false);
                }
                return InteractionResult.SUCCESS.withoutItem();
            }
            InteractionResult interactionresult = super.mobInteract(p_30412_, p_30413_);
            if (!interactionresult.consumesAction() && this.isOwnedBy((LivingEntity)p_30412_)) {
                this.setOrderedToSit(!this.isOrderedToSit());
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
                return InteractionResult.SUCCESS.withoutItem();
            }
            return interactionresult;
        }
        if (!this.level().isClientSide() && this.isFood(itemstack) && !this.isAngry()) {
            itemstack.consume(1, (LivingEntity)p_30412_);
            this.tryToTame(p_30412_);
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.mobInteract(p_30412_, p_30413_);
    }

    protected boolean canDispenserEquipIntoSlot(EquipmentSlot p_371599_) {
        return (p_371599_ == EquipmentSlot.BODY || p_371599_ == EquipmentSlot.SADDLE) && this.isTame() || super.canDispenserEquipIntoSlot(p_371599_);
    }

    public boolean canUseSlot(EquipmentSlot p_397737_) {
        return p_397737_ != EquipmentSlot.SADDLE ? super.canUseSlot(p_397737_) : this.isAlive() && !this.isBaby() && this.isTame();
    }

    private void tryToTame(Player p_333736_) {
        if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)p_333736_)) {
            this.tame(p_333736_);
            this.navigation.stop();
            this.setTarget(null);
            this.setOrderedToSit(true);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    public void handleEntityEvent(byte p_30379_) {
        if (p_30379_ != 8 && p_30379_ != 56) {
            super.handleEntityEvent(p_30379_);
        }
    }

    public float getTailAngle() {
        if (this.isAngry() && !this.isTame()) {
            return 1.5393804f;
        }
        if (this.isTame()) {
            float f = this.getMaxHealth();
            float f1 = (f - this.getHealth()) / f;
            return 0.2f - f1 * 0.4f * (float)Math.PI;
        }
        return 0.0f;
    }

    public boolean isFood(ItemStack p_30440_) {
        return p_30440_.is(FrostTags.Items.WOLFFLUE_FOODS);
    }

    public int getMaxSpawnClusterSize() {
        return 8;
    }

    public boolean isMaxGroupSizeReached(int p_21489_) {
        return false;
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int p_30404_) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    public DyeColor getCollarColor() {
        return DyeColor.byId((int)((Integer)this.entityData.get(DATA_COLLAR_COLOR)));
    }

    public boolean hasArmor() {
        return !this.getBodyArmorItem().isEmpty();
    }

    private void setCollarColor(DyeColor p_30398_) {
        this.entityData.set(DATA_COLLAR_COLOR, (Object)p_30398_.getId());
    }

    @Nullable
    public Wolfflue getBreedOffspring(ServerLevel p_149088_, AgeableMob p_149089_) {
        Wolfflue wolf = (Wolfflue)((EntityType)FrostEntities.WOLFFLUE.get()).create((Level)p_149088_, EntitySpawnReason.BREEDING);
        if (wolf != null && p_149089_ instanceof Wolfflue) {
            Wolfflue wolf1 = (Wolfflue)p_149089_;
            if (this.random.nextBoolean()) {
                wolf.setVariant(this.getVariant());
            } else {
                wolf.setVariant(wolf1.getVariant());
            }
            if (this.isTame()) {
                wolf.setOwnerReference(this.getOwnerReference());
                wolf.setTame(true, true);
                if (this.random.nextBoolean()) {
                    wolf.setCollarColor(this.getCollarColor());
                } else {
                    wolf.setCollarColor(wolf1.getCollarColor());
                }
            }
            wolf.setSoundVariant((Holder<WolfSoundVariant>)WolfSoundVariants.pickRandomSoundVariant((RegistryAccess)this.registryAccess(), (RandomSource)this.random));
        }
        return wolf;
    }

    public void setIsInterested(boolean p_30445_) {
        this.entityData.set(DATA_INTERESTED_ID, (Object)p_30445_);
    }

    public boolean canMate(Animal p_30392_) {
        if (p_30392_ == this) {
            return false;
        }
        if (!this.isTame()) {
            return false;
        }
        if (!(p_30392_ instanceof Wolfflue)) {
            return false;
        }
        Wolfflue wolf = (Wolfflue)p_30392_;
        if (!wolf.isTame()) {
            return false;
        }
        return !wolf.isInSittingPose() && this.isInLove() && wolf.isInLove();
    }

    public boolean isInterested() {
        return (Boolean)this.entityData.get(DATA_INTERESTED_ID);
    }

    public boolean wantsToAttack(LivingEntity p_30389_, LivingEntity p_30390_) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (p_30389_ instanceof Creeper || p_30389_ instanceof Ghast || p_30389_ instanceof ArmorStand) {
            return false;
        }
        if (p_30389_ instanceof Wolfflue) {
            Wolfflue wolf = (Wolfflue)p_30389_;
            return !wolf.isTame() || wolf.getOwner() != p_30390_;
        }
        if (p_30389_ instanceof Player) {
            Player player1;
            Player player = (Player)p_30389_;
            if (p_30390_ instanceof Player && !(player1 = (Player)p_30390_).canHarmPlayer(player)) {
                return false;
            }
        }
        if (p_30389_ instanceof AbstractHorse && (abstracthorse = (AbstractHorse)p_30389_).isTamed()) {
            return false;
        }
        return !(p_30389_ instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)p_30389_).isTame();
    }

    public boolean canBeLeashed() {
        return !this.isAngry();
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.6f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    public static boolean checkWolfSpawnRules(EntityType<Wolfflue> p_218292_, LevelAccessor p_218293_, EntitySpawnReason p_218294_, BlockPos p_218295_, RandomSource p_218296_) {
        return p_218293_.getBlockState(p_218295_.below()).is(FrostTags.Blocks.ANIMAL_SPAWNABLE) && Wolfflue.isBrightEnoughToSpawn((BlockAndTintGetter)p_218293_, (BlockPos)p_218295_);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof Player) {
            return (Player)entity;
        }
        return super.getControllingPassenger();
    }

    protected void tickRidden(Player p_278233_, Vec3 p_275693_) {
        super.tickRidden(p_278233_, p_275693_);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)p_278233_);
        this.setRot(vec2.y, vec2.x);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        if (this.isLocalInstanceAuthoritative() && this.onGround()) {
            this.setIsJumping(false);
            if (this.getPose() == Pose.LONG_JUMPING) {
                this.setPose(Pose.STANDING);
            }
            if (this.playerJumpPendingScale > 0.0f && !this.isJumping()) {
                this.executeRidersJump(this.playerJumpPendingScale, p_275693_);
            }
            this.playerJumpPendingScale = 0.0f;
        }
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean p_30656_) {
        this.isJumping = p_30656_;
    }

    protected float nextStep() {
        return super.nextStep();
    }

    protected Vec2 getRiddenRotation(LivingEntity p_275502_) {
        return new Vec2(p_275502_.getXRot() * 0.5f, p_275502_.getYRot());
    }

    protected Vec3 getRiddenInput(Player p_278278_, Vec3 p_275506_) {
        float f = p_278278_.xxa * 0.5f;
        float f1 = p_278278_.zza;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    protected Vec3 getPassengerAttachmentPoint(Entity p_294748_, EntityDimensions p_295089_, float p_295230_) {
        float f = Math.min(0.25f, this.walkAnimation.speed());
        float f1 = this.walkAnimation.position();
        float scale = 2.5f * (1.0f + this.runningScale);
        float f2 = 0.12f * Mth.cos((float)(f1 * 1.0f)) * scale * f;
        float f3 = this.runningScale * 0.25f;
        if (this.getPose() == Pose.LONG_JUMPING) {
            f3 = 0.0f;
            f2 = 0.0f;
        }
        return super.getPassengerAttachmentPoint(p_294748_, p_295089_, p_295230_).add(new Vec3(0.0, (double)(0.0f + f3) + (double)(f2 * p_295230_ * 0.75f), -0.25).yRot(-this.getYRot() * ((float)Math.PI / 180)));
    }

    protected float getRiddenSpeed(Player p_278241_) {
        float f = p_278241_.isSprinting() ? 0.05f : 0.0f;
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) + f - 0.1f;
    }

    public void onPlayerJump(int p_21696_) {
        if (this.isSaddled()) {
            if (p_21696_ < 0) {
                p_21696_ = 0;
            }
            this.playerJumpPendingScale = p_21696_ >= 90 ? 1.0f : 0.4f + 0.4f * (float)p_21696_ / 90.0f;
        }
    }

    public boolean canJump() {
        return this.isSaddled();
    }

    public void handleStartJump(int p_21695_) {
        this.makeSound(SoundEvents.GOAT_LONG_JUMP);
        this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
    }

    public void handleStopJump() {
    }

    public boolean canSprint() {
        return true;
    }

    public boolean causeFallDamage(double p_397025_, float p_149499_, DamageSource p_149501_) {
        int i;
        if (p_397025_ > 1.0) {
            // empty if block
        }
        if ((i = this.calculateFallDamage(p_397025_, p_149499_)) <= 0) {
            return false;
        }
        this.hurt(p_149501_, i);
        this.propagateFallToPassengers(p_397025_, p_149499_, p_149501_);
        this.playBlockFallSound();
        return true;
    }

    protected void executeRidersJump(float p_248808_, Vec3 p_275435_) {
        double d0 = this.getJumpPower(p_248808_ * 1.75f);
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.x, d0, vec3.z);
        this.setIsJumping(true);
        this.setPose(Pose.LONG_JUMPING);
        this.hasImpulse = true;
        CommonHooks.onLivingJump((LivingEntity)this);
        if (p_275435_.z > 0.0) {
            float f = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
            float f1 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
            this.setDeltaMovement(this.getDeltaMovement().add((double)(-0.4f * f * p_248808_), 0.0, (double)(0.4f * f1 * p_248808_)));
        }
    }

    protected float getJumpPower() {
        float f = 0.42f;
        Path path = this.navigation.getPath();
        if (path != null && !path.isDone()) {
            Vec3 vec3 = path.getNextEntityPos((Entity)this);
            if (vec3.y > this.getY() + 0.5) {
                f = 0.5f;
            }
            if (vec3.y > this.getY() + 1.5) {
                f = 0.65f;
            }
        }
        return super.getJumpPower((float)((double)f / this.getAttributeValue(Attributes.JUMP_STRENGTH)));
    }

    public void jumpFromGround() {
        super.jumpFromGround();
        if ((double)this.getJumpPower() >= 1.4285715818405151 * this.getAttributeValue(Attributes.JUMP_STRENGTH)) {
            this.setPose(Pose.LONG_JUMPING);
            this.makeSound(SoundEvents.GOAT_LONG_JUMP);
        }
    }

    public float getSuppportJump() {
        return 2.125f;
    }

    private class WolffluePackData
    extends AgeableMob.AgeableMobGroupData {
        public final Holder<WolfflueVariant> type;

        public WolffluePackData(Wolfflue wolfflue, Holder<WolfflueVariant> p_332792_) {
            super(false);
            this.type = p_332792_;
        }
    }
}

