/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.brain;

import baguchan.frostrealm.entity.animal.FrostBoar;
import baguchan.frostrealm.registry.FrostEntities;
import baguchan.frostrealm.registry.FrostMemoryModuleType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.schedule.Activity;

public class FrostBoarAi {
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of((int)6, (int)16);
    private static final UniformInt RETREAT_DURATION = TimeUtil.rangeOfSeconds((int)10, (int)30);
    private static final TargetingConditions ATTACK_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT = TargetingConditions.forCombat().range(20.0).ignoreLineOfSight();
    private static final TargetingConditions ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT = TargetingConditions.forCombat().range(20.0).ignoreLineOfSight().ignoreInvisibilityTesting();

    public static boolean isEntityAttackableIgnoringLineOfSight(ServerLevel serverLevel, LivingEntity p_182378_, LivingEntity p_182379_) {
        return p_182378_.getBrain().isMemoryValue(MemoryModuleType.ATTACK_TARGET, (Object)p_182379_) ? ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT.test(serverLevel, p_182378_, p_182379_) : ATTACK_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT.test(serverLevel, p_182378_, p_182379_);
    }

    public static Brain<?> makeBrain(FrostBoar frostBoar, Brain<FrostBoar> p_149291_) {
        FrostBoarAi.initCoreActivity(p_149291_);
        FrostBoarAi.initIdleActivity(p_149291_);
        FrostBoarAi.initFightActivity(p_149291_);
        FrostBoarAi.initRetreatActivity(p_149291_);
        p_149291_.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        p_149291_.setDefaultActivity(Activity.IDLE);
        p_149291_.useDefaultActivity();
        return p_149291_;
    }

    public static void updateActivity(FrostBoar boar) {
        Brain<FrostBoar> brain = boar.getBrain();
        Activity activity = brain.getActiveNonCoreActivity().orElse(null);
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.AVOID, (Object)Activity.IDLE));
        Activity activity1 = brain.getActiveNonCoreActivity().orElse(null);
        if (activity != activity1) {
            FrostBoarAi.getSoundForCurrentActivity(boar).ifPresent(arg_0 -> ((FrostBoar)boar).playSound(arg_0));
        }
        boar.setAggressive(brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    private static void initFightActivity(Brain<FrostBoar> p_149303_) {
        p_149303_.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 0, ImmutableList.of((Object)StopAttackingIfTargetInvalid.create(), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create(FrostBoarAi::getSpeedModifierChasing), (Object)BehaviorBuilder.triggerIf(FrostBoar::isAdult, (OneShot)MeleeAttack.create((int)40)), (Object)EraseMemoryIf.create(BehaviorUtils::isBreeding, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initCoreActivity(Brain<FrostBoar> p_149307_) {
        p_149307_.addActivity(Activity.CORE, 0, ImmutableList.of((Object)StartAttacking.create(FrostBoarAi::findNearestValidAttackTarget), (Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<FrostBoar> p_149309_) {
        p_149309_.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new AnimalMakeLove((EntityType)FrostEntities.FROST_BOAR.get(), 0.75f, 4)), (Object)Pair.of((Object)1, (Object)new FollowTemptation(FrostBoarAi::getSpeedModifier)), (Object)Pair.of((Object)3, FrostBoarAi.createIdleMovementBehaviors()), (Object)Pair.of((Object)0, FrostBoarAi.createLookBehaviors()), (Object)Pair.of((Object)0, (Object)BabyFollowAdult.create((UniformInt)ADULT_FOLLOW_RANGE, (float)0.85f))), (Set)ImmutableSet.of());
    }

    private static void initRetreatActivity(Brain<FrostBoar> p_34616_) {
        p_34616_.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.3f, (int)15, (boolean)false), FrostBoarAi.createIdleMovementBehaviors(), (Object)SetEntityLookTargetSometimes.create((float)8.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)EraseMemoryIf.create(FrostBoarAi::wantsToStopFleeing, (MemoryModuleType)MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    private static RunOne<LivingEntity> createLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)2), (Object)Pair.of((Object)SetEntityLookTargetSometimes.create((float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)2)));
    }

    private static RunOne<FrostBoar> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)0.8f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)0.8f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static boolean wantsToStopFleeing(FrostBoar p_34618_) {
        return p_34618_.isAdult() && FrostBoarAi.isEnoughFrostBoarAndHealth(p_34618_);
    }

    private static boolean isEnoughFrostBoarAndHealth(FrostBoar p_34623_) {
        int i;
        if (p_34623_.isBaby()) {
            return false;
        }
        int j = p_34623_.getBrain().getMemory(FrostMemoryModuleType.FROST_BOAR_COUNT.get()).orElse(0) + 1;
        return j > (i = p_34623_.getBrain().getMemory(FrostMemoryModuleType.NEAREST_ENEMY_COUNT.get()).orElse(0).intValue()) + 2 && p_34623_.getHealth() > p_34623_.getMaxHealth() / 3.0f;
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(ServerLevel serverLevel, FrostBoar p_34611_) {
        boolean flag;
        boolean bl = flag = !BehaviorUtils.isBreeding((LivingEntity)p_34611_);
        if (flag) {
            Optional optional = BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)p_34611_, (MemoryModuleType)MemoryModuleType.ANGRY_AT);
            if (optional.isPresent() && FrostBoarAi.isEntityAttackableIgnoringLineOfSight(serverLevel, (LivingEntity)p_34611_, (LivingEntity)optional.get())) {
                return optional;
            }
            Optional listOptional = p_34611_.getBrain().getMemory(FrostMemoryModuleType.NEAREST_ENEMYS.get());
            if (listOptional.isPresent() && !((List)listOptional.get()).isEmpty()) {
                return Optional.of((LivingEntity)((List)listOptional.get()).get(p_34611_.getRandom().nextInt(((List)listOptional.get()).size())));
            }
        }
        return flag ? p_34611_.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE) : Optional.empty();
    }

    private static float getSpeedModifier(LivingEntity livingEntity) {
        return 1.0f;
    }

    private static float getSpeedModifierChasing(LivingEntity p_149289_) {
        return 1.2f;
    }

    private static void retreatFromNearestTarget(FrostBoar p_34613_, LivingEntity p_34614_) {
        Brain<FrostBoar> brain = p_34613_.getBrain();
        LivingEntity $$2 = BehaviorUtils.getNearestTarget((LivingEntity)p_34613_, (Optional)brain.getMemory(MemoryModuleType.AVOID_TARGET), (LivingEntity)p_34614_);
        $$2 = BehaviorUtils.getNearestTarget((LivingEntity)p_34613_, (Optional)brain.getMemory(MemoryModuleType.ATTACK_TARGET), (LivingEntity)$$2);
        FrostBoarAi.setAvoidTarget(p_34613_, $$2);
    }

    private static void setAvoidTarget(FrostBoar p_34620_, LivingEntity p_34621_) {
        p_34620_.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        p_34620_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        p_34620_.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)p_34621_, (long)RETREAT_DURATION.sample(p_34620_.level().random));
    }

    public static void wasHurtBy(ServerLevel serverLevel, FrostBoar p_34596_, LivingEntity p_34597_) {
        if (!(p_34597_ instanceof FrostBoar)) {
            Brain<FrostBoar> brain = p_34596_.getBrain();
            brain.eraseMemory(MemoryModuleType.BREED_TARGET);
            if (p_34596_.isBaby()) {
                FrostBoarAi.retreatFromNearestTarget(p_34596_, p_34597_);
                if (FrostBoarAi.isEntityAttackableIgnoringLineOfSight(serverLevel, (LivingEntity)p_34596_, p_34597_)) {
                    FrostBoarAi.broadcastAttackTarget(p_34596_, p_34597_);
                }
            } else if (!FrostBoarAi.isEnoughFrostBoarAndHealth(p_34596_)) {
                FrostBoarAi.retreatFromNearestTarget(p_34596_, p_34597_);
            } else {
                FrostBoarAi.maybeRetaliate(serverLevel, p_34596_, p_34597_);
            }
        }
    }

    private static void maybeRetaliate(ServerLevel serverLevel, FrostBoar p_34625_, LivingEntity p_34626_) {
        if (!(p_34625_.getBrain().isActive(Activity.AVOID) && p_34626_.getType() == FrostEntities.YETI.get() || p_34626_.getType() == FrostEntities.FROST_BOAR.get() || BehaviorUtils.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget((LivingEntity)p_34625_, (LivingEntity)p_34626_, (double)4.0) || !FrostBoarAi.isEntityAttackableIgnoringLineOfSight(serverLevel, (LivingEntity)p_34625_, p_34626_))) {
            FrostBoarAi.setAttackTarget(p_34625_, p_34626_);
            FrostBoarAi.broadcastAttackTarget(p_34625_, p_34626_);
        }
    }

    private static void setAttackTarget(FrostBoar p_34630_, LivingEntity p_34631_) {
        Brain<FrostBoar> brain = p_34630_.getBrain();
        brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        brain.eraseMemory(MemoryModuleType.BREED_TARGET);
        brain.setMemoryWithExpiry(MemoryModuleType.ATTACK_TARGET, (Object)p_34631_, 200L);
    }

    public static void onHitTarget(FrostBoar p_34580_, LivingEntity p_34581_) {
        if (!p_34580_.isBaby()) {
            FrostBoarAi.broadcastAttackTarget(p_34580_, p_34581_);
        }
    }

    private static void broadcastAttackTarget(FrostBoar p_34635_, LivingEntity p_34636_) {
        FrostBoarAi.getVisibleAdultFrostBoars((LivingEntity)p_34635_).forEach(p_34574_ -> FrostBoarAi.setAttackTargetIfCloserThanCurrent(p_34574_, p_34636_));
    }

    public static List<FrostBoar> getVisibleAdultFrostBoars(LivingEntity p_34874_) {
        return (List)p_34874_.getBrain().getMemory(FrostMemoryModuleType.NEAREST_FROST_BOARS.get()).orElse(ImmutableList.of());
    }

    private static void setAttackTargetIfCloserThanCurrent(FrostBoar p_34640_, LivingEntity p_34641_) {
        Optional optional = p_34640_.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        LivingEntity livingentity = BehaviorUtils.getNearestTarget((LivingEntity)p_34640_, (Optional)optional, (LivingEntity)p_34641_);
        FrostBoarAi.setAttackTarget(p_34640_, livingentity);
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(FrostBoar boar) {
        return boar.getBrain().getActiveNonCoreActivity().map(activity -> FrostBoarAi.getSoundForActivity(boar, activity));
    }

    private static SoundEvent getSoundForActivity(FrostBoar p_34583_, Activity p_34584_) {
        if (p_34584_ != Activity.AVOID) {
            if (p_34584_ == Activity.FIGHT) {
                return SoundEvents.HOGLIN_ANGRY;
            }
            return SoundEvents.HOGLIN_AMBIENT;
        }
        return SoundEvents.HOGLIN_RETREAT;
    }
}

