/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.brain;

import baguchan.frostrealm.entity.Yeti;
import baguchan.frostrealm.entity.brain.behavior.SnowBallAttack;
import baguchan.frostrealm.entity.brain.behavior.StartAdmiringItemIfSeen;
import baguchan.frostrealm.entity.brain.behavior.StopAdmiringIfItemTooFarAway;
import baguchan.frostrealm.entity.brain.behavior.TakeBackFromStealer;
import baguchan.frostrealm.registry.FrostActivity;
import baguchan.frostrealm.registry.FrostCriterions;
import baguchan.frostrealm.registry.FrostDataCompnents;
import baguchan.frostrealm.registry.FrostEntities;
import baguchan.frostrealm.registry.FrostItems;
import baguchan.frostrealm.registry.FrostLoots;
import baguchan.frostrealm.registry.FrostMemoryModuleType;
import baguchan.frostrealm.registry.FrostSounds;
import baguchan.frostrealm.registry.FrostTags;
import baguchan.frostrealm.utils.aurorapower.AuroraPowerUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.Unit;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.piglin.StopAdmiringIfTiredOfTryingToReachItem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class YetiAi<E extends Yeti> {
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of((int)6, (int)16);
    public static final UniformInt RETREAT_DURATION = TimeUtil.rangeOfSeconds((int)10, (int)30);
    protected static final UniformInt TIME_BETWEEN_HUNTS = TimeUtil.rangeOfSeconds((int)30, (int)120);
    private static final TargetingConditions ATTACK_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT = TargetingConditions.forCombat().range(24.0).ignoreLineOfSight();
    private static final TargetingConditions ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT = TargetingConditions.forCombat().range(24.0).ignoreLineOfSight().ignoreInvisibilityTesting();

    public static Brain<?> makeBrain(Yeti Yeti2, Brain<Yeti> p_149291_) {
        YetiAi.initCoreActivity(p_149291_);
        YetiAi.initIdleActivity(p_149291_);
        YetiAi.initFightActivity(p_149291_);
        YetiAi.initTakeBack(p_149291_);
        YetiAi.initAdmireItemActivity(p_149291_);
        YetiAi.initRetreatActivity(p_149291_);
        p_149291_.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        p_149291_.setDefaultActivity(Activity.IDLE);
        p_149291_.useDefaultActivity();
        return p_149291_;
    }

    public static void updateActivity(Yeti yeti) {
        Brain<Yeti> brain = yeti.getBrain();
        Activity activity = brain.getActiveNonCoreActivity().orElse(null);
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.ADMIRE_ITEM, (Object)Activity.FIGHT, (Object)FrostActivity.TAKE_BACK.get(), (Object)Activity.AVOID, (Object)Activity.IDLE));
        Activity activity1 = brain.getActiveNonCoreActivity().orElse(null);
        if (yeti.isSameStatue(Yeti.State.CHASING) && !brain.hasMemoryValue(FrostMemoryModuleType.TAKE_BACK_TARGET.get())) {
            yeti.setState(Yeti.State.IDLING);
        }
        yeti.setAggressive(brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    private static void initFightActivity(Brain<Yeti> p_149303_) {
        p_149303_.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 0, ImmutableList.of((Object)StopAttackingIfTargetInvalid.create(), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create(YetiAi::getSpeedModifierChasing), new SnowBallAttack(), (Object)BehaviorBuilder.triggerIf(Yeti::isMeleeAttack, (OneShot)MeleeAttack.create((int)25)), (Object)EraseMemoryIf.create(BehaviorUtils::isBreeding, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initCoreActivity(Brain<Yeti> p_149307_) {
        p_149307_.addActivity(Activity.CORE, 0, ImmutableList.of((Object)StartAttacking.create((p_381522_, p_381523_) -> p_381523_.isAdult(), YetiAi::findNearestValidAttackTarget), (Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)StopBeingAngryIfTargetDead.create(), StartAdmiringItemIfSeen.create(120), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Brain<Yeti> p_149309_) {
        p_149309_.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)3, YetiAi.createIdleMovementBehaviors()), (Object)Pair.of((Object)0, YetiAi.createLookBehaviors()), (Object)Pair.of((Object)1, (Object)((Object)new RandomSitting(20))), (Object)Pair.of((Object)0, (Object)BabyFollowAdult.create((UniformInt)ADULT_FOLLOW_RANGE, (float)0.85f)), (Object)Pair.of((Object)2, (Object)StrollToPoi.create((MemoryModuleType)MemoryModuleType.HOME, (float)0.85f, (int)3, (int)600))), (Set)ImmutableSet.of());
    }

    private static void initTakeBack(Brain<Yeti> p_34941_) {
        p_34941_.addActivityAndRemoveMemoryWhenStopped(FrostActivity.TAKE_BACK.get(), 10, ImmutableList.of(TakeBackFromStealer.create(living -> true)), FrostMemoryModuleType.TAKE_BACK_TARGET.get());
    }

    private static void initAdmireItemActivity(Brain<Yeti> p_34941_) {
        p_34941_.addActivityAndRemoveMemoryWhenStopped(Activity.ADMIRE_ITEM, 10, ImmutableList.of((Object)GoToWantedItem.create((float)1.2f, (boolean)true, (int)9), StopAdmiringIfItemTooFarAway.create(9), (Object)StopAdmiringIfTiredOfTryingToReachItem.create((int)200, (int)200)), MemoryModuleType.ADMIRING_ITEM);
    }

    private static void initRetreatActivity(Brain<Yeti> p_34616_) {
        p_34616_.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.35f, (int)15, (boolean)false), YetiAi.createIdleMovementBehaviors(), (Object)SetEntityLookTargetSometimes.create((float)8.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)EraseMemoryIf.create(YetiAi::wantsToStopFleeing, (MemoryModuleType)MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    private static RunOne<LivingEntity> createLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)2), (Object)Pair.of((Object)SetEntityLookTargetSometimes.create((float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)2)));
    }

    private static RunOne<Yeti> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of(StartAdmiringItemIfSeen.create(119), (Object)0), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(Predicate.not(Yeti::refuseToMove), (OneShot)RandomStroll.stroll((float)0.8f)), (Object)2), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(Predicate.not(Yeti::refuseToMove), (OneShot)SetWalkTargetFromLookTarget.create((float)0.8f, (int)3)), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static boolean wantsToStopFleeing(Yeti p_34618_) {
        return p_34618_.isAdult() && YetiAi.isEnoughYeti(p_34618_);
    }

    private static boolean isNoEnoughYeti(Yeti yeti) {
        int i;
        if (yeti.isBaby()) {
            return false;
        }
        int j = yeti.getBrain().getMemory(FrostMemoryModuleType.YETI_COUNT.get()).orElse(0) + 1;
        return j + 5 < (i = yeti.getBrain().getMemory(FrostMemoryModuleType.NEAREST_ENEMY_COUNT.get()).orElse(0).intValue()) || yeti.getHealth() < yeti.getMaxHealth() / 4.0f;
    }

    private static boolean isEnoughYeti(Yeti p_34623_) {
        int i;
        if (p_34623_.isBaby()) {
            return false;
        }
        int j = p_34623_.getBrain().getMemory(FrostMemoryModuleType.YETI_COUNT.get()).orElse(0) + 1;
        return j > (i = p_34623_.getBrain().getMemory(FrostMemoryModuleType.NEAREST_ENEMY_COUNT.get()).orElse(0).intValue()) - 2;
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(ServerLevel p_376590_, Yeti p_34611_) {
        Optional optional = BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)p_34611_, (MemoryModuleType)MemoryModuleType.ANGRY_AT);
        if (optional.isPresent() && YetiAi.isEntityAttackableIgnoringLineOfSight(p_376590_, (LivingEntity)p_34611_, (LivingEntity)optional.get())) {
            return optional;
        }
        Optional listOptional = p_34611_.getBrain().getMemory(FrostMemoryModuleType.NEAREST_ENEMYS.get());
        if (listOptional.isPresent() && !((List)listOptional.get()).isEmpty()) {
            return Optional.of((LivingEntity)((List)listOptional.get()).get(p_34611_.getRandom().nextInt(((List)listOptional.get()).size())));
        }
        return p_34611_.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE);
    }

    public static InteractionResult mobInteract(ServerLevel p_376885_, Yeti yeti, Player p_34848_, InteractionHand p_34849_) {
        ItemStack itemstack = p_34848_.getItemInHand(p_34849_);
        ItemStack itemstack2 = yeti.getItemInHand(InteractionHand.OFF_HAND);
        if ((itemstack.is(FrostTags.Items.SMITHABLE_WEAPON) || itemstack.is(ItemTags.ARMOR_ENCHANTABLE)) && !itemstack.has(FrostDataCompnents.AURORA_POWER) && !itemstack2.is(FrostTags.Items.SMITHABLE_WEAPON) && !itemstack2.is(ItemTags.ARMOR_ENCHANTABLE) && yeti.isTrade()) {
            yeti.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
            ItemStack itemstack1 = itemstack.consumeAndReturn(1, (LivingEntity)p_34848_);
            YetiAi.holdInOffHand(p_376885_, yeti, itemstack1);
            YetiAi.admireGoldItem((LivingEntity)yeti);
            YetiAi.stopWalking(yeti);
            yeti.setHoldTime(80);
            if (p_34848_ instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)p_34848_;
                FrostCriterions.STARDUST_TRADE.get().trigger(serverPlayer, itemstack);
            }
            yeti.setState(Yeti.State.TRADE);
            return InteractionResult.SUCCESS;
        }
        if (YetiAi.canAdmire(yeti, itemstack)) {
            ItemStack itemstack1 = itemstack.consumeAndReturn(1, (LivingEntity)p_34848_);
            YetiAi.holdInOffHand(p_376885_, yeti, itemstack1);
            YetiAi.admireGoldItem((LivingEntity)yeti);
            YetiAi.stopWalking(yeti);
            yeti.setHoldTime(60);
            if (p_34848_ instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)p_34848_;
                FrostCriterions.STARDUST_TRADE.get().trigger(serverPlayer, itemstack);
            }
            yeti.setState(Yeti.State.TRADE);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean canAdmire(Yeti yeti, ItemStack stack) {
        return !YetiAi.isAdmiringDisabled(yeti) && !YetiAi.isAdmiringItem(yeti) && yeti.isAdult() && stack.is(FrostTags.Items.YETI_CURRENCY);
    }

    private static boolean isAdmiringItem(Yeti yeti) {
        return yeti.getBrain().hasMemoryValue(MemoryModuleType.ADMIRING_ITEM);
    }

    private static void admireGoldItem(LivingEntity p_34939_) {
        p_34939_.getBrain().setMemoryWithExpiry(MemoryModuleType.ADMIRING_ITEM, (Object)true, 119L);
    }

    private static void stopWalking(Yeti p_35007_) {
        p_35007_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        p_35007_.getNavigation().stop();
    }

    private static float getSpeedModifier(LivingEntity livingEntity) {
        return 1.0f;
    }

    private static float getSpeedModifierChasing(LivingEntity p_149289_) {
        Yeti yeti;
        if (p_149289_ instanceof Yeti && (yeti = (Yeti)p_149289_).isSnowAttack()) {
            return 0.1f;
        }
        return 1.2f;
    }

    private static void retreatFromNearestTarget(Yeti p_34613_, LivingEntity p_34614_) {
        Brain<Yeti> brain = p_34613_.getBrain();
        LivingEntity $$2 = BehaviorUtils.getNearestTarget((LivingEntity)p_34613_, (Optional)brain.getMemory(MemoryModuleType.AVOID_TARGET), (LivingEntity)p_34614_);
        $$2 = BehaviorUtils.getNearestTarget((LivingEntity)p_34613_, (Optional)brain.getMemory(MemoryModuleType.ATTACK_TARGET), (LivingEntity)$$2);
        YetiAi.setAvoidTarget(p_34613_, $$2);
    }

    private static void setAvoidTarget(Yeti p_34620_, LivingEntity p_34621_) {
        p_34620_.standUpInstantly();
        p_34620_.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        p_34620_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        p_34620_.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)p_34621_, (long)RETREAT_DURATION.sample(p_34620_.getRandom()));
    }

    public static void wasHurtBy(ServerLevel serverLevel, Yeti p_34596_, LivingEntity p_34597_) {
        Brain<Yeti> brain = p_34596_.getBrain();
        if (!(p_34597_ instanceof Yeti)) {
            brain.eraseMemory(MemoryModuleType.ADMIRING_ITEM);
            if (p_34597_ instanceof Player && !((Player)p_34597_).isCreative()) {
                brain.setMemoryWithExpiry(MemoryModuleType.ADMIRING_DISABLED, (Object)true, 400L);
            }
            if (p_34596_.isBaby() || YetiAi.isNoEnoughYeti(p_34596_)) {
                YetiAi.retreatFromNearestTarget(p_34596_, p_34597_);
                if (YetiAi.isEntityAttackableIgnoringLineOfSight(serverLevel, (LivingEntity)p_34596_, p_34597_)) {
                    YetiAi.broadcastAngerTarget(serverLevel, p_34596_, p_34597_);
                }
            } else if (YetiAi.isNoEnoughYeti(p_34596_)) {
                YetiAi.retreatFromNearestTarget(p_34596_, p_34597_);
            } else {
                YetiAi.maybeRetaliate(serverLevel, p_34596_, p_34597_);
            }
        }
    }

    private static void maybeRetaliate(ServerLevel p_376847_, Yeti p_34625_, LivingEntity p_34626_) {
        if (!(p_34625_.getBrain().isActive(Activity.AVOID) && p_34626_.getType() == FrostEntities.YETI.get() || BehaviorUtils.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget((LivingEntity)p_34625_, (LivingEntity)p_34626_, (double)4.0) || !Sensor.isEntityAttackable((ServerLevel)p_376847_, (LivingEntity)p_34625_, (LivingEntity)p_34626_))) {
            YetiAi.setAttackTarget(p_34625_, p_34626_);
            YetiAi.broadcastAttackTarget(p_34625_, p_34626_);
        }
    }

    public static void setAttackTarget(Yeti p_34630_, LivingEntity p_34631_) {
        Brain<Yeti> brain = p_34630_.getBrain();
        brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        brain.setMemoryWithExpiry(MemoryModuleType.ATTACK_TARGET, (Object)p_34631_, 200L);
        p_34630_.standUpInstantly();
    }

    public static void onHitTarget(Yeti p_34580_, LivingEntity p_34581_) {
        if (!p_34580_.isBaby()) {
            YetiAi.broadcastAttackTarget(p_34580_, p_34581_);
        }
    }

    public static void angerNearbyYeti(ServerLevel serverLevel, Player player, boolean see) {
        List list = player.level().getEntitiesOfClass(Yeti.class, player.getBoundingBox().inflate(16.0));
        list.stream().filter(YetiAi::isIdle).filter(p_34881_ -> !see || BehaviorUtils.canSee((LivingEntity)p_34881_, (LivingEntity)player)).forEach(p_269951_ -> YetiAi.setAngerTarget(serverLevel, p_269951_, (LivingEntity)player));
    }

    public static void stealFromYeti(LivingEntity living, Yeti yeti) {
        Brain<Yeti> brain = yeti.getBrain();
        ItemStack stack = yeti.findFood();
        if (!stack.isEmpty()) {
            living.setItemInHand(InteractionHand.MAIN_HAND, stack);
            brain.setMemory(FrostMemoryModuleType.TAKE_BACK_TARGET.get(), (Object)living);
            brain.setMemoryWithExpiry(FrostMemoryModuleType.TAKE_BACK_COOLDOWN.get(), (Object)Unit.INSTANCE, 40L);
            yeti.setState(Yeti.State.CHASING);
            living.playSound(SoundEvents.ITEM_PICKUP);
        }
    }

    protected static boolean isIdle(Yeti yeti) {
        return yeti.getBrain().isActive(Activity.IDLE);
    }

    protected static void broadcastAngerTarget(ServerLevel serverLevel, Yeti yeti, LivingEntity p_34897_) {
        YetiAi.getVisibleAdultYetis((LivingEntity)yeti).forEach(p_275125_ -> YetiAi.setAngerTargetIfCloserThanCurrent(serverLevel, p_275125_, p_34897_));
    }

    private static Optional<LivingEntity> getAngerTarget(Yeti p_34976_) {
        return BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)p_34976_, (MemoryModuleType)MemoryModuleType.ANGRY_AT);
    }

    private static void setAngerTargetIfCloserThanCurrent(ServerLevel serverLevel, Yeti yeti, LivingEntity target) {
        Optional<LivingEntity> optional = YetiAi.getAngerTarget(yeti);
        LivingEntity livingentity = BehaviorUtils.getNearestTarget((LivingEntity)yeti, optional, (LivingEntity)target);
        if (!optional.isPresent() || optional.get() != livingentity) {
            YetiAi.setAngerTarget(serverLevel, yeti, livingentity);
        }
    }

    protected static void setAngerTarget(ServerLevel p_376847_, Yeti yeti, LivingEntity target) {
        if (YetiAi.isEntityAttackableIgnoringLineOfSight(p_376847_, (LivingEntity)yeti, target)) {
            yeti.standUpInstantly();
            yeti.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
            yeti.getBrain().setMemoryWithExpiry(MemoryModuleType.ANGRY_AT, (Object)target.getUUID(), 600L);
            if (target.getType() == EntityType.PLAYER && p_376847_.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
                yeti.getBrain().setMemoryWithExpiry(MemoryModuleType.UNIVERSAL_ANGER, (Object)true, 600L);
            }
        }
    }

    public static boolean isEntityAttackableIgnoringLineOfSight(ServerLevel serverLevel, LivingEntity p_182378_, LivingEntity p_182379_) {
        return p_182378_.getBrain().isMemoryValue(MemoryModuleType.ATTACK_TARGET, (Object)p_182379_) ? ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT.test(serverLevel, p_182378_, p_182379_) : ATTACK_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT.test(serverLevel, p_182378_, p_182379_);
    }

    public static void initMemories(Yeti p_219206_, RandomSource p_219207_, EntitySpawnReason p_29535_) {
        int i = TIME_BETWEEN_HUNTS.sample(p_219207_);
        p_219206_.getBrain().setMemoryWithExpiry(MemoryModuleType.HUNTED_RECENTLY, (Object)true, (long)i);
        if (p_29535_ == EntitySpawnReason.STRUCTURE) {
            GlobalPos globalpos = GlobalPos.of((ResourceKey)p_219206_.level().dimension(), (BlockPos)p_219206_.blockPosition());
            p_219206_.getBrain().setMemory(MemoryModuleType.HOME, (Object)globalpos);
        }
    }

    private static void broadcastAttackTarget(Yeti yeti, LivingEntity target) {
        YetiAi.getVisibleAdultYetis((LivingEntity)yeti).forEach(p_34574_ -> YetiAi.setAttackTargetIfCloserThanCurrent(p_34574_, target));
    }

    public static List<Yeti> getVisibleAdultYetis(LivingEntity living) {
        return (List)living.getBrain().getMemory(FrostMemoryModuleType.NEAREST_YETIS.get()).orElse(ImmutableList.of());
    }

    private static void setAttackTargetIfCloserThanCurrent(Yeti yeti, LivingEntity target) {
        Optional optional = yeti.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        LivingEntity livingentity = BehaviorUtils.getNearestTarget((LivingEntity)yeti, (Optional)optional, (LivingEntity)target);
        YetiAi.setAttackTarget(yeti, livingentity);
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(Yeti boar) {
        return boar.getBrain().getActiveNonCoreActivity().map(activity -> YetiAi.getSoundForActivity(boar, activity));
    }

    private static SoundEvent getSoundForActivity(Yeti p_34583_, Activity p_34584_) {
        if (p_34584_ != Activity.AVOID) {
            if (p_34584_ == Activity.FIGHT) {
                return (SoundEvent)FrostSounds.YETI_IDLE.get();
            }
            return (SoundEvent)FrostSounds.YETI_IDLE.get();
        }
        return (SoundEvent)FrostSounds.YETI_IDLE.get();
    }

    public static void stopHoldingOffHandItem(ServerLevel serverLevel, Yeti yeti, boolean thrown) {
        ItemStack itemstack = yeti.getItemInHand(InteractionHand.OFF_HAND);
        if (!itemstack.isEmpty()) {
            if (!yeti.isBaby()) {
                boolean flag = itemstack.is(FrostTags.Items.YETI_CURRENCY);
                if (thrown && flag) {
                    itemstack.shrink(1);
                    YetiAi.throwItems(yeti, YetiAi.getBarterResponseItems(yeti));
                    if (itemstack.getCount() <= 0) {
                        yeti.setState(Yeti.State.IDLING);
                        yeti.setHoldTime(40);
                    }
                } else if (thrown && (itemstack.is(FrostTags.Items.SMITHABLE_WEAPON) || itemstack.is(ItemTags.ARMOR_ENCHANTABLE))) {
                    ItemStack itemstack1 = yeti.getOffhandItem();
                    AuroraPowerUtils.auroraInfusionItem(yeti.getRandom(), itemstack1, 11, false);
                    YetiAi.throwItems(yeti, Collections.singletonList(itemstack1));
                    yeti.setState(Yeti.State.IDLING);
                    yeti.holdInOffHand(ItemStack.EMPTY);
                } else if (!flag) {
                    YetiAi.putInInventory(yeti, itemstack);
                    yeti.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
                }
            } else {
                ItemStack itemstack1 = yeti.getOffhandItem();
                if (YetiAi.isFood(itemstack1)) {
                    YetiAi.putInInventory(yeti, itemstack1);
                } else {
                    YetiAi.throwItems(yeti, Collections.singletonList(itemstack1));
                }
                yeti.holdInOffHand(itemstack);
                yeti.setState(Yeti.State.IDLING);
            }
        }
    }

    public static boolean wantsToPickup(Yeti p_34858_, ItemStack p_34859_) {
        if (p_34859_.is(FrostTags.Items.YETI_SCARED)) {
            return false;
        }
        if (YetiAi.isAdmiringDisabled(p_34858_) && p_34858_.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
            return false;
        }
        boolean flag = p_34858_.canAddToInventory(p_34859_);
        if (YetiAi.isFood(p_34859_)) {
            return flag;
        }
        return false;
    }

    private static boolean isAdmiringDisabled(Yeti p_35025_) {
        return p_35025_.getBrain().hasMemoryValue(MemoryModuleType.ADMIRING_DISABLED);
    }

    public static boolean isLovedItem(ItemStack p_149966_) {
        return p_149966_.is(FrostTags.Items.YETI_LOVED);
    }

    public static boolean isFood(ItemStack p_149966_) {
        return p_149966_.get(DataComponents.FOOD) != null;
    }

    private static List<ItemStack> getBarterResponseItems(Yeti p_34997_) {
        LootTable loottable = p_34997_.level().getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)FrostLoots.YETI_BARTERING));
        ObjectArrayList list = loottable.getRandomItems(new LootParams.Builder((ServerLevel)p_34997_.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)p_34997_).create(LootContextParamSets.PIGLIN_BARTER));
        return list;
    }

    private static void putInInventory(Yeti p_34953_, ItemStack p_34954_) {
        ItemStack itemstack = p_34953_.addToInventory(p_34954_);
        YetiAi.throwItemsTowardRandomPos(p_34953_, Collections.singletonList(itemstack));
    }

    private static void throwItems(Yeti p_34861_, List<ItemStack> p_34862_) {
        Player player = p_34861_.level().getNearestPlayer((Entity)p_34861_, 10.0);
        if (player != null) {
            YetiAi.throwItemsTowardPlayer(p_34861_, player, p_34862_);
        } else {
            YetiAi.throwItemsTowardRandomPos(p_34861_, p_34862_);
        }
    }

    private static void throwItemsTowardRandomPos(Yeti p_34913_, List<ItemStack> p_34914_) {
        YetiAi.throwItemsTowardPos(p_34913_, p_34914_, YetiAi.getRandomNearbyPos(p_34913_));
    }

    private static void throwItemsTowardPlayer(Yeti p_34851_, Player p_34852_, List<ItemStack> p_34853_) {
        YetiAi.throwItemsTowardPos(p_34851_, p_34853_, p_34852_.position());
    }

    private static void throwItemsTowardPos(Yeti p_34864_, List<ItemStack> p_34865_, Vec3 p_34866_) {
        if (!p_34865_.isEmpty()) {
            p_34864_.swing(InteractionHand.OFF_HAND);
            for (ItemStack itemstack : p_34865_) {
                BehaviorUtils.throwItem((LivingEntity)p_34864_, (ItemStack)itemstack, (Vec3)p_34866_.add(0.0, 1.0, 0.0));
            }
        }
    }

    public static void holdInOffHand(ServerLevel serverLevel, Yeti p_34933_, ItemStack p_34934_) {
        if (YetiAi.isHoldingItemInOffHand(p_34933_)) {
            p_34933_.spawnAtLocation(serverLevel, p_34933_.getItemInHand(InteractionHand.OFF_HAND));
        }
        p_34933_.holdInOffHand(p_34934_);
    }

    private static boolean isHoldingItemInOffHand(Yeti p_35027_) {
        return !p_35027_.getOffhandItem().isEmpty();
    }

    private static Vec3 getRandomNearbyPos(Yeti p_35017_) {
        Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)p_35017_, (int)4, (int)2);
        return vec3 == null ? p_35017_.position() : vec3;
    }

    public static boolean isWearingFear(LivingEntity p_34809_) {
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ItemStack itemstack = p_34809_.getItemBySlot(equipmentSlot);
            Item item = itemstack.getItem();
            if (!itemstack.is((Item)FrostItems.YETI_FUR_HELMET.get()) && !itemstack.is((Item)FrostItems.YETI_FUR_CHESTPLATE.get()) && !itemstack.is((Item)FrostItems.YETI_FUR_LEGGINGS.get()) && !itemstack.is((Item)FrostItems.YETI_FUR_BOOTS.get())) continue;
            return true;
        }
        return false;
    }

    public static class RandomSitting
    extends Behavior<Yeti> {
        private final int minimalPoseTicks;

        public RandomSitting(int p_251207_) {
            super((Map)ImmutableMap.of());
            this.minimalPoseTicks = p_251207_ * 20;
        }

        protected boolean checkExtraStartConditions(ServerLevel p_249520_, Yeti p_250322_) {
            return !p_250322_.isInWater() && p_250322_.getPoseTime() >= (long)this.minimalPoseTicks && !p_250322_.isLeashed() && p_250322_.onGround() && !p_250322_.hasControllingPassenger() && p_250322_.canYetiChangePose();
        }

        protected void start(ServerLevel p_250901_, Yeti p_250345_, long p_248515_) {
            p_250345_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
            p_250345_.getNavigation().stop();
            if (p_250345_.isYetiSitting()) {
                p_250345_.standUp();
            } else if (!p_250345_.isPanicking()) {
                p_250345_.sitDown();
            }
        }
    }
}

