/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.goal;

import baguchan.frostrealm.entity.IHasEgg;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Animal;

public abstract class FindAndPlaceEggGoal<T extends Animal>
extends MoveToBlockGoal {
    private final T animal;

    public FindAndPlaceEggGoal(T animal, double speed) {
        super(animal, speed, 8);
        this.animal = animal;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return super.canUse() && ((IHasEgg)this.animal).hasEgg();
    }

    public void start() {
        super.start();
    }

    public void tick() {
        super.tick();
        if (this.animal.isAlive() && ((IHasEgg)this.animal).hasEgg()) {
            BlockPos blockpos = this.animal.blockPosition();
            if (this.isReachedTarget()) {
                this.afterPlaceEgg();
                ((IHasEgg)this.animal).setHasEgg(false);
                this.animal.setAge(2400);
            }
        }
    }

    public abstract void afterPlaceEgg();

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

