/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.goal;

import baguchan.frostrealm.capability.FrostWeatherSavedData;
import baguchan.frostrealm.entity.animal.CrystalFox;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.world.entity.ai.goal.Goal;

public class FoxSleepGoal
extends Goal {
    private final CrystalFox mob;
    private int cooldown;

    public FoxSleepGoal(CrystalFox p_25492_) {
        this.mob = p_25492_;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.mob.hasControllingPassenger()) {
            return false;
        }
        if (Objects.equals(this.mob.getState(), CrystalFox.State.SLEEPING.name()) && this.mob.level().isDarkOutside()) {
            return true;
        }
        if (!Objects.equals(this.mob.getState(), CrystalFox.State.IDLING.name())) {
            return false;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.cooldown <= 0 && this.mob.onGround() && !this.mob.isInWater() && (this.mob.level().isDarkOutside() || FrostWeatherSavedData.get(this.mob.level()) != null && FrostWeatherSavedData.get(this.mob.level()).isWeatherActive()) && !this.mob.level().canSeeSky(this.mob.blockPosition())) {
            this.cooldown = this.mob.getRandom().nextInt(600, 1800);
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.mob.onGround() || FrostWeatherSavedData.get(this.mob.level()) != null && FrostWeatherSavedData.get(this.mob.level()).isWeatherActive() || this.mob.level().isDarkOutside();
    }

    public void start() {
        super.start();
        this.mob.setState(CrystalFox.State.SLEEPING);
    }

    public void tick() {
        super.tick();
    }

    public void stop() {
        super.stop();
        this.mob.setState(CrystalFox.State.IDLING);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

