/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.goal;

import baguchan.frostrealm.entity.IGuardMob;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;

public class GuardAnimationGoal<T extends PathfinderMob>
extends Goal {
    protected final T mob;
    protected final int guardLengh;
    protected final boolean onlyTrigger;
    protected boolean trigger;
    protected boolean stopTrigger;
    protected int tick;

    public GuardAnimationGoal(T mob, boolean onlyTrigger, int guardLengh) {
        this.mob = mob;
        this.onlyTrigger = onlyTrigger;
        this.guardLengh = guardLengh;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.onlyTrigger && ((PathfinderMob)this.mob).hurtTime > 0 && this.mob.getRandom().nextInt(80) == 0) {
            return true;
        }
        return this.trigger;
    }

    public boolean canContinueToUse() {
        return this.tick > 0 && !this.stopTrigger;
    }

    public void start() {
        super.start();
        ((IGuardMob)this.mob).setGuard(true);
        this.guardAnimation();
        this.tick = this.guardLengh;
    }

    protected void guardAnimation() {
    }

    protected void stopGuardAnimation() {
    }

    public void stop() {
        super.stop();
        ((IGuardMob)this.mob).setGuard(false);
        this.stopGuardAnimation();
        this.trigger = false;
        this.stopTrigger = false;
    }

    public void tick() {
        --this.tick;
        if (this.mob.getTarget() != null) {
            this.mob.lookAt((Entity)this.mob.getTarget(), 10.0f, 10.0f);
        }
    }

    public void trigger() {
        this.trigger = true;
    }

    public void stopTrigger() {
        this.stopTrigger = true;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

