/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RollGoal
extends Goal {
    private final Mob mob;
    @Nullable
    private BlockPos target;
    private int cooldown = 0;
    private int attackTime = -20;
    private final int attackIntervalMin;
    private final int attackIntervalMax;

    public RollGoal(Mob rangedAttackMob, int attackInterval) {
        this(rangedAttackMob, attackInterval, attackInterval);
    }

    public RollGoal(Mob rangedAttackMob, int attackIntervalMin, int attackIntervalMax) {
        if (!(rangedAttackMob instanceof LivingEntity)) {
            throw new IllegalArgumentException("RollGoal requires Mob");
        }
        this.mob = rangedAttackMob;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity livingentity = this.mob.getTarget();
        if (this.cooldown <= 0) {
            if (livingentity != null && livingentity.isAlive() && this.mob.getSensing().hasLineOfSight((Entity)livingentity)) {
                Vec3 vec3 = this.calculateViewVector(0.0f, this.mob.getYRot()).scale(6.0);
                this.target = BlockPos.containing((Position)vec3.add(livingentity.position()));
                this.cooldown = 60;
                this.mob.getLookControl().setLookAt(this.target.getCenter());
                return true;
            }
        } else {
            --this.cooldown;
        }
        return false;
    }

    protected Vec3 calculateViewVector(float p_20172_, float p_20173_) {
        float f = p_20172_ * ((float)Math.PI / 180);
        float f1 = -p_20173_ * ((float)Math.PI / 180);
        float f2 = Mth.cos((float)f1);
        float f3 = Mth.sin((float)f1);
        float f4 = Mth.cos((float)f);
        float f5 = Mth.sin((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public boolean canContinueToUse() {
        return this.mob.getPose() != Pose.STANDING;
    }

    public void start() {
        super.start();
        this.mob.setPose(Pose.SITTING);
    }

    public void stop() {
        this.target = null;
        if (this.attackTime > -20) {
            this.attackTime = -20;
        }
        this.mob.setPose(Pose.STANDING);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        double d0 = this.mob.distanceToSqr((double)this.target.getX(), (double)this.target.getY(), (double)this.target.getZ());
        float f = (float)Math.sqrt(d0) / 16.0f;
        if (++this.attackTime >= 0) {
            if (this.attackTime == 10) {
                this.mob.setPose(Pose.SPIN_ATTACK);
            }
            if (this.attackTime < 10) {
                this.mob.getNavigation().stop();
                this.mob.getLookControl().setLookAt((double)this.target.getX(), (double)this.target.getY(), (double)this.target.getZ(), 30.0f, 30.0f);
            } else {
                this.mob.getMoveControl().setWantedPosition((double)this.target.getX(), (double)this.target.getY(), (double)this.target.getZ(), 1.5);
                double x = (double)this.target.getX() - this.mob.getX();
                double z = (double)this.target.getZ() - this.mob.getZ();
                if (this.attackTime == 120 || x * x + z * z < 1.0) {
                    this.mob.setPose(Pose.STANDING);
                    this.attackTime = -Mth.floor((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
                }
            }
        }
    }
}

