/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.goal;

import baguchan.frostrealm.entity.boss.Seeker;
import baguchan.frostrealm.entity.goal.WideMeleeAttackGoal;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SeekerAttackGoal
extends WideMeleeAttackGoal {
    public final Seeker seeker;
    public final double speed;

    public SeekerAttackGoal(Seeker seeker, double speed, int actionPoint, int attackLength, double range) {
        super((PathfinderMob)seeker, speed, actionPoint, attackLength, range);
        this.seeker = seeker;
        this.speed = speed;
    }

    public boolean canUse() {
        return this.seeker.getState() != Seeker.SeekerState.BREATH_STOP && super.canUse();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse();
    }

    public void tick() {
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity != null) {
            if (this.actionPoint > this.attackTicks && this.actionPoint - 2 < this.attackTicks) {
                this.mob.getNavigation().stop();
                this.seeker.lookAt((Entity)livingentity, 1.25f, 1.25f);
                this.mob.moveRelative(1.0f, new Vec3(0.0, 0.0, 1.0));
                this.checkAndPerformAttack(livingentity);
            } else if (!this.attack || this.attackTicks < 2) {
                super.tick();
            } else {
                this.mob.getNavigation().stop();
                this.seeker.lookAt((Entity)livingentity, 1.25f, 1.25f);
                this.checkAndPerformAttack(livingentity);
            }
        }
    }

    protected void doTheAnimation() {
        super.doTheAnimation();
        this.seeker.setState(Seeker.SeekerState.ATTACK);
    }

    @Override
    public AABB getAttackBoundingBox(PathfinderMob attacker) {
        return super.getAttackBoundingBox(attacker).inflate(2.0, 2.0, 2.0);
    }
}

