/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.hostile;

import baguchan.frostrealm.entity.movecontrol.CellingMoveControl;
import baguchan.frostrealm.entity.path.CellingPathNavigation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.TransformationHelper;
import org.joml.Quaternionf;

public class CellingMonster
extends Monster {
    public static final EntityDataAccessor<Direction> ATTACHED_FACE = SynchedEntityData.defineId(CellingMonster.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    public static final EntityDataAccessor<Quaternionf> CELL_ROTATION = SynchedEntityData.defineId(CellingMonster.class, (EntityDataSerializer)EntityDataSerializers.QUATERNION);
    public Quaternionf prevRotation = new Quaternionf();
    public float prevAttachChangeProgress;
    public float attachChangeProgress;

    protected CellingMonster(EntityType<? extends CellingMonster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.moveControl = new CellingMoveControl(this);
        this.navigation = new CellingPathNavigation(this, this.level());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACHED_FACE, (Object)Direction.DOWN);
        builder.define(CELL_ROTATION, (Object)new Quaternionf());
    }

    public void calculateEntityAnimation(boolean p_268129_) {
        float f = (float)Mth.length((double)(this.getX() - this.xo), (double)(this.getAttachFacing() != Direction.DOWN ? this.getY() - this.yo : 0.0), (double)(this.getZ() - this.zo));
        if (!this.isPassenger() && this.isAlive()) {
            this.updateWalkAnimation(f);
        } else {
            this.walkAnimation.stop();
        }
    }

    protected void updateWalkAnimation(float p_268239_) {
        float f = this.getAttachFacing() == Direction.DOWN ? Math.min(p_268239_ * 4.0f, 1.0f) : Math.min(p_268239_ * 25.0f, 1.0f);
        this.walkAnimation.update(f, 0.4f, this.isBaby() ? 3.0f : 1.0f);
    }

    public void travel(Vec3 p_32394_) {
        if (this.isLocalInstanceAuthoritative() && this.getAttachFacing() != Direction.DOWN) {
            this.moveRelative(0.1f, p_32394_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.6));
            this.calculateEntityAnimation(false);
        } else {
            super.travel(p_32394_);
        }
    }

    public void tick() {
        this.prevAttachChangeProgress = this.attachChangeProgress;
        if (this.prevRotation != this.getCellRotation()) {
            this.attachChangeProgress = 1.0f;
            this.prevRotation = this.getCellRotation();
        }
        super.tick();
        if (this.attachChangeProgress > 0.0f) {
            this.attachChangeProgress -= 0.1f;
        }
    }

    public float getAttachAmount(float p_20999_) {
        return Mth.lerp((float)p_20999_, (float)this.prevAttachChangeProgress, (float)this.attachChangeProgress);
    }

    protected void customServerAiStep(ServerLevel p_376725_) {
        boolean flag2;
        super.customServerAiStep(p_376725_);
        ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.push("cellingAI");
        boolean flag = this.moveControl instanceof CellingMoveControl && ((CellingMoveControl)this.moveControl).isWalkableUpper();
        boolean bl = flag2 = this.moveControl.hasWanted() && this.moveControl.getWantedY() - this.getY() > 0.0;
        if (!flag && !flag2 && (this.onGround() || this.isInWater() || this.isInLava() || this.isInFluidType())) {
            this.entityData.set(ATTACHED_FACE, (Object)Direction.DOWN);
            this.setCellRotation(new Quaternionf());
        } else {
            Vec3 offset;
            Direction dir;
            BlockPos pos1;
            Direction closestDirection = null;
            Quaternionf closestRotation = new Quaternionf();
            double closestDistance = 2.5;
            BlockPos pos = new BlockPos(Mth.floor((double)this.getX()), Mth.floor((double)(this.getY() + (double)(this.getBbHeight() / 2.0f))), Mth.floor((double)this.getZ()));
            for (BlockPos offsetPos : BlockPos.betweenClosedStream((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1).filter(p_341357_ -> Math.abs(p_341357_.getX() - p_341357_.getY() - p_341357_.getZ()) != 0).map(BlockPos::immutable).toList()) {
                pos1 = pos.offset((Vec3i)offsetPos);
                dir = Direction.getApproximateNearest((float)(pos1.getX() - pos.getX()), (float)(pos1.getY() - pos.getY()), (float)(pos1.getZ() - pos.getZ()));
                offset = Vec3.atCenterOf((Vec3i)pos1);
                if (dir == Direction.DOWN || !(closestDistance > this.position().distanceTo(offset)) || !this.level().loadedAndEntityCanStandOnFace(pos1, (Entity)this, dir.getOpposite())) continue;
                closestDistance = this.position().distanceTo(offset);
                closestDirection = dir;
                closestRotation = TransformationHelper.quatFromXYZ((float)(pos1.getX() - pos.getX()), (float)(pos1.getY() - pos.getY()), (float)(pos1.getZ() - pos.getZ()), (boolean)false);
            }
            if (closestDirection == null) {
                pos = new BlockPos(Mth.floor((double)this.getX()), Mth.floor((double)this.getY()), Mth.floor((double)this.getZ()));
                for (BlockPos offsetPos : BlockPos.betweenClosedStream((int)-1, (int)-1, (int)-1, (int)1, (int)0, (int)1).filter(p_341357_ -> Math.abs(p_341357_.getX() - p_341357_.getY() - p_341357_.getZ()) != 0).map(BlockPos::immutable).toList()) {
                    pos1 = pos.offset((Vec3i)offsetPos);
                    dir = Direction.getApproximateNearest((float)(pos1.getX() - pos.getX()), (float)(pos1.getY() - pos.getY()), (float)(pos1.getZ() - pos.getZ()));
                    offset = Vec3.atCenterOf((Vec3i)pos1);
                    if (dir == Direction.DOWN || !(closestDistance > this.position().distanceTo(offset)) || !this.level().loadedAndEntityCanStandOnFace(pos1, (Entity)this, dir.getOpposite())) continue;
                    closestDistance = this.position().distanceTo(offset);
                    closestDirection = dir;
                    closestRotation = TransformationHelper.quatFromXYZ((float)(pos1.getX() - pos.getX()), (float)(pos1.getY() - pos.getY()), (float)(pos1.getZ() - pos.getZ()), (boolean)false);
                }
            }
            if (closestDirection == null) {
                pos = new BlockPos(Mth.floor((double)this.getX()), Mth.floor((double)(this.getY() + (double)this.getBbHeight())), Mth.floor((double)this.getZ()));
                for (BlockPos offsetPos : BlockPos.betweenClosedStream((int)-1, (int)0, (int)-1, (int)1, (int)1, (int)1).filter(p_341357_ -> Math.abs(p_341357_.getX() - p_341357_.getY() - p_341357_.getZ()) != 0).map(BlockPos::immutable).toList()) {
                    pos1 = pos.offset((Vec3i)offsetPos);
                    dir = Direction.getApproximateNearest((float)(pos1.getX() - pos.getX()), (float)(pos1.getY() - pos.getY()), (float)(pos1.getZ() - pos.getZ()));
                    offset = Vec3.atCenterOf((Vec3i)pos1);
                    if (dir == Direction.DOWN || !(closestDistance > this.position().distanceTo(offset)) || !this.level().loadedAndEntityCanStandOnFace(pos1, (Entity)this, dir.getOpposite())) continue;
                    closestDistance = this.position().distanceTo(offset);
                    closestDirection = dir;
                    closestRotation = TransformationHelper.quatFromXYZ((float)(pos1.getX() - pos.getX()), (float)(pos1.getY() - pos.getY()), (float)(pos1.getZ() - pos.getZ()), (boolean)false);
                }
            }
            if (closestDirection != null && closestDirection != this.getDirection()) {
                this.entityData.set(ATTACHED_FACE, closestDirection);
                this.setCellRotation(closestRotation);
            } else if (Direction.DOWN != this.getDirection() && closestDirection == null) {
                this.entityData.set(ATTACHED_FACE, (Object)Direction.DOWN);
                this.setCellRotation(new Quaternionf());
            }
        }
        profilerfiller.pop();
    }

    protected void checkFallDamage(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
        super.checkFallDamage(p_20990_, p_20991_, p_20992_, p_20993_);
        if (this.getAttachFacing() != Direction.DOWN) {
            this.resetFallDistance();
        }
    }

    public boolean onClimbable() {
        return false;
    }

    protected float getFlyingSpeed() {
        return this.getSpeed() * 0.2f;
    }

    public void readAdditionalSaveData(ValueInput p_33432_) {
        super.readAdditionalSaveData(p_33432_);
        this.setAttachFace(Direction.from3DDataValue((int)p_33432_.getByteOr("AttachFace", (byte)0)));
    }

    public void addAdditionalSaveData(ValueOutput p_33443_) {
        super.addAdditionalSaveData(p_33443_);
        p_33443_.putByte("AttachFace", (byte)this.getAttachFacing().get3DDataValue());
    }

    private void setAttachFace(Direction attachFace) {
        this.entityData.set(ATTACHED_FACE, (Object)attachFace);
    }

    public Direction getAttachFacing() {
        return (Direction)this.entityData.get(ATTACHED_FACE);
    }

    private void setCellRotation(Quaternionf quaternionf) {
        this.entityData.set(CELL_ROTATION, (Object)quaternionf);
    }

    public Quaternionf getCellRotation() {
        return (Quaternionf)this.entityData.get(CELL_ROTATION);
    }
}

