/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.hostile;

import baguchan.frostrealm.data.resource.registries.AttachableCrystals;
import baguchan.frostrealm.entity.IGuardMob;
import baguchan.frostrealm.entity.goal.CounterGoal;
import baguchan.frostrealm.entity.goal.GuardAndCounterAnimationGoal;
import baguchan.frostrealm.entity.utils.GuardHandler;
import baguchan.frostrealm.registry.FrostDataCompnents;
import baguchan.frostrealm.registry.FrostEntities;
import baguchan.frostrealm.registry.FrostItems;
import baguchan.frostrealm.utils.aurorapower.AuroraPowerUtils;
import baguchi.bagus_lib.entity.AnimationScale;
import baguchi.bagus_lib.entity.goal.AnimateAttackGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LesserWarrior
extends AbstractSkeleton
implements IGuardMob {
    private static final EntityDataAccessor<Boolean> DATA_GUARD = SynchedEntityData.defineId(LesserWarrior.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int attackAnimationTick;
    private final int attackAnimationLength = 30;
    private final int attackAnimationActionPoint = 5;
    public int counterAnimationTick;
    private final int counterAnimationLength = 20;
    private final int counterAnimationActionPoint = 4;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState counterAnimationState = new AnimationState();
    public AnimationScale guardAnimationScale = new AnimationScale(0.2f);
    public final GuardHandler guardHandler = new GuardHandler(4);
    public GuardAndCounterAnimationGoal guardAnimationGoal;
    public CounterGoal counterGoal;

    public LesserWarrior(EntityType<? extends LesserWarrior> p_32133_, Level p_32134_) {
        super(p_32133_, p_32134_);
        this.xpReward = 10;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.counterGoal = new CounterGoal(this, (PathfinderMob)this, 4, 20){

            @Override
            protected void doTheAnimation() {
                this.attacker.level().broadcastEntityEvent((Entity)this.attacker, (byte)61);
            }
        };
        this.guardAnimationGoal = new GuardAndCounterAnimationGoal<LesserWarrior>(this, true, 40){

            @Override
            protected void stopGuardAndAttackAnimation() {
                super.stopGuardAndAttackAnimation();
                LesserWarrior.this.counterGoal.trigger();
            }
        };
        this.goalSelector.addGoal(1, (Goal)this.counterGoal);
        this.goalSelector.addGoal(2, (Goal)this.guardAnimationGoal);
        this.goalSelector.addGoal(4, (Goal)new RangedBowAttackGoal((Monster)this, 1.0, 30, 16.0f));
        this.goalSelector.addGoal(4, (Goal)new AnimateAttackGoal((PathfinderMob)this, 1.2, 5, 30){

            public boolean canUse() {
                return !LesserWarrior.this.getMainHandItem().is(Items.BOW) && !LesserWarrior.this.isGuard() && super.canUse();
            }

            public boolean canContinueToUse() {
                return !LesserWarrior.this.getMainHandItem().is(Items.BOW) && !LesserWarrior.this.isGuard() && super.canContinueToUse();
            }
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 18.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_GUARD, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_219422_) {
        super.onSyncedDataUpdated(p_219422_);
        if (DATA_GUARD.equals(p_219422_) && this.isGuard() && !this.level().isClientSide()) {
            this.attackAnimationState.stop();
        }
    }

    @Override
    public void setGuard(boolean guard) {
        this.entityData.set(DATA_GUARD, (Object)guard);
    }

    @Override
    public boolean isGuard() {
        return (Boolean)this.entityData.get(DATA_GUARD);
    }

    public void reassessWeaponGoal() {
    }

    public void baseTick() {
        super.baseTick();
        if (this.level().isClientSide()) {
            if (this.attackAnimationTick < this.attackAnimationLength) {
                ++this.attackAnimationTick;
            }
            if (this.attackAnimationTick >= this.attackAnimationLength) {
                this.attackAnimationState.stop();
            }
            if (this.counterAnimationTick < this.counterAnimationLength) {
                ++this.counterAnimationTick;
                if (this.attackAnimationState.isStarted()) {
                    this.attackAnimationState.stop();
                }
            }
            if (this.counterAnimationTick >= this.counterAnimationLength) {
                this.counterAnimationState.stop();
            }
            if (this.isGuard()) {
                this.attackAnimationState.stop();
                this.counterAnimationState.stop();
            }
            this.guardAnimationScale.setFlag(this.isGuard());
            this.guardAnimationScale.tick((Entity)this);
        } else {
            this.guardHandler.tick((Mob)this);
            if (!this.getMainHandItem().is(Items.BOW) && this.guardHandler.isTrigger() && this.guardAnimationGoal != null) {
                this.guardAnimationGoal.trigger();
                this.guardHandler.setTrigger(false);
                this.guardHandler.resetTrigger(true);
            }
        }
    }

    public void handleEntityEvent(byte p_21375_) {
        if (p_21375_ == 4) {
            this.attackAnimationState.start(this.tickCount);
            this.attackAnimationTick = 0;
        } else if (p_21375_ == 61) {
            this.counterAnimationState.start(this.tickCount);
            this.counterAnimationTick = 0;
        } else {
            super.handleEntityEvent(p_21375_);
        }
    }

    @javax.annotation.Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_34717_, DifficultyInstance p_34718_, EntitySpawnReason p_361787_, @javax.annotation.Nullable SpawnGroupData p_34720_) {
        RandomSource randomsource = p_34717_.getRandom();
        this.populateDefaultEquipmentSlots(randomsource, p_34718_);
        this.populateDefaultEquipmentEnchantments(p_34717_, randomsource, p_34718_);
        return super.finalizeSpawn(p_34717_, p_34718_, p_361787_, p_34720_);
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_218949_, DifficultyInstance p_218950_) {
        if (p_218949_.nextFloat() < 0.75f) {
            spear = new ItemStack((ItemLike)FrostItems.ASTRIUM_SWORD.get());
            AuroraPowerUtils.auroraInfusionItem(p_218949_, spear, 5, false);
            this.setItemSlot(EquipmentSlot.MAINHAND, spear);
        } else {
            spear = new ItemStack((ItemLike)Items.BOW);
            this.setItemSlot(EquipmentSlot.MAINHAND, spear);
        }
        ItemStack helmet = new ItemStack((ItemLike)FrostItems.YETI_FUR_HELMET.get());
        AuroraPowerUtils.auroraInfusionItem(p_218949_, helmet, 5, false);
        this.setItemSlot(EquipmentSlot.HEAD, helmet);
        ItemStack chest = new ItemStack((ItemLike)FrostItems.YETI_FUR_CHESTPLATE.get());
        AuroraPowerUtils.auroraInfusionItem(p_218949_, chest, 5, false);
        this.setItemSlot(EquipmentSlot.CHEST, chest);
    }

    public boolean doHurtTarget(ServerLevel serverLevel, Entity p_21372_) {
        boolean flag = super.doHurtTarget(serverLevel, p_21372_);
        if (flag && this.getMainHandItem().is((Item)FrostItems.FROST_SPEAR.get())) {
            int freezeTick = p_21372_.canFreeze() ? 100 : 40;
            p_21372_.setTicksFrozen(Mth.clamp((int)(p_21372_.getTicksFrozen() + freezeTick), (int)0, (int)600));
        }
        return flag;
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource p_21016_, float p_21017_) {
        if (this.isDamageSourceBlockedBySpear(p_21016_)) {
            this.playSound(SoundEvents.ANVIL_LAND, 1.0f, 1.5f);
            return false;
        }
        if (!this.level().isClientSide()) {
            this.guardHandler.addHurtCount(p_21017_);
        }
        return super.hurtServer(serverLevel, p_21016_, p_21017_);
    }

    protected boolean considersEntityAsAlly(Entity p_360600_) {
        if (super.considersEntityAsAlly(p_360600_)) {
            return true;
        }
        return p_360600_.getType() != FrostEntities.LESSER_WARRIOR.get() ? false : this.getTeam() == null && p_360600_.getTeam() == null;
    }

    public boolean isDamageSourceBlockedBySpear(DamageSource p_21276_) {
        Vec3 vec32;
        AbstractArrow abstractarrow;
        Entity entity = p_21276_.getDirectEntity();
        boolean flag = false;
        if (entity instanceof AbstractArrow && (abstractarrow = (AbstractArrow)entity).getPierceLevel() > 0) {
            flag = true;
        }
        if (!p_21276_.is(DamageTypeTags.BYPASSES_SHIELD) && this.isGuard() && !flag && (vec32 = p_21276_.getSourcePosition()) != null) {
            Vec3 vec3 = this.getViewVector(1.0f);
            Vec3 vec31 = vec32.vectorTo(this.position()).normalize();
            vec31 = new Vec3(vec31.x, 0.0, vec31.z);
            if (vec31.dot(vec3) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkStraySpawnRules(EntityType<LesserWarrior> p_219121_, ServerLevelAccessor p_219122_, EntitySpawnReason p_219123_, BlockPos p_219124_, RandomSource p_219125_) {
        return LesserWarrior.checkMonsterSpawnRules(p_219121_, (ServerLevelAccessor)p_219122_, (EntitySpawnReason)p_219123_, (BlockPos)p_219124_, (RandomSource)p_219125_) && (p_219123_ == EntitySpawnReason.SPAWNER || p_219122_.canSeeSky(p_219124_));
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.STRAY_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource p_33850_) {
        return SoundEvents.STRAY_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.STRAY_DEATH;
    }

    protected boolean isSunBurnTick() {
        return false;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.STRAY_STEP;
    }

    protected AbstractArrow getArrow(ItemStack p_32156_, float p_32157_, @Nullable ItemStack p_346155_) {
        p_32156_.set(FrostDataCompnents.ATTACH_CRYSTAL, (Object)this.level().registryAccess().lookupOrThrow(AttachableCrystals.ATTACHABLE_CRYSTAL_REGISTRY_KEY).getOrThrow(AttachableCrystals.FROST));
        AbstractArrow abstractarrow = super.getArrow(p_32156_, p_32157_, p_346155_);
        return abstractarrow;
    }

    protected AABB getAttackBoundingBox() {
        return this.getMainHandItem().is((Item)FrostItems.FROST_SPEAR.get()) ? super.getAttackBoundingBox().inflate(1.0, 0.0, 1.0) : super.getAttackBoundingBox();
    }
}

