/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.hostile;

import baguchan.frostrealm.entity.goal.ShootProjectileAnimationGoal;
import baguchan.frostrealm.entity.hostile.CellingMonster;
import baguchan.frostrealm.entity.projectile.VenomBall;
import baguchan.frostrealm.registry.FrostEntities;
import baguchi.bagus_lib.entity.goal.AnimateAttackGoal;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class Venochem
extends CellingMonster
implements RangedAttackMob {
    private int attackTick;
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState shootAnimationState = new AnimationState();

    public Venochem(EntityType<? extends Venochem> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide() && this.attackAnimationState.isStarted()) {
            if (this.attackTick >= 40) {
                this.attackAnimationState.stop();
            } else {
                ++this.attackTick;
            }
        }
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(4, (Goal)new AnimateAttackGoal(this, (PathfinderMob)this, 1.1f, 5, 20){

            public boolean canUse() {
                return super.canUse() && this.mob.distanceToSqr((Entity)this.mob.getTarget()) <= 9.0;
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && this.mob.distanceToSqr((Entity)this.mob.getTarget()) <= 36.0;
            }
        });
        this.goalSelector.addGoal(5, (Goal)new ShootProjectileAnimationGoal(this, 0.8f, 20, 60, 12.0f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal(this, (PathfinderMob)this, 0.8f){

            @Nullable
            protected Vec3 getPosition() {
                return this.mob.getRandom().nextFloat() >= this.probability ? DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7) : super.getPosition();
            }
        });
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false).setUnseenMemoryTicks(300));
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 61) {
            this.attackAnimationState.start(this.tickCount);
            this.attackTick = 0;
            this.shootAnimationState.stop();
        } else if (pId == 62) {
            this.shootAnimationState.start(this.tickCount);
            this.attackAnimationState.stop();
        } else if (pId == 63) {
            this.shootAnimationState.stop();
        } else {
            super.handleEntityEvent(pId);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 14.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 18.0).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public static boolean checkVenochemSpawnRules(EntityType<? extends Monster> p_219014_, ServerLevelAccessor p_219015_, EntitySpawnReason p_361180_, BlockPos p_219017_, RandomSource p_219018_) {
        return p_219015_.getDifficulty() != Difficulty.PEACEFUL && (EntitySpawnReason.ignoresLightRequirements((EntitySpawnReason)p_361180_) || Venochem.isDarkEnoughToSpawn((ServerLevelAccessor)p_219015_, (BlockPos)p_219017_, (RandomSource)p_219018_)) && Venochem.checkDirectionSpawnRules((LevelAccessor)p_219015_, p_219017_);
    }

    public static boolean checkDirectionSpawnRules(LevelAccessor p_217059_, BlockPos p_217061_) {
        int n = 0;
        Direction[] directionArray = Direction.values();
        int n2 = directionArray.length;
        if (n < n2) {
            Direction direction = directionArray[n];
            BlockPos blockpos = p_217061_.offset(direction.getUnitVec3i());
            return p_217059_.getBlockState(blockpos).isSolid();
        }
        return false;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        VenomBall ball = new VenomBall((EntityType<? extends VenomBall>)((EntityType)FrostEntities.VENOM_BALL.get()), (LivingEntity)this, this.level());
        double d0 = target.getEyeY() - this.getEyeY();
        double d1 = target.getX() - this.getX();
        double d3 = target.getZ() - this.getZ();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        ball.setXRot(ball.getXRot() - -20.0f);
        ball.shoot(d1, d0 + d4, d3, 0.8f, 6.0f);
        this.playSound(SoundEvents.SLIME_ATTACK, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)ball);
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        return effect.getEffect() != MobEffects.POISON && super.canBeAffected(effect);
    }
}

