/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.hostile;

import baguchan.frostrealm.capability.FrostWeatherSavedData;
import baguchan.frostrealm.registry.FrostBiomes;
import baguchan.frostrealm.registry.FrostWeathers;
import baguchan.frostrealm.utils.BlizzardUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public abstract class WarpedMonster
extends Monster {
    public WarpedMonster(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource p_21016_, float p_21017_) {
        if (p_21016_.is(DamageTypeTags.IS_FIRE)) {
            float f = 2.0f;
            p_21017_ = Mth.clamp((float)(p_21017_ * 1.25f + 1.0f), (float)0.0f, (float)this.getMaxHealth());
        }
        return super.hurtServer(serverLevel, p_21016_, p_21017_);
    }

    public boolean checkSpawnRules(LevelAccessor p_21686_, EntitySpawnReason p_21687_) {
        return true;
    }

    public static boolean checkWarpedMonsterSpawnRules(EntityType<? extends WarpedMonster> p_27578_, ServerLevelAccessor p_27579_, EntitySpawnReason p_27580_, BlockPos p_27581_, RandomSource p_27582_) {
        return p_27579_.getDifficulty() != Difficulty.PEACEFUL && (EntitySpawnReason.ignoresLightRequirements((EntitySpawnReason)p_27580_) || WarpedMonster.checkMobSpawnRules(p_27578_, (LevelAccessor)p_27579_, (EntitySpawnReason)p_27580_, (BlockPos)p_27581_, (RandomSource)p_27582_) && WarpedMonster.isDarkEnoughToSpawn((ServerLevelAccessor)p_27579_, (BlockPos)p_27581_, (RandomSource)p_27582_) && p_27579_.getBiome(p_27581_).is(FrostBiomes.SHERBET_DESERT) || FrostWeatherSavedData.get((Level)p_27579_.getLevel()).isWeatherActive() && FrostWeatherSavedData.get((Level)p_27579_.getLevel()).getFrostWeather() == FrostWeathers.PURPLE_FOG.get() && BlizzardUtils.isAffectWeather((LevelAccessor)p_27579_, p_27581_) && WarpedMonster.checkMobSpawnRules(p_27578_, (LevelAccessor)p_27579_, (EntitySpawnReason)p_27580_, (BlockPos)p_27581_, (RandomSource)p_27582_));
    }

    public void aiStep() {
        boolean flag;
        if (this.isAlive() && (flag = this.isSunBurnTick())) {
            ItemStack itemstack = this.getItemBySlot(EquipmentSlot.HEAD);
            if (!itemstack.isEmpty()) {
                if (itemstack.isDamageableItem()) {
                    itemstack.setDamageValue(itemstack.getDamageValue() + this.random.nextInt(2));
                    if (itemstack.getDamageValue() >= itemstack.getMaxDamage()) {
                        this.onEquippedItemBroken(itemstack.getItem(), EquipmentSlot.HEAD);
                        this.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.igniteForSeconds(8.0f);
            }
        }
        super.aiStep();
    }
}

