/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.movecontrol;

import baguchan.frostrealm.entity.hostile.CellingMonster;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathType;

public class CellingMoveControl
extends MoveControl {
    public CellingMonster cellingMonster;

    public CellingMoveControl(CellingMonster cellingMonster) {
        super((Mob)cellingMonster);
        this.cellingMonster = cellingMonster;
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            if (this.cellingMonster.getAttachFacing() == Direction.DOWN) {
                this.operation = MoveControl.Operation.WAIT;
                double d0 = this.wantedX - this.mob.getX();
                double d1 = this.wantedZ - this.mob.getZ();
                double d2 = this.wantedY - this.mob.getY();
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                float f9 = (float)(Mth.atan2((double)d1, (double)d0) * 180.0 / 3.1415927410125732) - 90.0f;
                if (d3 < 2.500000277905201E-7) {
                    this.mob.setXxa(0.0f);
                    this.mob.setYya(0.0f);
                    this.mob.setZza(0.0f);
                    return;
                }
                float f1 = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED));
                if (Math.abs(d2) > 0.0 && this.isWalkableUpper()) {
                    this.mob.setYya(d2 > 0.0 ? f1 : -f1);
                }
                this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                this.mob.setYRot(this.rotlerp(this.mob.getYRot(), f9, 90.0f));
            } else {
                this.operation = MoveControl.Operation.WAIT;
                double d4 = this.cellingMonster.getAttachFacing() != Direction.DOWN ? (double)0.15f : 0.0;
                double d0 = this.wantedX - this.mob.getX();
                double d1 = this.wantedZ - this.mob.getZ();
                double d2 = this.wantedY - this.mob.getY() + d4;
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.500000277905201E-7) {
                    this.mob.setXxa(0.0f);
                    this.mob.setYya(0.0f);
                    this.mob.setZza(0.0f);
                    return;
                }
                float f1 = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED));
                if (Math.abs(d2) > 0.0) {
                    this.mob.setYya(d2 > 0.0 ? f1 : -f1);
                }
                float f9 = (float)(Mth.atan2((double)d1, (double)d0) * 180.0 / 3.1415927410125732) - 90.0f;
                this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                this.mob.setYRot(this.rotlerp(this.mob.getYRot(), f9, 90.0f));
            }
        } else if (this.operation == MoveControl.Operation.JUMPING) {
            this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
            if (this.mob.onGround()) {
                this.operation = MoveControl.Operation.WAIT;
            }
        } else {
            this.mob.setXxa(0.0f);
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
        }
    }

    public boolean isWalkableUpper() {
        NodeEvaluator nodeevaluator;
        PathNavigation pathnavigation = this.mob.getNavigation();
        return pathnavigation == null || (nodeevaluator = pathnavigation.getNodeEvaluator()) == null || nodeevaluator.getPathType(this.mob, BlockPos.containing((double)this.mob.getX(), (double)((double)this.mob.getBlockY() + 1.0), (double)this.mob.getZ())) == PathType.OPEN;
    }
}

