/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.path;

import baguchan.frostrealm.entity.hostile.CellingMonster;
import baguchan.frostrealm.entity.path.node.CellingNodeEvaluator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class CellingPathNavigation
extends GroundPathNavigation {
    public final CellingMonster cellingMonster;

    public CellingPathNavigation(CellingMonster mob, Level level) {
        super((Mob)mob, level);
        this.cellingMonster = mob;
    }

    protected boolean canUpdatePath() {
        return true;
    }

    public boolean canCutCorner(PathType p_326808_) {
        return this.cellingMonster.getAttachFacing() == Direction.DOWN && super.canCutCorner(p_326808_);
    }

    protected PathFinder createPathFinder(int p_26598_) {
        this.nodeEvaluator = new CellingNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        this.nodeEvaluator.setCanOpenDoors(false);
        this.nodeEvaluator.setCanFloat(true);
        return new PathFinder(this.nodeEvaluator, p_26598_);
    }

    public void tick() {
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (!this.isDone()) {
            if (this.canUpdatePath()) {
                this.followThePath();
            } else if (this.path != null && !this.path.isDone()) {
                Vec3 vec3 = this.path.getNextEntityPos((Entity)this.mob);
                if (this.mob.getBlockX() == Mth.floor((double)vec3.x) && this.mob.getBlockY() == Mth.floor((double)vec3.y) && this.mob.getBlockZ() == Mth.floor((double)vec3.z)) {
                    this.path.advance();
                }
            }
            if (!this.isDone()) {
                Vec3 vec31 = this.path.getNextEntityPos((Entity)this.mob);
                this.mob.getMoveControl().setWantedPosition(vec31.x, vec31.y, vec31.z, this.speedModifier);
            }
        }
    }

    protected void followThePath() {
        boolean flag;
        Vec3 vec3 = this.getTempMobPos();
        this.maxDistanceToWaypoint = this.mob.getBbWidth() > 0.75f ? this.mob.getBbWidth() / 2.0f : 0.75f - this.mob.getBbWidth() / 2.0f;
        BlockPos vec3i = this.path.getNextNodePos();
        double d0 = Math.abs(this.mob.getX() - ((double)vec3i.getX() + (double)(this.mob.getBbWidth() + 1.0f) / 2.0));
        double d1 = Math.abs(this.mob.getY() - (double)vec3i.getY());
        double d2 = Math.abs(this.mob.getZ() - ((double)vec3i.getZ() + (double)(this.mob.getBbWidth() + 1.0f) / 2.0));
        float fallDistance = this.mob.getMaxFallDistance();
        boolean bl = flag = d0 <= (double)this.maxDistanceToWaypoint && d2 <= (double)this.maxDistanceToWaypoint && d1 <= (double)this.maxDistanceToWaypoint;
        if (flag || this.canCutCorner(this.path.getNextNode().type) && this.shouldTargetNextNodeInDirection(vec3)) {
            this.path.advance();
        }
        this.doStuckDetection(vec3);
    }

    private boolean shouldTargetNextNodeInDirection(Vec3 pVec) {
        boolean flag1;
        if (this.path.getNextNodeIndex() + 1 >= this.path.getNodeCount()) {
            return false;
        }
        Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)this.path.getNextNodePos());
        if (!pVec.closerThan((Position)vec3, 2.0)) {
            return false;
        }
        if (this.canMoveDirectly(pVec, this.path.getNextEntityPos((Entity)this.mob))) {
            return true;
        }
        Vec3 vec31 = Vec3.atBottomCenterOf((Vec3i)this.path.getNodePos(this.path.getNextNodeIndex() + 1));
        Vec3 vec32 = vec3.subtract(pVec);
        Vec3 vec33 = vec31.subtract(pVec);
        double d0 = vec32.lengthSqr();
        double d1 = vec33.lengthSqr();
        boolean flag = d1 < d0;
        boolean bl = flag1 = d0 < 0.5;
        if (!flag && !flag1) {
            return false;
        }
        Vec3 vec34 = vec32.normalize();
        Vec3 vec35 = vec33.normalize();
        return vec35.dot(vec34) < 0.0;
    }

    protected boolean canMoveDirectly(Vec3 p_186138_, Vec3 p_186139_) {
        return false;
    }

    public boolean isStableDestination(BlockPos p_26608_) {
        return true;
    }

    public void setCanFloat(boolean p_26563_) {
        this.nodeEvaluator.setCanFloat(p_26563_);
    }

    protected boolean hasValidPathType(PathType p_326937_) {
        return super.hasValidPathType(p_326937_) || p_326937_ == PathType.OPEN;
    }

    protected Vec3 getTempMobPos() {
        if (this.cellingMonster.getAttachFacing() != Direction.DOWN) {
            return new Vec3(this.mob.getX(), this.mob.getY() + 0.5, this.mob.getZ());
        }
        return super.getTempMobPos();
    }
}

