/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.path;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MultiLegPathNavigation
extends GroundPathNavigation {
    public MultiLegPathNavigation(Mob mob, Level level) {
        super(mob, level);
    }

    protected void followThePath() {
        boolean flag;
        Vec3 vec3 = this.getTempMobPos();
        this.maxDistanceToWaypoint = this.mob.getBbWidth() > 0.75f ? this.mob.getBbWidth() / 2.0f : 0.75f - this.mob.getBbWidth() / 2.0f;
        BlockPos vec3i = this.path.getNextNodePos();
        double d0 = Math.abs(this.mob.getX() - ((double)vec3i.getX() + (double)(this.mob.getBbWidth() + 1.0f) / 2.0));
        double d1 = Math.abs(this.mob.getY() - (double)vec3i.getY());
        double d2 = Math.abs(this.mob.getZ() - ((double)vec3i.getZ() + (double)(this.mob.getBbWidth() + 1.0f) / 2.0));
        float fallDistance = 6.0f;
        boolean bl = flag = d0 <= (double)this.maxDistanceToWaypoint && d2 <= (double)this.maxDistanceToWaypoint && d1 < (double)fallDistance;
        if (flag || this.canCutCorner(this.path.getNextNode().type) && this.shouldTargetNextNodeInDirection(vec3)) {
            this.path.advance();
        }
        this.doStuckDetection(vec3);
    }

    private boolean shouldTargetNextNodeInDirection(Vec3 pVec) {
        boolean flag1;
        if (this.path.getNextNodeIndex() + 1 >= this.path.getNodeCount()) {
            return false;
        }
        Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)this.path.getNextNodePos());
        if (!pVec.closerThan((Position)vec3, 2.0)) {
            return false;
        }
        if (this.canMoveDirectly(pVec, this.path.getNextEntityPos((Entity)this.mob))) {
            return true;
        }
        Vec3 vec31 = Vec3.atBottomCenterOf((Vec3i)this.path.getNodePos(this.path.getNextNodeIndex() + 1));
        Vec3 vec32 = vec3.subtract(pVec);
        Vec3 vec33 = vec31.subtract(pVec);
        double d0 = vec32.lengthSqr();
        double d1 = vec33.lengthSqr();
        boolean flag = d1 < d0;
        boolean bl = flag1 = d0 < 0.5;
        if (!flag && !flag1) {
            return false;
        }
        Vec3 vec34 = vec32.normalize();
        Vec3 vec35 = vec33.normalize();
        return vec35.dot(vec34) < 0.0;
    }

    protected boolean canUpdatePath() {
        return true;
    }
}

