/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.projectile;

import baguchan.frostrealm.registry.FrostDamageType;
import baguchan.frostrealm.registry.FrostParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class VenomBall
extends ThrowableProjectile {
    public VenomBall(EntityType<? extends ThrowableProjectile> p_37466_, Level p_37467_) {
        super(p_37466_, p_37467_);
    }

    public VenomBall(EntityType<? extends ThrowableProjectile> p_37456_, double p_37457_, double p_37458_, double p_37459_, Level p_37460_) {
        super(p_37456_, p_37457_, p_37458_, p_37459_, p_37460_);
    }

    public VenomBall(EntityType<? extends VenomBall> p_37438_, LivingEntity p_37439_, Level p_37440_) {
        this(p_37438_, p_37439_.getX(), p_37439_.getEyeY() - (double)0.1f, p_37439_.getZ(), p_37440_);
        this.setOwner((Entity)p_37439_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326003_) {
    }

    public void handleEntityEvent(byte p_37484_) {
        if (p_37484_ == 3) {
            double d0 = 0.08;
            for (int i = 0; i < 12; ++i) {
                this.level().addParticle((ParticleOptions)FrostParticleTypes.VENOM_CLOUD.get(), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.35, ((double)this.random.nextFloat() - 0.5) * 0.35, ((double)this.random.nextFloat() - 0.5) * 0.35);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            double d0 = 0.08;
            this.level().addParticle((ParticleOptions)FrostParticleTypes.VENOM_BUBBLE.get(), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
        }
    }

    protected void onHitBlock(BlockHitResult p_37258_) {
        super.onHitBlock(p_37258_);
    }

    protected void onHitEntity(EntityHitResult p_326121_) {
        super.onHitEntity(p_326121_);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            LivingEntity livingentity1;
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = this.getOwner();
            LivingEntity livingentity = entity instanceof LivingEntity ? (livingentity1 = (LivingEntity)entity) : null;
            Entity entity2 = p_326121_.getEntity();
            if (livingentity != null) {
                livingentity.setLastHurtMob(entity2);
            }
            int poison = this.level().getDifficulty().getId();
            DamageSource damagesource = this.damageSources().source(FrostDamageType.VENOM_BALL, (Entity)this, (Entity)livingentity);
            if (entity2.hurtServer(serverLevel, damagesource, 2.0f) && entity2 instanceof LivingEntity) {
                LivingEntity livingentity2 = (LivingEntity)entity2;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)this.level()), (Entity)livingentity2, (DamageSource)damagesource);
                livingentity2.addEffect(new MobEffectInstance(MobEffects.POISON, 40 + 20 * poison));
            }
        }
    }

    protected void onHit(HitResult p_326337_) {
        super.onHit(p_326337_);
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.playSound(SoundEvents.SLIME_BLOCK_BREAK, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.discard();
        }
    }
}

