/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.registry;

import baguchan.frostrealm.registry.FrostSounds;
import baguchan.frostrealm.registry.FrostTags;
import baguchan.frostrealm.weather.FrostWeather;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;

@EventBusSubscriber(modid="frostrealm")
public class FrostWeathers {
    public static final ResourceKey<Registry<FrostWeather>> WEATHER_RESOURCE_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_weather"));
    public static final DeferredRegister<FrostWeather> FROST_WEATHER = DeferredRegister.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_weather"), (String)"frostrealm");
    public static final Supplier<FrostWeather> NOPE = FROST_WEATHER.register("nope", () -> new FrostWeather(new FrostWeather.Properties(new FrostWeather.FogProperties(1.0f, 1.0f, 1.0f, 0.85f), Optional.empty(), Optional.empty(), false)));
    public static final Supplier<FrostWeather> BLIZZARD = FROST_WEATHER.register("blizzard", () -> new FrostWeather(new FrostWeather.Properties(new FrostWeather.FogProperties(0.9f, 0.9f, 0.9f, 0.1f), Optional.of((SoundEvent)FrostSounds.BLIZZARD_AMBIENT.get()), Optional.of(FrostTags.Biomes.HOT_BIOME), true)));
    public static final Supplier<FrostWeather> PURPLE_FOG = FROST_WEATHER.register("purple_fog", () -> new FrostWeather(new FrostWeather.Properties(new FrostWeather.FogProperties(0.6f, 0.0f, 0.6f, 0.15f), Optional.empty(), Optional.empty(), true)));
    public static final Supplier<FrostWeather> STARFALL = FROST_WEATHER.register("starfall", () -> new FrostWeather(new FrostWeather.Properties(new FrostWeather.FogProperties(0.6f, 0.9f, 0.1f, 0.8f), Optional.empty(), Optional.empty(), true)));
    private static Registry<FrostWeather> registry;

    @SubscribeEvent
    public static void onNewRegistry(NewRegistryEvent event) {
        registry = event.create(new RegistryBuilder(WEATHER_RESOURCE_KEY));
    }

    public static Registry<FrostWeather> getRegistry() {
        if (registry == null) {
            throw new IllegalStateException("Registry not yet initialized");
        }
        return registry;
    }
}

