/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class BlockPlaceUtils {
    public static void placeDisk(WorldGenLevel level, BlockStateProvider blockProvider, BlockPos center, float radius, RandomSource random, boolean replaceBlocks) {
        float radiusSq = radius * radius;
        BlockPlaceUtils.placeProvidedBlock(level, blockProvider, center, random, replaceBlocks);
        int z = 0;
        while ((float)z < radius) {
            int x = 0;
            while ((float)x < radius) {
                if (!((float)(x * x + z * z) > radiusSq)) {
                    BlockPlaceUtils.placeProvidedBlock(level, blockProvider, center.offset(x, 0, z), random, replaceBlocks);
                    BlockPlaceUtils.placeProvidedBlock(level, blockProvider, center.offset(-x, 0, -z), random, replaceBlocks);
                    BlockPlaceUtils.placeProvidedBlock(level, blockProvider, center.offset(-z, 0, x), random, replaceBlocks);
                    BlockPlaceUtils.placeProvidedBlock(level, blockProvider, center.offset(z, 0, -x), random, replaceBlocks);
                }
                ++x;
            }
            ++z;
        }
    }

    public static boolean placeProvidedBlock(WorldGenLevel level, BlockStateProvider provider, BlockPos pos, RandomSource random, boolean replaceBlocks) {
        if (replaceBlocks) {
            return level.setBlock(pos, provider.getState(random, pos), 2);
        }
        if (level.getBlockState(pos).isAir()) {
            return level.setBlock(pos, provider.getState(random, pos), 2);
        }
        return false;
    }
}

