/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Player;

public class ClientUtils {
    public static void playPortalSound(Player localPlayer) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forLocalAmbience((SoundEvent)SoundEvents.PORTAL_TRIGGER, (float)(localPlayer.getRandom().nextFloat() * 0.4f + 0.8f), (float)0.25f));
    }

    private static int getLayerColorSafe(int[] p_387884_, int p_388524_) {
        return p_388524_ >= p_387884_.length ? -1 : p_387884_[p_388524_];
    }

    private static void renderQuadList(PoseStack p_115163_, VertexConsumer p_115164_, List<BakedQuad> p_115165_, int[] p_387305_, int p_115167_, int p_115168_) {
        PoseStack.Pose posestack$pose = p_115163_.last();
        for (BakedQuad bakedquad : p_115165_) {
            float f3;
            float f2;
            float f1;
            float f;
            if (bakedquad.isTinted()) {
                int i = ClientUtils.getLayerColorSafe(p_387305_, bakedquad.tintIndex());
                f = (float)ARGB.alpha((int)i) / 255.0f;
                f1 = (float)ARGB.red((int)i) / 255.0f;
                f2 = (float)ARGB.green((int)i) / 255.0f;
                f3 = (float)ARGB.blue((int)i) / 255.0f;
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
                f3 = 1.0f;
            }
            p_115164_.putBulkData(posestack$pose, bakedquad, f1, f2, f3, f, p_115167_, p_115168_, true);
        }
    }
}

