/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.utils;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LookUtils {
    public static boolean hasLineOfSightOnlyClip(LivingEntity entity, Entity target) {
        if (target.level() != entity.level()) {
            return false;
        }
        Vec3 vec3 = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
        Vec3 vec31 = new Vec3(target.getX(), target.getEyeY(), target.getZ());
        if (vec31.distanceTo(vec3) > 128.0) {
            return false;
        }
        return entity.level().clip(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity)).getType() == HitResult.Type.MISS;
    }

    public static boolean isLookingAtYouTest(LivingEntity entity, Entity target) {
        float nearDistance = 3.0f;
        float farDistance = entity.getAttribute(Attributes.FOLLOW_RANGE) != null ? (float)entity.getAttributeBaseValue(Attributes.FOLLOW_RANGE) : 16.0f;
        float largeAngle = 83.0f;
        float smallAngle = 30.0f;
        Vec3 vec3 = entity.getViewVector(1.0f).normalize();
        Vec3 vec31 = new Vec3(target.getX() - entity.getX(), target.getEyeY() - entity.getEyeY(), target.getZ() - entity.getZ());
        double d0 = vec31.length();
        double d1 = vec3.dot(vec31 = vec31.normalize());
        double angleDif = d1 * (double)largeAngle;
        if (angleDif > (double)largeAngle) {
            return false;
        }
        if (angleDif < (double)smallAngle) {
            double distanceThreshold = farDistance;
            return false;
        }
        return true;
    }
}

