/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.utils.aurorapower;

import baguchan.frostrealm.aurorapower.AuroraPower;
import baguchan.frostrealm.item.component.ItemAuroraPower;
import baguchan.frostrealm.registry.AuroraPowers;
import baguchan.frostrealm.registry.FrostDataCompnents;
import baguchan.frostrealm.utils.aurorapower.AuroraPowerInstance;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AuroraPowerUtils {
    private static final String TAG_ENCH_ID = "id";
    private static final String TAG_ENCH_LEVEL = "lvl";
    private static final float SWIFT_SNEAK_EXTRA_FACTOR = 0.15f;

    @Nullable
    public static int getAuroraPowerLevel(ItemAuroraPower itemAuroraPower, AuroraPower auroraPower) {
        return itemAuroraPower.getLevel(auroraPower);
    }

    @Deprecated
    public static int getItemAuroraPowerLevel(AuroraPower p_44844_, ItemStack p_44845_) {
        return AuroraPowerUtils.getTagAuroraPowerLevel(p_44844_, p_44845_);
    }

    public static int getTagAuroraPowerLevel(AuroraPower p_44844_, ItemStack p_44845_) {
        if (p_44845_.isEmpty()) {
            return 0;
        }
        int i = 0;
        ItemAuroraPower auroraPower = AuroraPowerUtils.getAuroraPowersRaw(p_44845_);
        if (i < auroraPower.size()) {
            return AuroraPowerUtils.getAuroraPowerLevel(auroraPower, p_44844_);
        }
        return 0;
    }

    public static ItemAuroraPower getAuroraPowersRaw(ItemStack p_41164_) {
        ItemAuroraPower auroraPower = (ItemAuroraPower)p_41164_.getOrDefault(FrostDataCompnents.AURORA_POWER, (Object)ItemAuroraPower.EMPTY);
        return auroraPower;
    }

    public static ItemAuroraPower getAuroraPowers(ItemStack p_44832_) {
        ItemAuroraPower auroraPower = AuroraPowerUtils.getAuroraPowersRaw(p_44832_);
        return auroraPower;
    }

    private static void runIterationOnItem(AuroraPowerVisitor p_44851_, ItemStack p_44852_) {
        if (!p_44852_.isEmpty()) {
            for (Object2IntMap.Entry<Holder<AuroraPower>> entry : AuroraPowerUtils.getAuroraPowers(p_44852_).entrySet()) {
                p_44851_.accept((AuroraPower)((Holder)entry.getKey()).value(), entry.getValue());
            }
            return;
        }
    }

    private static void runIterationOnInventory(AuroraPowerVisitor p_44854_, Iterable<ItemStack> p_44855_) {
        for (ItemStack itemstack : p_44855_) {
            AuroraPowerUtils.runIterationOnItem(p_44854_, itemstack);
        }
    }

    public static int getAuroraPowerLevel(AuroraPower p_44837_, LivingEntity p_44838_) {
        Collection<ItemStack> iterable = p_44837_.getSlotItems(p_44838_).values();
        if (iterable == null) {
            return 0;
        }
        int i = 0;
        for (ItemStack itemstack : iterable) {
            int j = AuroraPowerUtils.getItemAuroraPowerLevel(p_44837_, itemstack);
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    @Nullable
    public static Map.Entry<EquipmentSlot, ItemStack> getRandomItemWith(AuroraPower p_44907_, LivingEntity p_44908_) {
        return AuroraPowerUtils.getRandomItemWith(p_44907_, p_44908_, p_44941_ -> true);
    }

    public static int getAuroraCost(RandomSource p_220288_, int p_220289_, int p_220290_) {
        if (p_220290_ > 15) {
            p_220290_ = 15;
        }
        int i = p_220288_.nextInt(8) + 1 + (p_220290_ >> 1) + p_220288_.nextInt(p_220290_ + 1);
        if (p_220289_ == 0) {
            return Math.max(i / 3, 1);
        }
        return p_220289_ == 1 ? i * 2 / 3 + 1 : Math.max(i, p_220290_ * 2);
    }

    @Nullable
    public static Map.Entry<EquipmentSlot, ItemStack> getRandomItemWith(AuroraPower p_44840_, LivingEntity p_44841_, Predicate<ItemStack> p_44842_) {
        Map<EquipmentSlot, ItemStack> map = p_44840_.getSlotItems(p_44841_);
        if (map.isEmpty()) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<EquipmentSlot, ItemStack> entry : map.entrySet()) {
            ItemStack itemstack = entry.getValue();
            if (itemstack.isEmpty() || AuroraPowerUtils.getItemAuroraPowerLevel(p_44840_, itemstack) <= 0 || !p_44842_.test(itemstack)) continue;
            list.add(entry);
        }
        return list.isEmpty() ? null : (Map.Entry)list.get(p_44841_.getRandom().nextInt(list.size()));
    }

    public static int getAuroraPowerCost(RandomSource p_220288_, int p_220289_, int p_220290_, ItemStack p_220291_) {
        Item item = p_220291_.getItem();
        int i = 1;
        if (i <= 0) {
            return 0;
        }
        if (p_220290_ > 15) {
            p_220290_ = 15;
        }
        int j = p_220288_.nextInt(8) + 1 + (p_220290_ >> 1) + p_220288_.nextInt(p_220290_ + 1);
        if (p_220289_ == 0) {
            return Math.max(j / 3, 1);
        }
        return p_220289_ == 1 ? j * 2 / 3 + 1 : Math.max(j, p_220290_ * 2);
    }

    public static ItemStack auroraInfusionItem(RandomSource p_220293_, ItemStack p_220294_, int p_220295_, boolean p_220296_) {
        List<AuroraPowerInstance> list = AuroraPowerUtils.selectAuroraPower(p_220293_, p_220294_, p_220295_, p_220296_);
        for (AuroraPowerInstance auroraPowerinstance : list) {
            AuroraPowerUtils.auroraInfusion(p_220294_, auroraPowerinstance.auroraPower, auroraPowerinstance.level);
        }
        return p_220294_;
    }

    public static void auroraInfusion(ItemStack stack, AuroraPower p_41664_, int p_41665_) {
        ItemAuroraPower itemAuroraPower = (ItemAuroraPower)stack.getOrDefault(FrostDataCompnents.AURORA_POWER, (Object)ItemAuroraPower.EMPTY);
        ItemAuroraPower.Mutable mutable = new ItemAuroraPower.Mutable(itemAuroraPower);
        mutable.upgrade(p_41664_, (byte)p_41665_);
        stack.set(FrostDataCompnents.AURORA_POWER, (Object)mutable.toImmutable());
    }

    private static ResourceLocation getAuroraPowerId(AuroraPower p41664) {
        return AuroraPowers.getRegistry().getKey((Object)p41664);
    }

    public static List<AuroraPowerInstance> selectAuroraPower(RandomSource p_220298_, ItemStack p_220299_, int p_220300_, boolean p_220301_) {
        ArrayList list = Lists.newArrayList();
        Item item = p_220299_.getItem();
        int i = 1;
        if (i <= 0) {
            return list;
        }
        p_220300_ += 1 + p_220298_.nextInt(i / 4 + 1) + p_220298_.nextInt(i / 4 + 1);
        float f = (p_220298_.nextFloat() + p_220298_.nextFloat() - 1.0f) * 0.15f;
        List<AuroraPowerInstance> list1 = AuroraPowerUtils.getAvailableAuroraPowerResults(p_220300_ = Mth.clamp((int)Math.round((float)p_220300_ + (float)p_220300_ * f), (int)1, (int)Integer.MAX_VALUE), p_220299_, p_220301_);
        if (!list1.isEmpty()) {
            WeightedRandom.getRandomItem((RandomSource)p_220298_, list1, AuroraPowerInstance::weight).ifPresent(list::add);
            while (p_220298_.nextInt(50) <= p_220300_) {
                if (!list.isEmpty()) {
                    AuroraPowerUtils.filterCompatibleAuroraPowers(p_220299_, list1, (AuroraPowerInstance)Util.lastOf((List)list));
                }
                if (list1.isEmpty()) break;
                WeightedRandom.getRandomItem((RandomSource)p_220298_, list1, AuroraPowerInstance::weight).ifPresent(list::add);
                p_220300_ /= 2;
            }
        }
        return list;
    }

    public static void filterCompatibleAuroraPowers(ItemStack stack, List<AuroraPowerInstance> p_44863_, AuroraPowerInstance p_44864_) {
        Iterator<AuroraPowerInstance> iterator = p_44863_.iterator();
        while (iterator.hasNext()) {
            if (p_44864_.auroraPower.isCompatibleWith(stack, iterator.next().auroraPower) || p_44864_.auroraPower.canApplyItem(stack)) continue;
            iterator.remove();
        }
    }

    public static List<AuroraPowerInstance> getAvailableAuroraPowerResults(int p_44818_, ItemStack p_44819_, boolean p_44820_) {
        ArrayList list = Lists.newArrayList();
        Item item = p_44819_.getItem();
        block0: for (AuroraPower auroraPower : AuroraPowers.getRegistry()) {
            if (auroraPower.isTresureEnchant() && !p_44820_ || auroraPower.isOnlyChest() || !auroraPower.isCompatibleWith(p_44819_) || !auroraPower.canApplyItem(p_44819_)) continue;
            for (int i = auroraPower.getMaxLevel(); i > auroraPower.getMinLevel() - 1; --i) {
                if (p_44818_ < auroraPower.getMinCost(i) || p_44818_ > auroraPower.getMaxCost(i)) continue;
                list.add(new AuroraPowerInstance(auroraPower, i));
                continue block0;
            }
        }
        return list;
    }

    public static Component auroraPowerNameWithLevel(AuroraPower auroraPower, int integer) {
        ChatFormatting[] textformatting = new ChatFormatting[]{ChatFormatting.GREEN};
        return Component.translatable((String)("aurora_power." + AuroraPowers.getRegistry().getKey((Object)auroraPower).getNamespace() + "." + AuroraPowers.getRegistry().getKey((Object)auroraPower).getPath())).withStyle(textformatting).append(" ").append((Component)Component.translatable((String)("enchantment.level." + integer)).withStyle(textformatting));
    }

    public static Component auroraPowerName(AuroraPower auroraPower) {
        ChatFormatting[] textformatting = new ChatFormatting[]{ChatFormatting.GREEN};
        return Component.translatable((String)("aurora_power." + AuroraPowers.getRegistry().getKey((Object)auroraPower).getNamespace() + "." + AuroraPowers.getRegistry().getKey((Object)auroraPower).getPath())).withStyle(textformatting);
    }

    @FunctionalInterface
    static interface AuroraPowerVisitor {
        public void accept(AuroraPower var1, int var2);
    }
}

