/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.weather;

import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;

public class FrostWeather {
    private final Properties properties;
    private final boolean useFog;

    public FrostWeather(Properties properties) {
        this.properties = properties;
        this.useFog = true;
    }

    public FrostWeather() {
        this.properties = new Properties(new FogProperties(1.0f, 1.0f, 1.0f, 0.9f), Optional.empty(), Optional.empty(), false);
        this.useFog = false;
    }

    public void tick(LivingEntity livingEntity) {
    }

    public boolean getBadWeather() {
        return this.properties.badWeather;
    }

    public float getRed() {
        return this.properties.fogProperties.red;
    }

    public float getGreen() {
        return this.properties.fogProperties.green;
    }

    public float getBlue() {
        return this.properties.fogProperties.blue;
    }

    public float getDensity() {
        return this.properties.fogProperties.density;
    }

    public Optional<SoundEvent> getSoundEvents() {
        return this.properties.sounds;
    }

    public Optional<TagKey<Biome>> getNonAffectableBiome() {
        return this.properties.biomeTagKey;
    }

    public boolean isUseFog() {
        return this.useFog;
    }

    public static class Properties {
        private final FogProperties fogProperties;
        private final Optional<SoundEvent> sounds;
        private final Optional<TagKey<Biome>> biomeTagKey;
        private final boolean badWeather;

        public Properties(FogProperties fogProperties, Optional<SoundEvent> sounds, Optional<TagKey<Biome>> biomeTagKey, boolean badWeather) {
            this.fogProperties = fogProperties;
            this.sounds = sounds;
            this.biomeTagKey = biomeTagKey;
            this.badWeather = badWeather;
        }
    }

    public static class FogProperties {
        private final float red;
        private final float green;
        private final float blue;
        private final float density;

        public FogProperties(float red, float green, float blue, float density) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.density = density;
        }
    }
}

