/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world.gen;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.block.crop.BearBerryBushBlock;
import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.registry.FrostFeatures;
import baguchan.frostrealm.world.gen.FrostTreeFeatures;
import baguchan.frostrealm.world.gen.feature.config.FloatingRockConfiguration;
import baguchan.frostrealm.world.gen.feature.config.HeightBlockStateConfiguration;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DeltaFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.material.Fluids;

public class FrostConfiguredFeatures {
    public static final RuleTest FRIGID_ORE_REPLACEABLES = new BlockMatchTest((Block)FrostBlocks.FRIGID_STONE.get());
    public static final RuleTest SLATE_REPLACEABLES = new BlockMatchTest((Block)FrostBlocks.PERMA_SLATE.get());
    public static final ImmutableList<OreConfiguration.TargetBlockState> ORE_FROST_CRYSTAL_TARGET_LIST = ImmutableList.of((Object)OreConfiguration.target((RuleTest)FRIGID_ORE_REPLACEABLES, (BlockState)((Block)FrostBlocks.FROST_CRYSTAL_ORE.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)SLATE_REPLACEABLES, (BlockState)((Block)FrostBlocks.FROST_CRYSTAL_SLATE_ORE.get()).defaultBlockState()));
    public static final ImmutableList<OreConfiguration.TargetBlockState> ORE_GLIMMERROCK_TARGET_LIST = ImmutableList.of((Object)OreConfiguration.target((RuleTest)FRIGID_ORE_REPLACEABLES, (BlockState)((Block)FrostBlocks.GLIMMERROCK_ORE.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)SLATE_REPLACEABLES, (BlockState)((Block)FrostBlocks.GLIMMERROCK_SLATE_ORE.get()).defaultBlockState()));
    public static final ImmutableList<OreConfiguration.TargetBlockState> ORE_ASTRIUM_TARGET_LIST = ImmutableList.of((Object)OreConfiguration.target((RuleTest)FRIGID_ORE_REPLACEABLES, (BlockState)((Block)FrostBlocks.ASTRIUM_ORE.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)SLATE_REPLACEABLES, (BlockState)((Block)FrostBlocks.ASTRIUM_SLATE_ORE.get()).defaultBlockState()));
    public static final ImmutableList<OreConfiguration.TargetBlockState> ORE_STARDUST_CRYSRTAL_TARGET_LIST = ImmutableList.of((Object)OreConfiguration.target((RuleTest)FRIGID_ORE_REPLACEABLES, (BlockState)((Block)FrostBlocks.STARDUST_CRYSTAL_ORE.get()).defaultBlockState()));
    public static final ImmutableList<OreConfiguration.TargetBlockState> ORE_GLACINIUM_TARGET_LIST = ImmutableList.of((Object)OreConfiguration.target((RuleTest)SLATE_REPLACEABLES, (BlockState)((Block)FrostBlocks.GLACINIUM_ORE.get()).defaultBlockState()));
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_FROST_CRYSTAL = FrostConfiguredFeatures.registerKey("ore_frost_crystal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_FROST_CRYSTAL_BURIED = FrostConfiguredFeatures.registerKey("ore_frost_crystal_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_GLIMMERROCK = FrostConfiguredFeatures.registerKey("ore_glimmerrock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_GLIMMERROCK_SMALL = FrostConfiguredFeatures.registerKey("ore_glimmerrock_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_ASTRIUM = FrostConfiguredFeatures.registerKey("ore_astrium");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_ASTRIUM_SMALL = FrostConfiguredFeatures.registerKey("ore_astrium_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_STARDUST_CRYSTAL = FrostConfiguredFeatures.registerKey("ore_stardust_crystal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_GLACINIUM = FrostConfiguredFeatures.registerKey("ore_glacinium");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_GLACINIUM_SMALL = FrostConfiguredFeatures.registerKey("ore_glacinium_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> UNDERGROUND_DELTA = FrostConfiguredFeatures.registerKey("underground_delta");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_TUNDRA_GRASS = FrostConfiguredFeatures.registerKey("patch_tundra_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_BEARBERRY = FrostConfiguredFeatures.registerKey("patch_bearberry");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_VIGOROSHROOM = FrostConfiguredFeatures.registerKey("patch_vigoroshroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ARCTIC_POPPY = FrostConfiguredFeatures.registerKey("patch_arctic_poppy");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ARCTIC_WILLOW = FrostConfiguredFeatures.registerKey("patch_arctic_willow");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TUNDRA_ROCK = FrostConfiguredFeatures.registerKey("tundra_rock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TUNDRA_MOSSY_ROCK = FrostConfiguredFeatures.registerKey("tundra_mossy_rock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STAR_DUST_CLUSTER = FrostConfiguredFeatures.registerKey("star_dust_cluster");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BIG_ROCK_WOOD = FrostConfiguredFeatures.registerKey("big_rock_wood");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMALL_VOLCANO = FrostConfiguredFeatures.registerKey("small_volcano");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STONE_SPIKE = FrostConfiguredFeatures.registerKey("stone_spike");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOATING_ROCK = FrostConfiguredFeatures.registerKey("floating_rock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPRING_LAVA = FrostConfiguredFeatures.registerKey("spring_lava_hot_rock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPRING_WATER = FrostConfiguredFeatures.registerKey("spring_water_fall");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HOT_SPRING_DELTA = FrostConfiguredFeatures.registerKey("hot_spring_delta");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ICE_CLUSTER = FrostConfiguredFeatures.registerKey("ice_cluster");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_ICE = FrostConfiguredFeatures.registerKey("large_ice");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FROST_FIRE_DESERT = FrostConfiguredFeatures.registerKey("frost_fire_desert");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FROSTROOT_TREE = FrostConfiguredFeatures.registerKey("frostroot_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FROSTBITE_TREE = FrostConfiguredFeatures.registerKey("frostbite_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LOG = FrostConfiguredFeatures.registerKey("log");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHAIN = FrostConfiguredFeatures.registerKey("chain");

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)FrostRealm.prefix(name));
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter holdergetter = context.lookup(Registries.CONFIGURED_FEATURE);
        FeatureUtils.register(context, ORE_FROST_CRYSTAL, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_FROST_CRYSTAL_TARGET_LIST, 20));
        FeatureUtils.register(context, ORE_FROST_CRYSTAL_BURIED, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_FROST_CRYSTAL_TARGET_LIST, 20, 0.5f));
        FeatureUtils.register(context, ORE_GLIMMERROCK, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_GLIMMERROCK_TARGET_LIST, 10));
        FeatureUtils.register(context, ORE_GLIMMERROCK_SMALL, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_GLIMMERROCK_TARGET_LIST, 4));
        FeatureUtils.register(context, ORE_ASTRIUM, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_ASTRIUM_TARGET_LIST, 12));
        FeatureUtils.register(context, ORE_ASTRIUM_SMALL, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_ASTRIUM_TARGET_LIST, 4));
        FeatureUtils.register(context, ORE_STARDUST_CRYSTAL, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_STARDUST_CRYSRTAL_TARGET_LIST, 8));
        FeatureUtils.register(context, ORE_GLACINIUM, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_GLACINIUM_TARGET_LIST, 8, 0.5f));
        FeatureUtils.register(context, ORE_GLACINIUM_SMALL, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_GLACINIUM_TARGET_LIST, 4));
        FeatureUtils.register(context, UNDERGROUND_DELTA, (Feature)Feature.DELTA_FEATURE, (FeatureConfiguration)new DeltaFeatureConfiguration(Blocks.LAVA.defaultBlockState(), ((Block)FrostBlocks.PERMA_MAGMA.get()).defaultBlockState(), (IntProvider)UniformInt.of((int)3, (int)7), (IntProvider)UniformInt.of((int)0, (int)2)));
        FeatureUtils.register(context, PATCH_TUNDRA_GRASS, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FrostConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.COLD_GRASS.get())), 32));
        FeatureUtils.register(context, PATCH_BEARBERRY, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FrostConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)FrostBlocks.BEARBERRY_BUSH.get()).defaultBlockState().setValue((Property)BearBerryBushBlock.AGE, (Comparable)Integer.valueOf(3)))), 32));
        FeatureUtils.register(context, PATCH_VIGOROSHROOM, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FrostConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.VIGOROSHROOM.get())), 32));
        FeatureUtils.register(context, ARCTIC_POPPY, (Feature)Feature.FLOWER, (FeatureConfiguration)FrostConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.ARCTIC_POPPY.get())), 32));
        FeatureUtils.register(context, ARCTIC_WILLOW, (Feature)Feature.FLOWER, (FeatureConfiguration)FrostConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.ARCTIC_WILLOW.get())), 32));
        FeatureUtils.register(context, TUNDRA_ROCK, FrostFeatures.BIG_ROCK.get(), (FeatureConfiguration)new BlockStateConfiguration(((Block)FrostBlocks.FRIGID_STONE.get()).defaultBlockState()));
        FeatureUtils.register(context, TUNDRA_MOSSY_ROCK, FrostFeatures.BIG_ROCK.get(), (FeatureConfiguration)new BlockStateConfiguration(((Block)FrostBlocks.FRIGID_STONE_MOSSY.get()).defaultBlockState()));
        FeatureUtils.register(context, STAR_DUST_CLUSTER, FrostFeatures.SHAPE_CRYSTAL.get(), (FeatureConfiguration)new HeightBlockStateConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)FrostBlocks.STARDUST_CRYSTAL_CLUSTER.get()).defaultBlockState()), UniformInt.of((int)10, (int)18)));
        FeatureUtils.register(context, BIG_ROCK_WOOD, FrostFeatures.SHAPE_CRYSTAL.get(), (FeatureConfiguration)new HeightBlockStateConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((RotatedPillarBlock)FrostBlocks.ROCK_WOOD.get()).defaultBlockState()), UniformInt.of((int)10, (int)15)));
        FeatureUtils.register(context, SMALL_VOLCANO, FrostFeatures.SMALL_VOLCANO.get(), (FeatureConfiguration)new HeightBlockStateConfiguration((BlockStateProvider)new WeightedStateProvider(WeightedList.builder().add((Object)((Block)FrostBlocks.FRIGID_STONE.get()).defaultBlockState(), 20).add((Object)((Block)FrostBlocks.GLIMMERROCK_ORE.get()).defaultBlockState(), 2).add((Object)((Block)FrostBlocks.ASTRIUM_ORE.get()).defaultBlockState(), 1).build()), UniformInt.of((int)12, (int)18)));
        FeatureUtils.register(context, STONE_SPIKE, FrostFeatures.STONE_SPIKE.get());
        FeatureUtils.register(context, FLOATING_ROCK, FrostFeatures.FLOATING_ROCK.get(), (FeatureConfiguration)new FloatingRockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FRIGID_STONE.get())), UniformFloat.of((float)5.0f, (float)8.0f), UniformInt.of((int)5, (int)10)));
        FeatureUtils.register(context, SPRING_LAVA, (Feature)Feature.SPRING, (FeatureConfiguration)new SpringConfiguration(Fluids.LAVA.defaultFluidState(), true, 4, 1, (HolderSet)HolderSet.direct(Block::builtInRegistryHolder, (Object[])new Block[]{(Block)FrostBlocks.FRIGID_STONE.get()})));
        FeatureUtils.register(context, SPRING_WATER, (Feature)Feature.SPRING, (FeatureConfiguration)new SpringConfiguration(Fluids.WATER.defaultFluidState(), true, 4, 1, (HolderSet)HolderSet.direct(Block::builtInRegistryHolder, (Object[])new Block[]{(Block)FrostBlocks.FRIGID_STONE.get()})));
        FeatureUtils.register(context, HOT_SPRING_DELTA, (Feature)Feature.DELTA_FEATURE, (FeatureConfiguration)new DeltaFeatureConfiguration(((LiquidBlock)FrostBlocks.HOT_SPRING.get()).defaultBlockState(), ((Block)FrostBlocks.FRIGID_STONE.get()).defaultBlockState(), (IntProvider)UniformInt.of((int)5, (int)9), (IntProvider)UniformInt.of((int)0, (int)2)));
        FeatureUtils.register(context, ICE_CLUSTER, FrostFeatures.ICE_CLUSTER.get(), (FeatureConfiguration)new DripstoneClusterConfiguration(12, (IntProvider)UniformInt.of((int)3, (int)6), (IntProvider)UniformInt.of((int)2, (int)8), 1, 3, (IntProvider)UniformInt.of((int)2, (int)4), (FloatProvider)UniformFloat.of((float)0.3f, (float)0.7f), (FloatProvider)ClampedNormalFloat.of((float)0.1f, (float)0.3f, (float)0.1f, (float)0.9f), 0.1f, 3, 8));
        FeatureUtils.register(context, LARGE_ICE, FrostFeatures.LARGE_ICE.get(), (FeatureConfiguration)new LargeDripstoneConfiguration(30, (IntProvider)UniformInt.of((int)3, (int)19), (FloatProvider)UniformFloat.of((float)0.4f, (float)2.0f), 0.33f, (FloatProvider)UniformFloat.of((float)0.3f, (float)0.9f), (FloatProvider)UniformFloat.of((float)0.4f, (float)1.0f), (FloatProvider)UniformFloat.of((float)0.0f, (float)0.3f), 4, 0.6f));
        FeatureUtils.register(context, FROST_FIRE_DESERT, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROST_FIRE.get()))), List.of((Block)FrostBlocks.SHERBET_SAND.get())));
        Holder.Reference holder1 = holdergetter.getOrThrow(FrostTreeFeatures.FROST_TREE);
        Holder.Reference holder2 = holdergetter.getOrThrow(FrostTreeFeatures.FROST_TREE_BIG);
        Holder.Reference holder3 = holdergetter.getOrThrow(FrostTreeFeatures.FROSTBITE_TREE);
        Holder.Reference holder4 = holdergetter.getOrThrow(FrostTreeFeatures.FROSTBITE_TREE_BIG);
        FeatureUtils.register(context, FROSTROOT_TREE, (Feature)Feature.RANDOM_SELECTOR, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)holder2, (PlacementModifier[])new PlacementModifier[0]), 0.33333334f)), PlacementUtils.inlinePlaced((Holder)holder1, (PlacementModifier[])new PlacementModifier[0])));
        FeatureUtils.register(context, FROSTBITE_TREE, (Feature)Feature.RANDOM_SELECTOR, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)holder4, (PlacementModifier[])new PlacementModifier[0]), 0.33333334f)), PlacementUtils.inlinePlaced((Holder)holder3, (PlacementModifier[])new PlacementModifier[0])));
        FeatureUtils.register(context, LOG, (Feature)Feature.BLOCK_COLUMN, (FeatureConfiguration)new BlockColumnConfiguration(List.of(BlockColumnConfiguration.layer((IntProvider)ConstantInt.of((int)32), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROSTROOT_LOG.get())))), Direction.DOWN, BlockPredicate.not((BlockPredicate)BlockPredicate.hasSturdyFace((Vec3i)new Vec3i(0, 1, 0), (Direction)Direction.UP)), true));
        FeatureUtils.register(context, CHAIN, (Feature)Feature.BLOCK_COLUMN, (FeatureConfiguration)new BlockColumnConfiguration(List.of(BlockColumnConfiguration.layer((IntProvider)ConstantInt.of((int)32), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.IRON_CHAIN))), Direction.UP, BlockPredicate.not((BlockPredicate)BlockPredicate.hasSturdyFace((Vec3i)new Vec3i(0, -1, 0), (Direction)Direction.DOWN)), true));
    }

    public static String prefix(String name) {
        return "frostrealm:" + name;
    }

    private static RandomPatchConfiguration grassPatch(BlockStateProvider p_195203_, int p_195204_) {
        return FeatureUtils.simpleRandomPatchConfiguration((int)p_195204_, (Holder)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(p_195203_)));
    }
}

