/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world.gen;

import baguchan.frostrealm.data.resource.FrostDensityFunctions;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.SurfaceRuleData;
import net.minecraft.data.worldgen.TerrainProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.BoundedFloatFunction;
import net.minecraft.util.CubicSpline;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class FrostNoiseRouterData {
    private static final DensityFunction BLENDING_FACTOR = DensityFunctions.constant((double)10.0);
    private static final DensityFunction BLENDING_JAGGEDNESS = DensityFunctions.zero();
    private static final ResourceKey<DensityFunction> ZERO = FrostNoiseRouterData.createKey("zero");
    private static final ResourceKey<DensityFunction> Y = FrostNoiseRouterData.createKey("y");
    private static final ResourceKey<DensityFunction> SHIFT_X = FrostNoiseRouterData.createKey("shift_x");
    private static final ResourceKey<DensityFunction> SHIFT_Z = FrostNoiseRouterData.createKey("shift_z");
    public static final ResourceKey<DensityFunction> CONTINENTS = FrostNoiseRouterData.createModKey("frostrealm/continents");
    public static final ResourceKey<DensityFunction> EROSION = FrostNoiseRouterData.createModKey("frostrealm/erosion");
    public static final ResourceKey<DensityFunction> RIDGES = FrostNoiseRouterData.createKey("overworld/ridges");
    public static final ResourceKey<DensityFunction> FACTOR = FrostNoiseRouterData.createModKey("frostrealm/factor");
    public static final ResourceKey<DensityFunction> DEPTH = FrostNoiseRouterData.createModKey("frostrealm/depth");
    private static final ResourceKey<DensityFunction> BASE_3D_NOISE_END = FrostNoiseRouterData.createKey("end/base_3d_noise");
    public static final ResourceKey<DensityFunction> RIDGES_FOLDED = FrostNoiseRouterData.createKey("overworld/ridges_folded");
    public static final ResourceKey<DensityFunction> OFFSET = FrostNoiseRouterData.createModKey("frostrealm/offset");
    public static final ResourceKey<DensityFunction> JAGGEDNESS = FrostNoiseRouterData.createModKey("frostrealm/jaggedness");
    public static final ResourceKey<DensityFunction> SLOPED_CHEESE = FrostNoiseRouterData.createKey("frostrealm/sloped_cheese");
    private static final ResourceKey<DensityFunction> SPAGHETTI_ROUGHNESS_FUNCTION = FrostNoiseRouterData.createKey("overworld/caves/spaghetti_roughness_function");
    private static final ResourceKey<DensityFunction> ENTRANCES = FrostNoiseRouterData.createKey("overworld/caves/entrances");
    private static final ResourceKey<DensityFunction> NOODLE = FrostNoiseRouterData.createKey("overworld/caves/noodle");
    public static final ResourceKey<DensityFunction> PILLARS = FrostNoiseRouterData.createModKey("frostrealm/caves/pillars");
    private static final ResourceKey<DensityFunction> SPAGHETTI_2D = FrostNoiseRouterData.createKey("overworld/caves/spaghetti_2d");
    private static final ResourceKey<DensityFunction> BASE_3D_NOISE_DEEP_CLIFF = FrostNoiseRouterData.createModKey("frostrealm/base_3d_noise");
    private final Climate.Parameter deepOceanContinentalness = Climate.Parameter.span((float)-1.05f, (float)-0.455f);

    private static ResourceKey<DensityFunction> createKey(String p_209537_) {
        return ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)p_209537_));
    }

    public static void bootstrapDensity(BootstrapContext<DensityFunction> p_256220_) {
        HolderGetter $$1 = p_256220_.lookup(Registries.NOISE);
        HolderGetter $$2 = p_256220_.lookup(Registries.DENSITY_FUNCTION);
        int $$3 = DimensionType.MIN_Y * 2;
        int $$4 = DimensionType.MAX_Y * 2;
        DensityFunction $$5 = FrostNoiseRouterData.getFunction((HolderGetter<DensityFunction>)$$2, SHIFT_X);
        DensityFunction $$6 = FrostNoiseRouterData.getFunction((HolderGetter<DensityFunction>)$$2, SHIFT_Z);
        p_256220_.register(BASE_3D_NOISE_DEEP_CLIFF, (Object)BlendedNoise.createUnseeded((double)0.25, (double)0.15, (double)80.0, (double)160.0, (double)8.0));
        Holder.Reference $$7 = p_256220_.register(CONTINENTS, (Object)DensityFunctions.flatCache((DensityFunction)DensityFunctions.shiftedNoise2d((DensityFunction)$$5, (DensityFunction)$$6, (double)0.35, (Holder)$$1.getOrThrow(Noises.CONTINENTALNESS))));
        Holder.Reference $$8 = p_256220_.register(EROSION, (Object)DensityFunctions.flatCache((DensityFunction)DensityFunctions.shiftedNoise2d((DensityFunction)$$5, (DensityFunction)$$6, (double)0.35, (Holder)$$1.getOrThrow(Noises.EROSION))));
        DensityFunction $$9 = FrostNoiseRouterData.getFunction((HolderGetter<DensityFunction>)$$2, RIDGES);
        DensityFunction $$10 = DensityFunctions.noise((Holder)$$1.getOrThrow(Noises.JAGGED), (double)1500.0, (double)0.0);
        FrostNoiseRouterData.registerTerrainNoises(p_256220_, (HolderGetter<DensityFunction>)$$2, $$10, (Holder<DensityFunction>)$$7, (Holder<DensityFunction>)$$8, OFFSET, FACTOR, JAGGEDNESS, DEPTH, SLOPED_CHEESE, false);
    }

    private static void registerTerrainNoises(BootstrapContext<DensityFunction> p_256336_, HolderGetter<DensityFunction> p_256393_, DensityFunction p_224476_, Holder<DensityFunction> p_224477_, Holder<DensityFunction> p_224478_, ResourceKey<DensityFunction> p_224479_, ResourceKey<DensityFunction> p_224480_, ResourceKey<DensityFunction> p_224481_, ResourceKey<DensityFunction> p_224482_, ResourceKey<DensityFunction> p_224483_, boolean p_224484_) {
        DensityFunctions.Spline.Coordinate $$11 = new DensityFunctions.Spline.Coordinate(p_224477_);
        DensityFunctions.Spline.Coordinate $$12 = new DensityFunctions.Spline.Coordinate(p_224478_);
        DensityFunctions.Spline.Coordinate $$13 = new DensityFunctions.Spline.Coordinate((Holder)p_256393_.getOrThrow(RIDGES));
        DensityFunctions.Spline.Coordinate $$14 = new DensityFunctions.Spline.Coordinate((Holder)p_256393_.getOrThrow(RIDGES_FOLDED));
        DensityFunction $$15 = FrostNoiseRouterData.registerAndWrap(p_256336_, p_224479_, FrostNoiseRouterData.splineWithBlending(DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-0.50375f), (DensityFunction)DensityFunctions.spline((CubicSpline)TerrainProvider.overworldOffset((BoundedFloatFunction)$$11, (BoundedFloatFunction)$$12, (BoundedFloatFunction)$$14, (boolean)p_224484_))), DensityFunctions.blendOffset()));
        DensityFunction $$16 = FrostNoiseRouterData.registerAndWrap(p_256336_, p_224480_, FrostNoiseRouterData.splineWithBlending(DensityFunctions.spline((CubicSpline)TerrainProvider.overworldFactor((BoundedFloatFunction)$$11, (BoundedFloatFunction)$$12, (BoundedFloatFunction)$$13, (BoundedFloatFunction)$$14, (boolean)p_224484_)), BLENDING_FACTOR));
        DensityFunction $$17 = FrostNoiseRouterData.registerAndWrap(p_256336_, p_224482_, DensityFunctions.add((DensityFunction)DensityFunctions.yClampedGradient((int)-64, (int)320, (double)1.5, (double)-1.5), (DensityFunction)$$15));
        DensityFunction $$18 = FrostNoiseRouterData.registerAndWrap(p_256336_, p_224481_, FrostNoiseRouterData.splineWithBlending(DensityFunctions.spline((CubicSpline)TerrainProvider.overworldJaggedness((BoundedFloatFunction)$$11, (BoundedFloatFunction)$$12, (BoundedFloatFunction)$$13, (BoundedFloatFunction)$$14, (boolean)p_224484_)), BLENDING_JAGGEDNESS));
        DensityFunction $$19 = DensityFunctions.mul((DensityFunction)$$18, (DensityFunction)p_224476_.halfNegative());
        DensityFunction $$20 = FrostNoiseRouterData.noiseGradientDensity($$16, DensityFunctions.add((DensityFunction)$$17, (DensityFunction)$$19));
        p_256336_.register(p_224483_, (Object)DensityFunctions.add((DensityFunction)$$20, (DensityFunction)FrostNoiseRouterData.getFunction(p_256393_, BASE_3D_NOISE_DEEP_CLIFF)));
    }

    private static DensityFunction splineWithBlending(DensityFunction p_224454_, DensityFunction p_224455_) {
        DensityFunction densityfunction = DensityFunctions.lerp((DensityFunction)DensityFunctions.blendAlpha(), (DensityFunction)p_224455_, (DensityFunction)p_224454_);
        return DensityFunctions.flatCache((DensityFunction)DensityFunctions.cache2d((DensityFunction)densityfunction));
    }

    private static DensityFunction registerAndWrap(BootstrapContext<DensityFunction> p_256149_, ResourceKey<DensityFunction> p_255905_, DensityFunction p_255856_) {
        return new DensityFunctions.HolderHolder((Holder)p_256149_.register(p_255905_, (Object)p_255856_));
    }

    public static NoiseGeneratorSettings frostrealm(BootstrapContext<NoiseGeneratorSettings> p_256478_) {
        return new NoiseGeneratorSettings(new NoiseSettings(-64, 384, 1, 2), Blocks.STONE.defaultBlockState(), Blocks.WATER.defaultBlockState(), FrostNoiseRouterData.frostrealm((HolderGetter<DensityFunction>)p_256478_.lookup(Registries.DENSITY_FUNCTION), (HolderGetter<NormalNoise.NoiseParameters>)p_256478_.lookup(Registries.NOISE)), SurfaceRuleData.overworld(), List.of(), 63, false, true, false, false);
    }

    private static ResourceKey<DensityFunction> createModKey(String p_209537_) {
        return ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)p_209537_));
    }

    public static DensityFunction underground(HolderGetter<DensityFunction> p_256548_, HolderGetter<NormalNoise.NoiseParameters> p_256236_, DensityFunction p_256658_) {
        DensityFunction densityfunction = FrostNoiseRouterData.getFunction(p_256548_, SPAGHETTI_2D);
        DensityFunction densityfunction1 = FrostNoiseRouterData.getFunction(p_256548_, SPAGHETTI_ROUGHNESS_FUNCTION);
        DensityFunction densityfunction2 = DensityFunctions.noise((Holder)p_256236_.getOrThrow(Noises.CAVE_LAYER), (double)8.0);
        DensityFunction densityfunction3 = DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)4.0), (DensityFunction)densityfunction2.square());
        DensityFunction densityfunction4 = DensityFunctions.noise((Holder)p_256236_.getOrThrow(Noises.CAVE_CHEESE), (double)0.6666666666666666);
        DensityFunction densityfunction5 = DensityFunctions.add((DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)0.27), (DensityFunction)densityfunction4).clamp(-1.0, 1.0), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)1.5), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)-0.64), (DensityFunction)p_256658_)).clamp(-0.5, 0.5));
        DensityFunction densityfunction6 = DensityFunctions.add((DensityFunction)densityfunction3, (DensityFunction)densityfunction5);
        DensityFunction densityfunction7 = DensityFunctions.min((DensityFunction)DensityFunctions.min((DensityFunction)densityfunction6, (DensityFunction)FrostNoiseRouterData.getFunction(p_256548_, ENTRANCES)), (DensityFunction)DensityFunctions.add((DensityFunction)densityfunction, (DensityFunction)densityfunction1));
        DensityFunction densityfunction8 = FrostNoiseRouterData.getFunction(p_256548_, PILLARS);
        DensityFunction densityfunction9 = DensityFunctions.rangeChoice((DensityFunction)densityfunction8, (double)-1000000.0, (double)0.03, (DensityFunction)DensityFunctions.constant((double)-1000000.0), (DensityFunction)densityfunction8);
        return DensityFunctions.max((DensityFunction)densityfunction7, (DensityFunction)densityfunction9);
    }

    private static DensityFunction postProcess(DensityFunction p_224493_) {
        DensityFunction densityfunction = DensityFunctions.blendDensity((DensityFunction)p_224493_);
        return DensityFunctions.mul((DensityFunction)DensityFunctions.interpolated((DensityFunction)densityfunction), (DensityFunction)DensityFunctions.constant((double)0.64)).squeeze();
    }

    public static NoiseRouter frostrealm(HolderGetter<DensityFunction> p_255681_, HolderGetter<NormalNoise.NoiseParameters> p_256005_) {
        DensityFunction densityfunction = DensityFunctions.noise((Holder)p_256005_.getOrThrow(Noises.AQUIFER_BARRIER), (double)0.5);
        DensityFunction densityfunction1 = DensityFunctions.constant((double)-1.0);
        DensityFunction densityfunction2 = DensityFunctions.noise((Holder)p_256005_.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_SPREAD), (double)0.7142857142857143);
        DensityFunction densityfunction3 = DensityFunctions.noise((Holder)p_256005_.getOrThrow(Noises.AQUIFER_LAVA));
        DensityFunction densityfunction4 = FrostNoiseRouterData.getFunction(p_255681_, SHIFT_X);
        DensityFunction densityfunction5 = FrostNoiseRouterData.getFunction(p_255681_, SHIFT_Z);
        DensityFunction densityfunction6 = DensityFunctions.shiftedNoise2d((DensityFunction)densityfunction4, (DensityFunction)densityfunction5, (double)0.25, (Holder)p_256005_.getOrThrow(Noises.TEMPERATURE));
        DensityFunction densityfunction7 = DensityFunctions.shiftedNoise2d((DensityFunction)densityfunction4, (DensityFunction)densityfunction5, (double)0.25, (Holder)p_256005_.getOrThrow(Noises.VEGETATION));
        DensityFunction densityfunction8 = FrostNoiseRouterData.getFunction(p_255681_, FACTOR);
        DensityFunction densityfunction9 = FrostNoiseRouterData.getFunction(p_255681_, DEPTH);
        DensityFunction densityfunction10 = FrostNoiseRouterData.noiseGradientDensity(DensityFunctions.cache2d((DensityFunction)densityfunction8), densityfunction9);
        DensityFunction densityfunction11 = FrostNoiseRouterData.getFunction(p_255681_, SLOPED_CHEESE);
        DensityFunction densityfunction12 = DensityFunctions.min((DensityFunction)densityfunction11, (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)5.0), (DensityFunction)FrostNoiseRouterData.getFunction(p_255681_, ENTRANCES)));
        DensityFunction cave = FrostNoiseRouterData.getFunction(p_255681_, FrostDensityFunctions.UNDERGROUND);
        DensityFunction densityfunction13 = DensityFunctions.rangeChoice((DensityFunction)densityfunction11, (double)-1000000.0, (double)1.5625, (DensityFunction)densityfunction12, (DensityFunction)DensityFunctions.min((DensityFunction)FrostNoiseRouterData.slideCaveUpper(cave), (DensityFunction)FrostNoiseRouterData.slideCave(cave)));
        DensityFunction densityfunction14 = DensityFunctions.min((DensityFunction)FrostNoiseRouterData.postProcess(FrostNoiseRouterData.slideOverworld(densityfunction13)), (DensityFunction)FrostNoiseRouterData.getFunction(p_255681_, NOODLE));
        DensityFunction densityfunction15 = FrostNoiseRouterData.getFunction(p_255681_, Y);
        DensityFunction densityfunction16 = DensityFunctions.zero();
        float f = 4.0f;
        DensityFunction densityfunction19 = DensityFunctions.zero();
        DensityFunction densityfunction20 = DensityFunctions.zero();
        return new NoiseRouter(densityfunction, densityfunction1, densityfunction2, densityfunction3, densityfunction6, densityfunction7, FrostNoiseRouterData.getFunction(p_255681_, CONTINENTS), FrostNoiseRouterData.getFunction(p_255681_, EROSION), densityfunction9, FrostNoiseRouterData.getFunction(p_255681_, RIDGES), FrostNoiseRouterData.slideOverworld(DensityFunctions.add((DensityFunction)densityfunction10, (DensityFunction)DensityFunctions.constant((double)-0.703125)).clamp(-64.0, 64.0)), densityfunction14, densityfunction16, densityfunction19, densityfunction20);
    }

    private static DensityFunction slideOverworld(DensityFunction p_224491_) {
        return FrostNoiseRouterData.slide(p_224491_, -64, 384, 32, 16, -0.078125, 0, 32, 0.5);
    }

    private static DensityFunction slideCave(DensityFunction p_224491_) {
        return FrostNoiseRouterData.slide(p_224491_, -64, 94, 34, 0, 0.9375, -8, 24, 2.5);
    }

    private static DensityFunction slideCaveUpper(DensityFunction p_224491_) {
        return FrostNoiseRouterData.slide(p_224491_, 0, 54, 24, 0, 0.9375, -8, 24, 2.5);
    }

    private static DensityFunction noiseGradientDensity(DensityFunction p_212272_, DensityFunction p_212273_) {
        DensityFunction densityfunction = DensityFunctions.mul((DensityFunction)p_212273_, (DensityFunction)p_212272_);
        return DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)4.0), (DensityFunction)densityfunction.quarterNegative());
    }

    private static DensityFunction yLimitedInterpolatable(DensityFunction p_209472_, DensityFunction p_209473_, int p_209474_, int p_209475_, int p_209476_) {
        return DensityFunctions.interpolated((DensityFunction)DensityFunctions.rangeChoice((DensityFunction)p_209472_, (double)p_209474_, (double)(p_209475_ + 1), (DensityFunction)p_209473_, (DensityFunction)DensityFunctions.constant((double)p_209476_)));
    }

    private static DensityFunction slide(DensityFunction density, int minY, int maxY, int fromYTop, int toYTop, double offset1, int fromYBottom, int toYBottom, double offset2) {
        DensityFunction topSlide = DensityFunctions.yClampedGradient((int)(minY + maxY - fromYTop), (int)(minY + maxY - toYTop), (double)1.0, (double)0.0);
        density = DensityFunctions.lerp((DensityFunction)topSlide, (double)offset1, (DensityFunction)density);
        DensityFunction bottomSlide = DensityFunctions.yClampedGradient((int)(minY + fromYBottom), (int)(minY + toYBottom), (double)0.0, (double)1.0);
        return DensityFunctions.lerp((DensityFunction)bottomSlide, (double)offset2, (DensityFunction)density);
    }

    private static DensityFunction getFunction(HolderGetter<DensityFunction> p_224465_, ResourceKey<DensityFunction> p_224466_) {
        return new DensityFunctions.HolderHolder((Holder)p_224465_.getOrThrow(p_224466_));
    }
}

