/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world.gen.feature;

import baguchan.frostrealm.world.gen.feature.config.HeightBlockStateConfiguration;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class ShapeCrystalFeature
extends Feature<HeightBlockStateConfiguration> {
    public ShapeCrystalFeature(Codec<HeightBlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<HeightBlockStateConfiguration> blockstateconfiguration) {
        BlockPos blockpos = blockstateconfiguration.origin().below(3);
        WorldGenLevel worldgenlevel = blockstateconfiguration.level();
        RandomSource random = blockstateconfiguration.random();
        if (worldgenlevel.getBlockState(blockpos).is(BlockTags.FEATURES_CANNOT_REPLACE)) {
            return false;
        }
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(blockstateconfiguration.random());
        int height = ((HeightBlockStateConfiguration)blockstateconfiguration.config()).baseHeight().sample(random);
        int width = (int)((float)height / 4.0f);
        float shaper = (float)width / (4.0f + (float)random.nextInt(5));
        for (int y = 0; y < height; ++y) {
            BlockPos spikePos = blockpos.above(y).relative(direction, (int)((float)y * shaper));
            for (BlockPos blockpos1 : BlockPos.betweenClosed((BlockPos)spikePos.offset(-width, 0, -width), (BlockPos)spikePos.offset(width, 0, width))) {
                if (!(blockpos1.distSqr((Vec3i)spikePos) > (double)((height - width * width * 2) / (y + 2))) || !(blockpos1.distSqr((Vec3i)spikePos) < (double)((height + width * width * 2) / (y + 2))) || worldgenlevel.getBlockState(blockpos1).is(BlockTags.FEATURES_CANNOT_REPLACE)) continue;
                worldgenlevel.setBlock(blockpos1, ((HeightBlockStateConfiguration)blockstateconfiguration.config()).block().getState(random, blockpos1), 2);
            }
        }
        return true;
    }
}

