/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world.placement;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.world.gen.FrostConfiguredFeatures;
import baguchan.frostrealm.world.gen.FrostTreeFeatures;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.VeryBiasedToBottomHeight;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public class FrostPlacements {
    private static final PlacementModifier TREE_THRESHOLD = SurfaceWaterDepthFilter.forMaxDepth((int)0);
    public static final ResourceKey<PlacedFeature> FROSTROOT_TREES_FOREST = FrostPlacements.registerKey("frostroot_tree_forest");
    public static final ResourceKey<PlacedFeature> FROSTROOT_TREES_PLAINS = FrostPlacements.registerKey("frostroot_tree_plains");
    public static final ResourceKey<PlacedFeature> FROSTBITE_TREES = FrostPlacements.registerKey("frostbite_tree");
    public static final ResourceKey<PlacedFeature> DRIP_TREES = FrostPlacements.registerKey("drip_tree");
    public static final ResourceKey<PlacedFeature> DRIP_TREES_BIG = FrostPlacements.registerKey("drip_tree_big");
    public static final ResourceKey<PlacedFeature> PATCH_TUNDRA_GRASS = FrostPlacements.registerKey("patch_tundra_grass");
    public static final ResourceKey<PlacedFeature> PATCH_DRIP_GRASS = FrostPlacements.registerKey("patch_drip_grass");
    public static final ResourceKey<PlacedFeature> PATCH_TUNDRA_GRASS_SKY = FrostPlacements.registerKey("patch_tundra_grass_sky");
    public static final ResourceKey<PlacedFeature> PATCH_TUNDRA_GRASS_BONEMEAL = FrostPlacements.registerKey("patch_tundra_grass_bonemeal");
    public static final ResourceKey<PlacedFeature> PATCH_BEAR_BERRY = FrostPlacements.registerKey("patch_bear_berry");
    public static final ResourceKey<PlacedFeature> PATCH_ARTIC_POPPY = FrostPlacements.registerKey("patch_artic_poppy");
    public static final ResourceKey<PlacedFeature> PATCH_ARTIC_WILLOW = FrostPlacements.registerKey("patch_artic_willow");
    public static final ResourceKey<PlacedFeature> PATCH_ARTIC_POPPY_SKY = FrostPlacements.registerKey("patch_artic_poppy_sky");
    public static final ResourceKey<PlacedFeature> PATCH_VIGOROSHROOM = FrostPlacements.registerKey("patch_vigoroshroom");
    public static final ResourceKey<PlacedFeature> PATCH_TUNDRA_ROCK = FrostPlacements.registerKey("patch_tundra_rock");
    public static final ResourceKey<PlacedFeature> PATCH_TUNDRA_MOSSY_ROCK = FrostPlacements.registerKey("patch_tundra_mossy_rock");
    public static final ResourceKey<PlacedFeature> STONE_SPIKE = FrostPlacements.registerKey("stone_spike");
    public static final ResourceKey<PlacedFeature> FLOATING_ROCK = FrostPlacements.registerKey("floating_rock");
    public static final ResourceKey<PlacedFeature> BIG_ROCK_WOOD = FrostPlacements.registerKey("big_rock_wood");
    public static final ResourceKey<PlacedFeature> LAVA_DELTA = FrostPlacements.registerKey("delta");
    public static final ResourceKey<PlacedFeature> UNDERGRAUND_DELTA = FrostPlacements.registerKey("underground_delta");
    public static final ResourceKey<PlacedFeature> SPRING_LAVA = FrostPlacements.registerKey("spring_lava");
    public static final ResourceKey<PlacedFeature> SPRING_LAVA_HOTROCK_EXTRA = FrostPlacements.registerKey("spring_lava_hotrock_extra");
    public static final ResourceKey<PlacedFeature> SPRING_WATER = FrostPlacements.registerKey("spring_water");
    public static final ResourceKey<PlacedFeature> SPRING_WATER_EXTRA = FrostPlacements.registerKey("spring_water_extra");
    public static final ResourceKey<PlacedFeature> HOT_SPRING_DELTA = FrostPlacements.registerKey("hot_spring_delta");
    public static final ResourceKey<PlacedFeature> ICE_CLUSTER = FrostPlacements.registerKey("ice_cluster");
    public static final ResourceKey<PlacedFeature> LARGE_ICE = FrostPlacements.registerKey("large_ice");
    public static final ResourceKey<PlacedFeature> STARDUST_CRUSTER = FrostPlacements.registerKey("stardust_cluster");
    public static final ResourceKey<PlacedFeature> SMALL_VOLCANO = FrostPlacements.registerKey("small_volcano");
    public static final ResourceKey<PlacedFeature> FROST_FIRE_DESERT = FrostPlacements.registerKey("frost_fire_desert");
    public static final ResourceKey<PlacedFeature> LOG_PLACE = FrostPlacements.registerKey("log");
    public static final ResourceKey<PlacedFeature> CHAIN_PLACE = FrostPlacements.registerKey("chain");
    public static final PlacementModifier GLACIER_HEIGHT = HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)32), (VerticalAnchor)VerticalAnchor.absolute((int)86));

    public static String prefix(String name) {
        return "frostrealm:" + name;
    }

    public static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)FrostRealm.prefix(name));
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeature = context.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(context, FROSTROOT_TREES_FOREST, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.FROSTROOT_TREE), FrostPlacements.treePlacement(PlacementUtils.countExtra((int)10, (float)0.1f, (int)1), (Block)FrostBlocks.FROSTROOT_SAPLING.get()));
        PlacementUtils.register(context, FROSTROOT_TREES_PLAINS, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.FROSTROOT_TREE), FrostPlacements.treePlacement(PlacementUtils.countExtra((int)0, (float)0.01f, (int)1), (Block)FrostBlocks.FROSTROOT_SAPLING.get()));
        PlacementUtils.register(context, FROSTBITE_TREES, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.FROSTBITE_TREE), FrostPlacements.treePlacement(PlacementUtils.countExtra((int)8, (float)0.1f, (int)1), (Block)FrostBlocks.FROSTBITE_SAPLING.get()));
        PlacementUtils.register(context, DRIP_TREES, (Holder)configuredFeature.getOrThrow(FrostTreeFeatures.DRIP_WOOD_TREE), FrostPlacements.treePlacement(PlacementUtils.countExtra((int)4, (float)0.1f, (int)1), (Block)FrostBlocks.DRIP_SAPLING.get()));
        PlacementUtils.register(context, DRIP_TREES_BIG, (Holder)configuredFeature.getOrThrow(FrostTreeFeatures.DRIP_WOOD_TREE_BIG), FrostPlacements.treePlacement(PlacementUtils.countExtra((int)10, (float)0.1f, (int)1), (Block)FrostBlocks.DRIP_SAPLING.get()));
        PlacementUtils.register(context, PATCH_TUNDRA_GRASS, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.PATCH_TUNDRA_GRASS), (PlacementModifier[])new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, PATCH_DRIP_GRASS, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.PATCH_TUNDRA_GRASS), (PlacementModifier[])new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)-0.8, (int)3, (int)5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, PATCH_TUNDRA_GRASS_SKY, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.PATCH_TUNDRA_GRASS), (PlacementModifier[])new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        PlacementUtils.register(context, PATCH_TUNDRA_GRASS_BONEMEAL, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.PATCH_TUNDRA_GRASS), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.isEmpty()});
        PlacementUtils.register(context, PATCH_BEAR_BERRY, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.PATCH_BEARBERRY), (PlacementModifier[])new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, PATCH_ARTIC_POPPY, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.ARCTIC_POPPY), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, PATCH_ARTIC_WILLOW, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.ARCTIC_WILLOW), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, PATCH_ARTIC_POPPY_SKY, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.ARCTIC_POPPY), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        PlacementUtils.register(context, PATCH_VIGOROSHROOM, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.PATCH_VIGOROSHROOM), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)3), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, PATCH_TUNDRA_ROCK, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.TUNDRA_ROCK), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, PATCH_TUNDRA_MOSSY_ROCK, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.TUNDRA_MOSSY_ROCK), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, STONE_SPIKE, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.STONE_SPIKE), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        PlacementUtils.register(context, FLOATING_ROCK, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.FLOATING_ROCK), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.belowTop((int)128), (VerticalAnchor)VerticalAnchor.belowTop((int)64)), BiomeFilter.biome()});
        PlacementUtils.register(context, LAVA_DELTA, (Holder)configuredFeature.getOrThrow(NetherFeatures.DELTA), (PlacementModifier[])new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)8), BiomeFilter.biome()});
        PlacementUtils.register(context, UNDERGRAUND_DELTA, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.UNDERGROUND_DELTA), (PlacementModifier[])new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)8), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)new Vec3i(0, -1, 0), (Block[])new Block[]{(Block)FrostBlocks.PERMA_SLATE.get()})), BiomeFilter.biome()});
        PlacementUtils.register(context, HOT_SPRING_DELTA, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.HOT_SPRING_DELTA), (PlacementModifier[])new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)4), BiomeFilter.biome()});
        PlacementUtils.register(context, SPRING_LAVA, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.SPRING_LAVA), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)20), InSquarePlacement.spread(), HeightRangePlacement.of((HeightProvider)VeryBiasedToBottomHeight.of((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.belowTop((int)8), (int)8)), BiomeFilter.biome()});
        PlacementUtils.register(context, SPRING_LAVA_HOTROCK_EXTRA, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.SPRING_LAVA), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)10), InSquarePlacement.spread(), HeightRangePlacement.of((HeightProvider)VeryBiasedToBottomHeight.of((VerticalAnchor)VerticalAnchor.aboveBottom((int)64), (VerticalAnchor)VerticalAnchor.top(), (int)8)), BiomeFilter.biome()});
        PlacementUtils.register(context, SPRING_WATER, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.SPRING_WATER), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)25), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)192)), BiomeFilter.biome()});
        PlacementUtils.register(context, SPRING_WATER_EXTRA, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.SPRING_WATER), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)30), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)0)), BiomeFilter.biome()});
        PlacementUtils.register(context, ICE_CLUSTER, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.ICE_CLUSTER), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)48, (int)96)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, LARGE_ICE, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.LARGE_ICE), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)10, (int)48)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, STARDUST_CRUSTER, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.STAR_DUST_CLUSTER), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)5), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, SMALL_VOLCANO, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.SMALL_VOLCANO), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, BIG_ROCK_WOOD, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.BIG_ROCK_WOOD), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)10), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, LOG_PLACE, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.LOG), (PlacementModifier[])new PlacementModifier[]{EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.anyOf((BlockPredicate)BlockPredicate.hasSturdyFace((Vec3i)new Vec3i(0, 1, 0), (Direction)Direction.UP), (BlockPredicate)BlockPredicate.hasSturdyFace((Direction)Direction.UP)), (int)32)});
        PlacementUtils.register(context, CHAIN_PLACE, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.CHAIN), (PlacementModifier[])new PlacementModifier[]{EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.anyOf((BlockPredicate)BlockPredicate.hasSturdyFace((Vec3i)new Vec3i(0, -1, 0), (Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.hasSturdyFace((Direction)Direction.DOWN)), (int)32)});
        List<BiomeFilter> list = List.of(CountPlacement.of((IntProvider)UniformInt.of((int)0, (int)5)), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
        List<BiomeFilter> list2 = List.of(RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
        PlacementUtils.register(context, FROST_FIRE_DESERT, (Holder)configuredFeature.getOrThrow(FrostConfiguredFeatures.FROST_FIRE_DESERT), list2);
    }

    private static ImmutableList.Builder<PlacementModifier> treePlacementBase(PlacementModifier p_195485_) {
        return ImmutableList.builder().add((Object)p_195485_).add((Object)InSquarePlacement.spread()).add((Object)TREE_THRESHOLD).add((Object)PlacementUtils.HEIGHTMAP_OCEAN_FLOOR).add((Object)BiomeFilter.biome());
    }

    public static List<PlacementModifier> treePlacement(PlacementModifier p_195480_) {
        return FrostPlacements.treePlacementBase(p_195480_).build();
    }

    public static List<PlacementModifier> treePlacement(PlacementModifier p_195482_, Block p_195483_) {
        return FrostPlacements.treePlacementBase(p_195482_).add((Object)BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.wouldSurvive((BlockState)p_195483_.defaultBlockState(), (Vec3i)BlockPos.ZERO))).build();
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
        return List.of(p_195347_, InSquarePlacement.spread(), p_195348_, BiomeFilter.biome());
    }

    private static List<PlacementModifier> commonOrePlacement(int p_195344_, PlacementModifier p_195345_) {
        return FrostPlacements.orePlacement((PlacementModifier)CountPlacement.of((int)p_195344_), p_195345_);
    }

    private static List<PlacementModifier> rareOrePlacement(int p_195350_, PlacementModifier p_195351_) {
        return FrostPlacements.orePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)p_195350_), p_195351_);
    }
}

