/*
 * Decompiled with CFR 0.152.
 */
package io.github.nyankoro328.cobbledollars_ticket.block.entity;

import io.github.nyankoro328.cobbledollars_ticket.advancement.ModCriteria;
import io.github.nyankoro328.cobbledollars_ticket.block.SlotMachineBlock;
import io.github.nyankoro328.cobbledollars_ticket.block.entity.WinningResult;
import io.github.nyankoro328.cobbledollars_ticket.init.ModItems;
import io.github.nyankoro328.cobbledollars_ticket.init.ModSounds;
import io.github.nyankoro328.cobbledollars_ticket.screen.SlotMachineScreenHandler;
import io.github.nyankoro328.cobbledollars_ticket.screen.payload.BlockPosPayload;
import java.util.UUID;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public abstract class SlotMachineBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<BlockPosPayload> {
    private int currentLevel = 0;
    private boolean isSpinning = false;
    private int spinTicksRemaining = 0;
    protected WinningResult lastResult = WinningResult.MISS;
    private int[] lastReelIcons = new int[]{0, 0, 0};
    @Nullable
    private UUID spinningPlayerUuid;
    private static final int SPIN_DURATION_TICKS = 60;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> {
                    if (SlotMachineBlockEntity.this.isSpinning) {
                        yield 1;
                    }
                    yield 0;
                }
                case 1 -> SlotMachineBlockEntity.this.spinTicksRemaining;
                case 2 -> SlotMachineBlockEntity.this.lastReelIcons[0];
                case 3 -> SlotMachineBlockEntity.this.lastReelIcons[1];
                case 4 -> SlotMachineBlockEntity.this.lastReelIcons[2];
                case 5 -> SlotMachineBlockEntity.this.currentLevel;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
        }

        public int method_17389() {
            return 6;
        }
    };

    public SlotMachineBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public class_3913 getPropertyDelegate() {
        return this.propertyDelegate;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public boolean isSpinning() {
        return this.isSpinning;
    }

    public int getSpinTicksRemaining() {
        return this.spinTicksRemaining;
    }

    public int[] getLastReelIcons() {
        return this.lastReelIcons;
    }

    public boolean startSpin(class_3222 player) {
        if (this.isSpinning() || this.field_11863 == null) {
            return false;
        }
        this.field_11863.method_8396(null, this.field_11867, ModSounds.SLOT_BUTTON_CLICK, class_3419.field_15245, 0.5f, 1.0f);
        this.isSpinning = true;
        this.spinTicksRemaining = 60;
        this.spinningPlayerUuid = player.method_5667();
        this.lastResult = this.rollWinningResult();
        this.lastReelIcons = this.determineReelIconsFromResult(this.lastResult);
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        return true;
    }

    public void playFailSound() {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8396(null, this.field_11867, ModSounds.SLOT_MISS, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    private int[] determineReelIconsFromResult(WinningResult result) {
        int[] nArray;
        switch (result) {
            default: {
                throw new MatchException(null, null);
            }
            case JACKPOT: {
                int[] nArray2 = new int[3];
                nArray2[0] = 3;
                nArray2[1] = 3;
                nArray = nArray2;
                nArray2[2] = 3;
                break;
            }
            case BIG_WIN: {
                int[] nArray3 = new int[3];
                nArray3[0] = 2;
                nArray3[1] = 2;
                nArray = nArray3;
                nArray3[2] = 2;
                break;
            }
            case SMALL_WIN: {
                int[] nArray4 = new int[3];
                nArray4[0] = 1;
                nArray4[1] = 1;
                nArray = nArray4;
                nArray4[2] = 1;
                break;
            }
            case CHERRY_MATCH: {
                int[] nArray5 = new int[3];
                nArray5[0] = 0;
                nArray5[1] = 0;
                nArray = nArray5;
                nArray5[2] = 0;
                break;
            }
            case MISS: {
                nArray = this.generateMissCombination();
            }
        }
        return nArray;
    }

    private int[] generateMissCombination() {
        class_5819 random = this.field_11863.method_8409();
        int[] icons = new int[3];
        int numberOfIcons = 4;
        do {
            icons[0] = random.method_43048(numberOfIcons);
            icons[1] = random.method_43048(numberOfIcons);
            icons[2] = random.method_43048(numberOfIcons);
        } while (this.isWinningCombination(icons));
        return icons;
    }

    private boolean isWinningCombination(int[] icons) {
        return icons[0] == icons[1] && icons[1] == icons[2];
    }

    protected WinningResult rollWinningResult() {
        if (this.field_11863 == null) {
            return WinningResult.MISS;
        }
        class_5819 random = this.field_11863.method_8409();
        double roll = random.method_43058();
        double[][] dArrayArray = new double[][]{{5.0E-4, 0.005, 0.04, 0.1}, {0.0025, 0.01, 0.07, 0.12}, {0.0045, 0.02, 0.1, 0.15}, {0.0095, 0.04, 0.15, 0.2}};
        double[][] probabilities = dArrayArray;
        double[] levelProbs = probabilities[this.currentLevel];
        if (roll < levelProbs[0]) {
            return WinningResult.JACKPOT;
        }
        if ((roll -= levelProbs[0]) < levelProbs[1]) {
            return WinningResult.BIG_WIN;
        }
        if ((roll -= levelProbs[1]) < levelProbs[2]) {
            return WinningResult.SMALL_WIN;
        }
        if ((roll -= levelProbs[2]) < levelProbs[3]) {
            return WinningResult.CHERRY_MATCH;
        }
        return WinningResult.MISS;
    }

    protected void onSpinFinished() {
        if (this.field_11863 == null || this.field_11863.method_8608() || this.spinningPlayerUuid == null) {
            return;
        }
        class_1657 class_16572 = this.field_11863.method_18470(this.spinningPlayerUuid);
        if (!(class_16572 instanceof class_3222)) {
            this.spinningPlayerUuid = null;
            return;
        }
        class_3222 player = (class_3222)class_16572;
        if (this.lastResult != WinningResult.MISS) {
            ModCriteria.SLOT_WINNING_TRIGGER.trigger(player, this.lastResult);
        }
        this.handlePrizePayment((class_1657)player);
        this.playSoundOnFinish();
        this.handleLevelChange();
        this.spinningPlayerUuid = null;
    }

    protected void handlePrizePayment(class_1657 player) {
        int prizeAmount = this.lastResult.getPrize(this.isPremium());
        if (prizeAmount > 0) {
            int numberOfTickets = prizeAmount / 1000;
            if (numberOfTickets > 0) {
                while (numberOfTickets > 0) {
                    int stackSize = Math.min(numberOfTickets, 64);
                    class_1799 prizeStack = new class_1799((class_1935)ModItems.cobbledollars_ticket_1000, stackSize);
                    if (!player.method_31548().method_7394(prizeStack)) {
                        player.method_7328(prizeStack, false);
                    }
                    numberOfTickets -= stackSize;
                }
            }
            player.method_7353((class_2561)class_2561.method_43469((String)"chat.cobbledollars_ticket.win_message", (Object[])new Object[]{prizeAmount}), false);
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"chat.cobbledollars_ticket.miss_message"), false);
        }
    }

    protected void playSoundOnFinish() {
        class_3414 resultSound = switch (this.lastResult) {
            case WinningResult.JACKPOT -> ModSounds.SLOT_JACKPOT;
            case WinningResult.BIG_WIN -> ModSounds.SLOT_BIG_WIN;
            case WinningResult.MISS -> ModSounds.SLOT_MISS;
            default -> class_3417.field_14627;
        };
        this.field_11863.method_8396(null, this.field_11867, resultSound, class_3419.field_15245, 1.0f, 1.0f);
    }

    protected void handleLevelChange() {
        int oldLevel = this.currentLevel;
        class_5819 random = this.field_11863.method_8409();
        double roll = random.method_43058();
        if (roll < 0.05 && this.currentLevel < 3) {
            ++this.currentLevel;
        } else if (roll < 0.15 && this.currentLevel > 0) {
            --this.currentLevel;
        }
        if (this.currentLevel > oldLevel) {
            this.field_11863.method_8396(null, this.field_11867, ModSounds.SLOT_LEVEL_UP, class_3419.field_15245, 1.0f, 1.2f);
        } else if (this.currentLevel < oldLevel) {
            this.field_11863.method_8396(null, this.field_11867, ModSounds.SLOT_LEVEL_DOWN, class_3419.field_15245, 1.0f, 0.8f);
        }
        if (this.currentLevel != oldLevel) {
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)SlotMachineBlock.LEVEL, (Comparable)Integer.valueOf(this.currentLevel)), 2);
        }
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, SlotMachineBlockEntity be) {
        int[] stopTimings;
        if (world.method_8608() || !be.isSpinning()) {
            return;
        }
        int ticksBefore = be.spinTicksRemaining--;
        int ticksAfter = be.spinTicksRemaining;
        for (int stopTick : stopTimings = new int[]{40, 25, 10}) {
            if (ticksBefore <= stopTick || ticksAfter > stopTick) continue;
            world.method_8396(null, pos, ModSounds.SLOT_REEL_STOP, class_3419.field_15245, 0.7f, 1.0f);
        }
        if (ticksAfter <= 0) {
            be.isSpinning = false;
            be.onSpinFinished();
        }
    }

    public int getPlayCost() {
        return 1000;
    }

    public boolean isPremium() {
        return false;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("level", this.currentLevel);
        nbt.method_10556("spinning", this.isSpinning);
        nbt.method_10569("spin_ticks", this.spinTicksRemaining);
        nbt.method_10582("last_result", this.lastResult.name());
        nbt.method_10539("lastReelIcons", this.lastReelIcons);
        if (this.spinningPlayerUuid != null) {
            nbt.method_25927("spinningPlayer", this.spinningPlayerUuid);
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.currentLevel = nbt.method_10550("level");
        this.isSpinning = nbt.method_10577("spinning");
        this.spinTicksRemaining = nbt.method_10550("spin_ticks");
        if (nbt.method_10573("last_result", 8)) {
            this.lastResult = WinningResult.valueOf(nbt.method_10558("last_result"));
        }
        if (nbt.method_10573("lastReelIcons", 11)) {
            this.lastReelIcons = nbt.method_10561("lastReelIcons");
        }
        if (nbt.method_25928("spinningPlayer")) {
            this.spinningPlayerUuid = nbt.method_25926("spinningPlayer");
        }
    }

    public class_2561 method_5476() {
        return this.method_11010().method_26204().method_9518();
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new SlotMachineScreenHandler(syncId, playerInventory, this);
    }

    public BlockPosPayload getScreenOpeningData(class_3222 player) {
        return new BlockPosPayload(this.field_11867);
    }
}

