/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.mvc;

import com.danrus.mvc.DebugUtils;
import com.danrus.mvc.config.ModConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergingResourceManagerWrapper
implements class_3300 {
    private final class_3300 delegate;
    private static final String SELECT_TYPE = "minecraft:select";

    public MergingResourceManagerWrapper(class_3300 delegate) {
        this.delegate = delegate;
    }

    @NotNull
    public Set<String> method_14487() {
        return this.delegate.method_14487();
    }

    @NotNull
    public List<class_3298> method_14489(class_2960 location) {
        return this.delegate.method_14489(location);
    }

    @NotNull
    public Map<class_2960, class_3298> method_14488(String path, Predicate<class_2960> filter) {
        if (!path.contains("items")) {
            return this.delegate.method_14488(path, filter);
        }
        Map originalMap = this.delegate.method_14488(path, filter);
        TreeMap<class_2960, class_3298> mergedMap = new TreeMap<class_2960, class_3298>();
        AtomicBoolean handAnimationOnSwap = new AtomicBoolean(true);
        AtomicBoolean oversizedInGui = new AtomicBoolean(false);
        for (Map.Entry entry : originalMap.entrySet()) {
            class_3298 merged = this.mergeItemModelResource((class_2960)entry.getKey(), (class_3298)entry.getValue(), handAnimationOnSwap, oversizedInGui);
            mergedMap.put((class_2960)entry.getKey(), merged);
        }
        return mergedMap;
    }

    @NotNull
    public Map<class_2960, List<class_3298>> method_41265(String path, Predicate<class_2960> filter) {
        return this.delegate.method_41265(path, filter);
    }

    @NotNull
    public Stream<class_3262> method_29213() {
        return this.delegate.method_29213();
    }

    @NotNull
    public Optional<class_3298> method_14486(class_2960 location) {
        if (!location.method_12832().contains("items/")) {
            return this.delegate.method_14486(location);
        }
        Optional optional = this.delegate.method_14486(location);
        if (optional.isEmpty()) {
            return optional;
        }
        class_3298 merged = this.mergeItemModelResource(location, (class_3298)optional.get(), null, null);
        return Optional.of(merged);
    }

    private class_3298 mergeItemModelResource(class_2960 location, class_3298 topResource, @Nullable AtomicBoolean handAnimationOnSwap, @Nullable AtomicBoolean oversizedInGui) {
        List stack = this.delegate.method_14489(location);
        if (stack.isEmpty()) {
            return topResource;
        }
        ArrayList<JsonObject> allModels = new ArrayList<JsonObject>(stack.size());
        for (class_3298 res : stack) {
            try {
                InputStream is = res.method_14482();
                try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    if (!json.has("model") || !json.getAsJsonObject("model").has("type")) continue;
                    allModels.add(json);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception is) {}
        }
        if (allModels.isEmpty()) {
            return topResource;
        }
        LinkedHashMap<String, PropertyGroup> groupedByProperty = new LinkedHashMap<String, PropertyGroup>();
        JsonObject baseFallback = null;
        for (JsonObject modelJson : allModels) {
            boolean localOversizedInGui;
            boolean localHandAnimationOnSwap;
            JsonElement fb;
            JsonObject model = modelJson.getAsJsonObject("model");
            String type = model.get("type").getAsString();
            if (!SELECT_TYPE.equals(type) && !"select".equals(type)) continue;
            String propertyKey = this.extractPropertyKey(model);
            PropertyGroup group = groupedByProperty.computeIfAbsent(propertyKey, k -> new PropertyGroup(propertyKey));
            if (group.templateNode == null) {
                group.templateNode = model.deepCopy();
            }
            if (model.has("cases")) {
                JsonArray cases = model.getAsJsonArray("cases");
                group.addCases(cases);
            }
            if (baseFallback == null && model.has("fallback") && (fb = model.get("fallback")).isJsonObject()) {
                baseFallback = fb.getAsJsonObject();
            }
            if (handAnimationOnSwap == null || oversizedInGui == null) continue;
            boolean bl = localHandAnimationOnSwap = modelJson.has("hand_animation_on_swap") && modelJson.get("hand_animation_on_swap").getAsBoolean();
            if (handAnimationOnSwap.get()) {
                handAnimationOnSwap.set(localHandAnimationOnSwap);
            }
            boolean bl2 = localOversizedInGui = modelJson.has("oversized_in_gui") && modelJson.get("oversized_in_gui").getAsBoolean();
            if (oversizedInGui.get()) continue;
            oversizedInGui.set(localOversizedInGui);
        }
        if (groupedByProperty.isEmpty()) {
            return topResource;
        }
        JsonObject chainedModel = this.buildFallbackChain(groupedByProperty, baseFallback);
        JsonObject result = new JsonObject();
        result.add("model", (JsonElement)chainedModel);
        result.addProperty("hand_animation_on_swap", Boolean.valueOf(ModConfig.get().handAnimationOnSwap));
        result.addProperty("oversized_in_gui", Boolean.valueOf(ModConfig.get().oversizedInGui));
        if (ModConfig.get().enableDebug && ModConfig.get().debugItems.contains(location.toString())) {
            DebugUtils.ExportDebugItem(location, result);
        }
        byte[] bytes = result.toString().getBytes(StandardCharsets.UTF_8);
        return new class_3298(topResource.method_45304(), () -> new ByteArrayInputStream(bytes));
    }

    private String extractPropertyKey(JsonObject model) {
        if (!model.has("property")) {
            return "unknown";
        }
        JsonElement propElement = model.get("property");
        if (propElement.isJsonPrimitive()) {
            String propertyType = propElement.getAsString();
            if (propertyType.contains("component") && model.has("component")) {
                String component = model.get("component").getAsString();
                return propertyType + ":" + component;
            }
            return propertyType;
        }
        if (propElement.isJsonObject()) {
            return propElement.toString();
        }
        return "unknown";
    }

    private JsonObject buildFallbackChain(Map<String, PropertyGroup> groups, JsonObject baseFallback) {
        JsonObject currentFallback = baseFallback;
        ArrayList<PropertyGroup> groupList = new ArrayList<PropertyGroup>(groups.values());
        for (PropertyGroup group : groupList) {
            JsonObject selectNode = new JsonObject();
            if (group.templateNode != null) {
                for (Map.Entry entry : group.templateNode.entrySet()) {
                    String key = (String)entry.getKey();
                    if ("cases".equals(key) || "fallback".equals(key)) continue;
                    selectNode.add(key, (JsonElement)entry.getValue());
                }
            } else {
                selectNode.addProperty("type", SELECT_TYPE);
            }
            JsonArray dedupedCases = this.deduplicateCases(group.allCases);
            if (!dedupedCases.isEmpty()) {
                selectNode.add("cases", (JsonElement)dedupedCases);
            }
            if (currentFallback != null) {
                selectNode.add("fallback", (JsonElement)currentFallback);
            }
            currentFallback = selectNode;
        }
        return currentFallback;
    }

    private JsonArray deduplicateCases(List<JsonArray> allCases) {
        JsonArray result = new JsonArray();
        HashSet<String> seenWhen = new HashSet<String>();
        for (JsonArray casesArray : allCases) {
            for (int i = 0; i < casesArray.size(); ++i) {
                JsonObject caseObj = casesArray.get(i).getAsJsonObject();
                String whenKey = caseObj.get("when").toString();
                if (seenWhen.contains(whenKey)) continue;
                seenWhen.add(whenKey);
                result.add((JsonElement)caseObj);
            }
        }
        return result;
    }

    private static class PropertyGroup {
        final String propertyKey;
        JsonObject templateNode;
        final List<JsonArray> allCases = new ArrayList<JsonArray>();

        PropertyGroup(String key) {
            this.propertyKey = key;
        }

        void addCases(JsonArray cases) {
            if (cases != null && !cases.isEmpty()) {
                this.allCases.add(cases);
            }
        }
    }
}

