/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity;

import java.nio.file.Path;
import java.util.Random;
import net.lerariemann.infinity.access.MinecraftServerAccess;
import net.lerariemann.infinity.dimensions.RandomText;
import net.lerariemann.infinity.registry.core.ModBlockEntities;
import net.lerariemann.infinity.registry.core.ModBlocks;
import net.lerariemann.infinity.registry.core.ModEntities;
import net.lerariemann.infinity.registry.core.ModFeatures;
import net.lerariemann.infinity.registry.core.ModItemFunctions;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.registry.core.ModStatusEffects;
import net.lerariemann.infinity.registry.core.ModStructureTypes;
import net.lerariemann.infinity.registry.var.ModCommands;
import net.lerariemann.infinity.registry.var.ModCriteria;
import net.lerariemann.infinity.registry.var.ModDensityFunctionTypes;
import net.lerariemann.infinity.registry.var.ModMaterialConditions;
import net.lerariemann.infinity.registry.var.ModMaterialRules;
import net.lerariemann.infinity.registry.var.ModPayloads;
import net.lerariemann.infinity.registry.var.ModPlacementModifiers;
import net.lerariemann.infinity.registry.var.ModPoi;
import net.lerariemann.infinity.registry.var.ModSounds;
import net.lerariemann.infinity.registry.var.ModStats;
import net.lerariemann.infinity.util.PlatformMethods;
import net.lerariemann.infinity.util.config.ConfigManager;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.class_5218;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinityMod {
    public static final String MOD_ID = "infinity";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Infinite Dimensions");
    public static Path configPath = PlatformMethods.getConfigPath();
    public static Path utilPath = configPath.resolve(".util");
    public static Path invocationLock = configPath.resolve("modular/invocation.lock");
    public static Path rootConfigPathInJar;
    public static RandomProvider provider;
    public static Random random;

    public static void updateProvider(MinecraftServer server) {
        RandomProvider p = new RandomProvider(server.method_27050(class_5218.field_24186).resolve(MOD_ID));
        p.kickGhostsOut((class_5455)server.method_30611());
        provider = p;
        if (!((MinecraftServerAccess)server).infinity$needsInvocation()) {
            ModMaterialRules.RandomBlockMaterialRule.setProvider(p);
        }
    }

    public static void init() {
        rootConfigPathInJar = PlatformMethods.getRootConfigPath();
        ConfigManager.updateInvocationLock();
        ConfigManager.unpackDefaultConfigs();
        ModStatusEffects.registerModEffects();
        ModItemFunctions.registerItemFunctions();
        ModEntities.registerEntities();
        ModBlocks.registerModBlocks();
        ModItems.registerModItems();
        ModPayloads.registerC2SPacketsReceivers();
        ModBlockEntities.registerBlockEntities();
        ModPoi.registerPoi();
        ModCommands.registerCommands();
        ModDensityFunctionTypes.registerFunctions();
        ModMaterialConditions.registerConditions();
        ModMaterialRules.registerRules();
        ModPlacementModifiers.registerModifiers();
        ModStructureTypes.registerStructures();
        ModSounds.registerSounds();
        ModFeatures.registerFeatures();
        ModStats.registerStats();
        ModCriteria.registerCriteria();
        RandomText.walkPaths();
        provider = new RandomProvider();
    }

    static {
        random = new Random();
    }
}

