/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.custom;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.lerariemann.infinity.block.entity.BiomeBottleBlockEntity;
import net.lerariemann.infinity.registry.core.ModBlockEntities;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5742;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class BiomeBottleBlock
extends class_2237 {
    public static final class_2758 LEVEL = class_2758.method_11867((String)"level", (int)0, (int)10);
    public static final class_265 MAIN = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    public static final class_265 TIP = class_2248.method_9541((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final class_265 CORK = class_2248.method_9541((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0);
    public static final class_265 SHAPE = class_259.method_17786((class_265)MAIN, (class_265[])new class_265[]{TIP, CORK});
    public static final int maxAllowedCharge = 10000;

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public BiomeBottleBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LEVEL});
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        if (itemStack.method_7985()) {
            assert (itemStack.method_7969() != null);
            int charge = itemStack.method_7969().method_10562("BlockEntityTag").method_10550("Charge");
            int level = BiomeBottleBlock.getLevel(charge);
            state = (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(level));
            world.method_8501(pos, state);
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof BiomeBottleBlockEntity) {
                BiomeBottleBlockEntity biomeBottleBlockEntity = (BiomeBottleBlockEntity)class_25862;
                biomeBottleBlockEntity.color = itemStack.method_7969().method_10562("BlockEntityTag").method_10550("Color");
            }
        }
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BiomeBottleBlockEntity(pos, state);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return BiomeBottleBlock.method_31618(type, (class_2591)((class_2591)ModBlockEntities.BIOME_BOTTLE.get()), (class_5558)(world.field_9236 ? null : BiomeBottleBlockEntity::serverTick));
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 class_17992;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof BiomeBottleBlockEntity) {
            BiomeBottleBlockEntity bbbe = (BiomeBottleBlockEntity)class_25862;
            class_17992 = bbbe.asStack();
        } else {
            class_17992 = super.method_9574(world, pos, state);
        }
        return class_17992;
    }

    public static class_2960 defaultBiome() {
        return new class_2960("plains");
    }

    public static class_1814 getRarity(int charge) {
        return charge < 1000 ? class_1814.field_8906 : (charge < 9000 ? class_1814.field_8907 : class_1814.field_8903);
    }

    public static void updateCharge(class_1799 stack, int charge) {
        if (stack.method_7985()) {
            assert (stack.method_7969() != null);
            stack.method_7969().method_10562("BlockEntityTag").method_10569("Charge", charge);
        }
    }

    public static void updateCharge(class_1799 stack) {
        int charge = BiomeBottleBlock.getCharge(stack);
        if (charge > 0) {
            BiomeBottleBlock.updateCharge(stack, charge);
        }
    }

    public static int getLevel(int charge) {
        return class_3532.method_15340((int)(charge / 100), (int)0, (int)10);
    }

    public static boolean isEmpty(class_1799 stack) {
        return BiomeBottleBlock.getCharge(stack) == 0;
    }

    public static class_2960 getBiome(class_1799 stack) {
        if (stack.method_7985()) {
            assert (stack.method_7969() != null);
            return new class_2960(stack.method_7969().method_10562("BlockEntityTag").method_10558("Biome"));
        }
        return BiomeBottleBlock.defaultBiome();
    }

    public static int getCharge(class_1799 stack) {
        if (stack.method_7985()) {
            assert (stack.method_7969() != null);
            return stack.method_7969().method_10562("BlockEntityTag").method_10550("Charge");
        }
        return 0;
    }

    public static void playSploosh(class_3218 world, class_2338 pos) {
        world.method_8396(null, pos, class_3417.field_14737, class_3419.field_15245, 1.0f, 1.0f);
        world.method_14199((class_2394)class_2398.field_11202, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 30, 0.5, 0.5, 0.5, 0.2);
    }

    public static class_6880<class_1959> biomeFromId(class_3218 world, class_2960 id) {
        class_2378 registry = world.method_8503().method_30611().method_30530(class_7924.field_41236);
        class_1959 biome = (class_1959)registry.method_10223(id);
        return registry.method_47983((Object)biome);
    }

    public static void spreadCircle(class_3218 world, class_2338 origin, class_2960 biomeId, int charge) {
        BiomeBottleBlock.spreadRing(world, origin, biomeId, 0, charge);
    }

    public static void spreadRing(class_3218 world, class_2338 origin, class_2960 biomeId, int chargemin, int chargemax) {
        HashSet<class_2338> posSet = new HashSet<class_2338>();
        HashSet<class_2791> set = new HashSet<class_2791>();
        origin = origin.method_10087(origin.method_10264());
        double ramax = (double)chargemax / Math.PI;
        double ramin = (double)chargemin / Math.PI;
        int i = 0;
        while ((double)(i * i) < ramax) {
            int j = 0;
            while ((double)(i * i + j * j) < ramax) {
                if ((double)(i * i + j * j) >= ramin) {
                    List<class_2338> signs = BiomeBottleBlock.offsets(origin, i, j);
                    posSet.addAll(signs);
                    set.addAll(signs.stream().map(class_1923::new).map(chunkPos -> world.method_22350(chunkPos.method_8323())).filter(Objects::nonNull).collect(Collectors.toSet()));
                }
                ++j;
            }
            ++i;
        }
        BiomeBottleBlock.spread(world, set, posSet, BiomeBottleBlock.biomeFromId(world, biomeId));
    }

    public static void spread(class_3218 world, Set<class_2791> set, Set<class_2338> posSet, class_6880<class_1959> biome) {
        if (biome == null) {
            return;
        }
        set.forEach(chunk -> {
            if (chunk != null) {
                chunk.method_38257((x, y, z, noise) -> {
                    int i = class_5742.method_33101((int)x);
                    int k = class_5742.method_33101((int)z);
                    class_6880 registryEntry2 = chunk.method_16359(x, y, z);
                    if (posSet.contains(new class_2338(i, 0, k))) {
                        return biome;
                    }
                    return registryEntry2;
                }, world.method_14178().method_41248().method_42371());
                chunk.method_12008(true);
            }
        });
        world.method_14178().field_17254.method_49421(set.stream().toList());
    }

    public static List<class_2338> offsets(class_2338 origin, int i, int j) {
        return List.of(origin.method_10069(i, 0, j), origin.method_10069(j, 0, i), origin.method_10069(-i, 0, j), origin.method_10069(j, 0, -i), origin.method_10069(i, 0, -j), origin.method_10069(-j, 0, i), origin.method_10069(-i, 0, -j), origin.method_10069(-j, 0, -i));
    }
}

