/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.custom;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.access.Timebombable;
import net.lerariemann.infinity.block.custom.Boopable;
import net.lerariemann.infinity.block.entity.InfinityPortalBlockEntity;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.entity.custom.ChaosPawn;
import net.lerariemann.infinity.item.TransfiniteKeyItem;
import net.lerariemann.infinity.item.function.CollisionCraftingRecipe;
import net.lerariemann.infinity.registry.core.ModComponentTypes;
import net.lerariemann.infinity.registry.core.ModEntities;
import net.lerariemann.infinity.registry.core.ModItemFunctions;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.registry.var.ModPoi;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.lerariemann.infinity.util.teleport.InfinityPortal;
import net.lerariemann.infinity.util.teleport.PortalCreator;
import net.lerariemann.infinity.util.teleport.WarpLogic;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2423;
import net.minecraft.class_2424;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3730;
import net.minecraft.class_3956;
import net.minecraft.class_3965;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5459;
import net.minecraft.class_5819;
import net.minecraft.class_7477;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class InfinityPortalBlock
extends class_2423
implements class_2343,
Boopable {
    public InfinityPortalBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)BOOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        this.appendBoop(builder);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new InfinityPortalBlockEntity(pos, state, class_1937.field_25179.method_29177());
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            MinecraftServer s = world.method_8503();
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof InfinityPortalBlockEntity) {
                InfinityPortalBlockEntity npbe = (InfinityPortalBlockEntity)blockEntity;
                if (npbe.isOpen() && InfinityPortalBlock.world_exists(s, npbe.getDimension())) {
                    return class_1269.field_5811;
                }
                RandomProvider prov = InfinityMod.provider;
                Optional<class_1792> key = prov.getPortalKeyAsItem();
                if (key.isEmpty()) {
                    if (!npbe.isOpen()) {
                        PortalCreator.openWithStatIncrease(player, s, serverWorld, pos);
                    }
                } else {
                    class_1799 usedKey = player.method_5998(class_1268.field_5808);
                    if (usedKey.method_31574(key.get())) {
                        if (!player.method_31549().field_7477 && RandomProvider.rule("consumePortalKey")) {
                            usedKey.method_7934(1);
                        }
                        PortalCreator.openWithStatIncrease(player, s, serverWorld, pos);
                    }
                }
            }
        }
        return class_1269.field_5811;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof InfinityPortalBlockEntity) {
            InfinityPortalBlockEntity ipbe = (InfinityPortalBlockEntity)class_25862;
            class_1799 stack = ((TransfiniteKeyItem)ModItems.TRANSFINITE_KEY.get()).method_7854();
            class_2487 compound = InfinityPortalBlock.putKeyComponents(class_1802.field_27063, ipbe.getDimension());
            stack.method_7980(compound);
            return stack;
        }
        return class_1799.field_8037;
    }

    static boolean world_exists(MinecraftServer s, class_2960 l) {
        return !l.method_12836().equals("infinity") || s.method_27050(class_5218.field_24186).resolve(l.method_12832()).toFile().exists() || s.method_29435().contains(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)l));
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (random.method_43048(100) == 0) {
            world.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_15045, class_3419.field_15245, 1.0f, random.method_43057() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d = (double)pos.method_10263() + random.method_43058();
            double e = (double)pos.method_10264() + random.method_43058();
            double f = (double)pos.method_10260() + random.method_43058();
            double g = ((double)random.method_43057() - 0.5) * 0.5;
            double h = ((double)random.method_43057() - 0.5) * 0.5;
            double j = ((double)random.method_43057() - 0.5) * 0.5;
            int k = random.method_43048(2) * 2 - 1;
            if (!world.method_8320(pos.method_10067()).method_27852((class_2248)this) && !world.method_8320(pos.method_10078()).method_27852((class_2248)this)) {
                d = (double)pos.method_10263() + 0.5 + 0.25 * (double)k;
                g = random.method_43057() * 2.0f * (float)k;
            } else {
                f = (double)pos.method_10260() + 0.5 + 0.25 * (double)k;
                j = random.method_43057() * 2.0f * (float)k;
            }
            class_2400 eff = class_2398.field_11214;
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof InfinityPortalBlockEntity) {
                InfinityPortalBlockEntity npbe = (InfinityPortalBlockEntity)blockEntity;
                int colorInt = npbe.getPortalColor();
                class_243 vec3d = class_243.method_24457((int)colorInt);
                double color = 1.0 + (double)(colorInt >> 16 & 0xFF) / 255.0;
                eff = new class_2390(new Vector3f((float)vec3d.field_1352, (float)vec3d.field_1351, (float)vec3d.field_1350), (float)color);
            }
            world.method_8406((class_2394)eff, d, e, f, g, h, j);
        }
    }

    public static class_2487 putKeyComponents(class_1792 item, class_2960 dim) {
        class_2487 nbtCompound = new class_2487();
        if (!(item.equals(class_1802.field_27063) || item.method_7854().method_31573(class_3489.field_15544) || item.method_7854().method_31573(class_3489.field_15542))) {
            return nbtCompound;
        }
        int keycolor = WarpLogic.getKeyColorFromId(dim);
        nbtCompound.method_10569(ModComponentTypes.COLOR, keycolor);
        if (!item.equals(class_1802.field_27063)) {
            return nbtCompound;
        }
        nbtCompound.method_10582(ModComponentTypes.DESTINATION, dim.toString());
        return nbtCompound;
    }

    public void method_9548(class_2680 state, class_1937 w, class_2338 pos, class_1297 entity) {
        class_3218 world;
        class_2586 class_25862;
        AtomicBoolean bl = new AtomicBoolean(false);
        if (w instanceof class_3218 && (class_25862 = (world = (class_3218)w).method_8321(pos)) instanceof InfinityPortalBlockEntity) {
            InfinityPortalBlockEntity ipbe = (InfinityPortalBlockEntity)class_25862;
            MinecraftServer server = world.method_8503();
            if (entity instanceof class_1542) {
                class_1542 e = (class_1542)entity;
                ModItemFunctions.checkCollisionRecipes(world, e, (class_3956<CollisionCraftingRecipe>)((class_3956)ModItemFunctions.PORTAL_CRAFTING_TYPE.get()), InfinityPortalBlock.putKeyComponents(e.method_6983().method_7909(), ipbe.getDimension()));
                InfinityMod.provider.getPortalKeyAsItem().ifPresent(item -> {
                    if (e.method_6983().method_31574(item)) {
                        InfinityPortal.tryUpdateOpenStatus(ipbe, world, pos, server);
                        if (ipbe.isOpen()) {
                            return;
                        }
                        class_1657 nearestPlayer = world.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 5.0, false);
                        PortalCreator.openWithStatIncrease(nearestPlayer, server, world, pos);
                        e.method_6983().method_7934(1);
                        e.method_18799(e.method_18798().method_1021(-1.0));
                        e.method_51850(200);
                        bl.set(true);
                    }
                });
            }
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                if (InfinityMod.provider.isPortalKeyBlank()) {
                    class_3218 world1 = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)ipbe.getDimension()));
                    if (world1 == null || !ipbe.isOpen()) {
                        PortalCreator.openWithStatIncrease(player, server, world, pos);
                    } else {
                        Timebombable tw = (Timebombable)world1;
                        if (tw.infinity$isTimebombed() && tw.infinity$tryRestore()) {
                            new RandomDimension(ipbe.getDimension(), server);
                            PortalCreator.openWithStatIncrease(player, server, world, pos);
                        }
                    }
                }
            }
        }
        if (!bl.get()) {
            super.method_9548(state, w, pos, entity);
        }
    }

    public static void tryUpdateOpenStatus(InfinityPortalBlockEntity npbe, class_3218 worldFrom, MinecraftServer server, class_2338 pos) {
        InfinityPortalBlock.tryUpdateOpenStatus(npbe, worldFrom, server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)npbe.getDimension())), pos);
    }

    public static void tryUpdateOpenStatus(InfinityPortalBlockEntity npbe, class_3218 worldFrom, class_3218 worldTo, class_2338 pos) {
        if (!npbe.isOpen() ^ worldTo == null) {
            PortalCreator.modifyPortalRecursive(worldFrom, pos, new PortalCreator.PortalModifier(e -> e.setOpen(!npbe.isOpen())));
        }
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (world.method_8597().comp_645() && world.method_8450().method_8355(class_1928.field_19390) && random.method_43048(2000) < world.method_8407().method_5461()) {
            ChaosPawn entity;
            while (world.method_8320(pos).method_27852((class_2248)this)) {
                pos = pos.method_10074();
            }
            if (world.method_8320(pos).method_26170((class_1922)world, pos, (class_1299)ModEntities.CHAOS_PAWN.get()) && InfinityMethods.chaosMobsEnabled() && (entity = (ChaosPawn)((class_1299)ModEntities.CHAOS_PAWN.get()).method_47821(world, pos.method_10084(), class_3730.field_16474)) != null) {
                entity.method_30229();
                class_2586 blockEntity = world.method_8321(pos.method_10084());
                if (blockEntity instanceof InfinityPortalBlockEntity) {
                    InfinityPortalBlockEntity npbe = (InfinityPortalBlockEntity)blockEntity;
                    int color = npbe.getPortalColor();
                    class_243 c = class_243.method_24457((int)color);
                    entity.setAllColors((int)(256.0 * c.field_1350) + 256 * (int)(256.0 * c.field_1351) + 65536 * (int)(256.0 * c.field_1352));
                }
            }
        }
    }

    public static class_5454 getTeleportTarget(class_1297 entity, InfinityPortalBlockEntity portal, class_3218 worldFrom, class_2338 posFrom) {
        class_2680 blockStateFrom = worldFrom.method_8320(posFrom);
        class_2350.class_2351 axisFrom = (class_2350.class_2351)blockStateFrom.method_11654((class_2769)class_2741.field_12529);
        class_5459.class_5460 portalFrom = class_5459.method_30574((class_2338)posFrom, (class_2350.class_2351)axisFrom, (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, posx -> worldFrom.method_8320(posx) == blockStateFrom);
        class_243 offset = entity.method_30633(axisFrom, portalFrom);
        class_5321 keyTo = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)portal.getDimension());
        class_3218 worldTo = worldFrom.method_8503().method_3847(keyTo);
        return InfinityPortalBlock.getTeleportTarget(entity, portal, worldFrom, posFrom, worldTo, axisFrom, offset);
    }

    public static class_5454 getTeleportTarget(class_1297 entity, InfinityPortalBlockEntity portal, class_3218 worldFrom, class_2338 posFrom, @Nullable class_3218 worldTo, class_2350.class_2351 axisFrom, class_243 offset) {
        InfinityPortalBlock.tryUpdateOpenStatus(portal, worldFrom, worldTo, posFrom);
        if (InfinityMethods.dimExists(worldTo) && portal.isOpen() && !worldTo.method_27983().equals(worldFrom.method_27983())) {
            class_2338 posTo = portal.getOtherSidePos();
            if (InfinityPortalBlock.isValidDestinationStrong(worldFrom, worldTo, posTo)) {
                InfinityPortalBlock.createTicket(worldTo, posTo);
                return InfinityPortalBlock.getExistingTarget(worldTo, posTo, entity, axisFrom, offset);
            }
            return InfinityPortalBlock.findNewTeleportTarget(worldFrom, posFrom, worldTo, entity, axisFrom, offset);
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            InfinityPortalBlock.sendErrors(player, worldFrom, worldTo, portal);
        }
        return InfinityPortalBlock.emptyTarget(entity);
    }

    static void sendErrors(class_3222 player, class_3218 worldFrom, class_3218 worldTo, InfinityPortalBlockEntity ipbe) {
        if (worldTo != null) {
            if (worldTo.method_27983().equals(worldFrom.method_27983())) {
                player.method_43496((class_2561)class_2561.method_43471((String)"error.infinity.portal.matching_ends"));
            } else if (((Timebombable)worldTo).infinity$isTimebombed()) {
                player.method_43496((class_2561)class_2561.method_43471((String)"error.infinity.portal.deleted"));
            } else {
                InfinityMethods.sendUnexpectedError(player, "portal");
            }
        } else if (!ipbe.isOpen()) {
            InfinityMod.provider.getPortalKeyAsItem().ifPresent(item -> player.method_43496((class_2561)class_2561.method_43469((String)"error.infinity.portal.closed", (Object[])new Object[]{((class_5250)item.method_7848()).method_27692(class_124.field_1075)})));
        } else {
            player.method_43496((class_2561)class_2561.method_43471((String)"error.infinity.portal.null"));
        }
    }

    public static void createTicket(class_3218 worldTo, class_2338 posTo) {
        worldTo.method_14178().method_17297(class_3230.field_19280, new class_1923(posTo), 3, (Object)posTo);
    }

    static class_2350.class_2351 getAxisOrDefault(class_2680 state) {
        return state.method_28500((class_2769)field_11310).orElse(class_2350.class_2351.field_11048);
    }

    public static class_5454 emptyTarget(class_1297 entity) {
        return new class_5454(entity.method_19538(), entity.method_18798(), entity.method_36454(), entity.method_36455());
    }

    public static class_5454 getExistingTarget(class_3218 worldTo, class_2338 posTo, class_1297 teleportingEntity, class_2350.class_2351 axisFrom, class_243 offset) {
        class_2680 blockStateTo = worldTo.method_8320(posTo);
        class_2350.class_2351 axisTo = (class_2350.class_2351)blockStateTo.method_11654((class_2769)class_2741.field_12529);
        class_5459.class_5460 portalTo = class_5459.method_30574((class_2338)posTo, (class_2350.class_2351)axisTo, (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, posx -> worldTo.method_8320(posx) == blockStateTo);
        return class_2424.method_30484((class_3218)worldTo, (class_5459.class_5460)portalTo, (class_2350.class_2351)axisFrom, (class_243)offset, (class_1297)teleportingEntity, (class_243)teleportingEntity.method_18798(), (float)teleportingEntity.method_36454(), (float)teleportingEntity.method_36455());
    }

    public static boolean isValidDestinationWeak(class_3218 worldFrom, class_3218 worldTo, class_2338 posTo) {
        InfinityPortalBlockEntity ipbe;
        class_2586 class_25862;
        if (posTo == null || !InfinityMethods.dimExists(worldTo)) {
            return false;
        }
        return worldTo.method_8320(posTo).method_27852(class_2246.field_10316) || (class_25862 = worldTo.method_8321(posTo)) instanceof InfinityPortalBlockEntity && (ipbe = (InfinityPortalBlockEntity)class_25862).getDimension().toString().equals(worldFrom.method_27983().method_29177().toString());
    }

    public static boolean isValidDestinationStrong(class_3218 worldFrom, class_3218 worldTo, class_2338 posTo) {
        InfinityPortalBlockEntity ipbe;
        if (posTo == null || !InfinityMethods.dimExists(worldTo)) {
            return false;
        }
        class_2586 class_25862 = worldTo.method_8321(posTo);
        return class_25862 instanceof InfinityPortalBlockEntity && (ipbe = (InfinityPortalBlockEntity)class_25862).getDimension().toString().equals(worldFrom.method_27983().method_29177().toString());
    }

    public static class_5454 findNewTeleportTarget(class_3218 worldFrom, class_2338 posFrom, class_3218 worldTo, class_1297 teleportingEntity, class_2350.class_2351 axisFrom, class_243 offset) {
        class_5459.class_5460 portalTo = InfinityPortalBlock.findOrCreateExitPortal(worldFrom, posFrom, worldTo);
        if (portalTo == null) {
            if (teleportingEntity instanceof class_3222) {
                class_3222 player = (class_3222)teleportingEntity;
                player.method_43496((class_2561)class_2561.method_43471((String)"error.infinity.portal.cannot_create"));
            }
            return InfinityPortalBlock.emptyTarget(teleportingEntity);
        }
        class_2338 posTo = InfinityPortalBlock.lowerCenterPos(portalTo, (class_1937)worldTo);
        InfinityPortalBlock.createTicket(worldTo, posTo);
        InfinityPortalBlock.trySyncPortals(worldFrom, posFrom, worldTo, posTo);
        return class_2424.method_30484((class_3218)worldTo, (class_5459.class_5460)portalTo, (class_2350.class_2351)axisFrom, (class_243)offset, (class_1297)teleportingEntity, (class_243)teleportingEntity.method_18798(), (float)teleportingEntity.method_36454(), (float)teleportingEntity.method_36455());
    }

    public static class_5459.class_5460 findOrCreateExitPortal(class_3218 worldFrom, class_2338 posFrom, class_3218 worldTo) {
        class_5459.class_5460 portalTo;
        class_2784 wb = worldTo.method_8621();
        double d = class_2874.method_31109((class_2874)worldFrom.method_8597(), (class_2874)worldTo.method_8597());
        class_2338 originOfTesting = wb.method_39538((double)posFrom.method_10263() * d, (double)posFrom.method_10264(), (double)posFrom.method_10260() * d);
        Optional<class_2338> optional = InfinityPortalBlock.findNewExitPortalPosition(worldFrom, worldTo, wb, originOfTesting);
        if (optional.isPresent()) {
            class_2338 posTo = optional.get();
            class_2680 blockState = worldTo.method_8320(posTo);
            class_2350.class_2351 axisTo = InfinityPortalBlock.getAxisOrDefault(blockState);
            portalTo = class_5459.method_30574((class_2338)posTo, (class_2350.class_2351)axisTo, (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, posx -> worldTo.method_8320(posx) == blockState);
        } else {
            class_2350.class_2351 axisTo = InfinityPortalBlock.getAxisOrDefault(worldFrom.method_8320(posFrom));
            Optional optional2 = worldTo.method_14173().method_30482(originOfTesting, axisTo);
            if (optional2.isEmpty()) {
                return null;
            }
            portalTo = (class_5459.class_5460)optional2.get();
        }
        return portalTo;
    }

    public static class_2338 lowerCenterPos(class_5459.class_5460 rect, class_1937 world) {
        return InfinityPortalBlock.lowerCenterPos(rect, (class_2350.class_2351)world.method_8320(rect.field_25936).method_11654((class_2769)class_2741.field_12529));
    }

    static class_2338 lowerCenterPos(class_5459.class_5460 rect, class_2350.class_2351 axis) {
        boolean bl = axis.equals((Object)class_2350.class_2351.field_11048);
        int i = rect.field_25937 / 2;
        return rect.field_25936.method_10069(bl ? i : 0, 0, bl ? 0 : i);
    }

    static Optional<class_2338> findNewExitPortalPosition(class_3218 worldFrom, class_3218 worldTo, class_2784 wbTo, class_2338 originOfTesting) {
        int radiusOfTesting = 128;
        class_4153 poiStorage = worldTo.method_19494();
        poiStorage.method_22439((class_4538)worldTo, originOfTesting, radiusOfTesting);
        Set allPortalsInRange = poiStorage.method_22383(poiType -> poiType.method_40225(class_7477.field_39295) || poiType.method_40225(ModPoi.NEITHER_PORTAL_KEY), originOfTesting, radiusOfTesting, class_4153.class_4155.field_18489).map(class_4156::method_19141).filter(arg_0 -> ((class_2784)wbTo).method_11952(arg_0)).collect(Collectors.toSet());
        Set matchingPortalsInRange = allPortalsInRange.stream().filter(pos -> InfinityPortalBlock.isValidDestinationStrong(worldFrom, worldTo, pos)).collect(Collectors.toSet());
        if (matchingPortalsInRange.isEmpty()) {
            matchingPortalsInRange = allPortalsInRange.stream().filter(pos -> InfinityPortalBlock.isValidDestinationWeak(worldFrom, worldTo, pos)).collect(Collectors.toSet());
        }
        return matchingPortalsInRange.stream().min(Comparator.comparingDouble(posTo -> posTo.method_10262((class_2382)originOfTesting)));
    }

    public static boolean trySyncPortals(class_3218 worldFrom, class_2338 posFrom, class_3218 worldTo, class_2338 posTo) {
        if (!(worldTo.method_8320(posTo).method_26204() instanceof class_2423)) {
            return false;
        }
        PortalCreator.PortalModifierUnion otherSideModifier = new PortalCreator.PortalModifierUnion();
        class_2960 idFrom = worldFrom.method_27983().method_29177();
        class_2586 class_25862 = worldTo.method_8321(posTo);
        if (class_25862 instanceof InfinityPortalBlockEntity) {
            InfinityPortalBlockEntity ipbe2 = (InfinityPortalBlockEntity)class_25862;
            if (!Objects.equals(ipbe2.getDimension().toString(), idFrom.toString())) {
                return false;
            }
            if (ipbe2.isConnectedBothSides()) {
                return false;
            }
        } else {
            otherSideModifier = PortalCreator.forInitialSetupping(worldTo, posTo, idFrom, true);
        }
        otherSideModifier.addModifier(ipbe1 -> ipbe1.setBlockPos(posFrom));
        PortalCreator.modifyPortalRecursive(worldFrom, posFrom, new PortalCreator.PortalModifier(ipbe -> ipbe.setBlockPos(posTo)));
        PortalCreator.modifyPortalRecursive(worldTo, posTo, otherSideModifier);
        return true;
    }
}

