/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.entity;

import net.lerariemann.infinity.block.custom.BiomeBottleBlock;
import net.lerariemann.infinity.block.entity.TintableBlockEntity;
import net.lerariemann.infinity.registry.core.ModBlockEntities;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class BiomeBottleBlockEntity
extends TintableBlockEntity {
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            if (index == 0) {
                return BiomeBottleBlockEntity.this.color;
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                BiomeBottleBlockEntity.this.color = value;
            }
        }

        public int method_17389() {
            return 1;
        }
    };
    private class_2960 biome;
    public int color;
    public int charge;
    private int from_charge;

    public BiomeBottleBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.BIOME_BOTTLE.get(), pos, state);
        this.empty();
    }

    public void setBiome(class_6880<class_1959> biome) {
        if (biome.method_40230().isPresent()) {
            this.setBiome(((class_1959)biome.comp_349()).method_8697(), ((class_5321)biome.method_40230().get()).method_29177());
        }
    }

    public void setBiome(int c, class_2960 i) {
        this.color = c;
        this.biome = i;
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10582("Biome", this.biome.toString());
        tag.method_10569("Color", this.color);
        tag.method_10569("Charge", this.charge);
        if (this.from_charge > 0) {
            tag.method_10569("from_charge", this.from_charge);
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.charge = tag.method_10550("Charge");
        this.biome = new class_2960(tag.method_10558("Biome"));
        this.color = tag.method_10550("Color");
        this.from_charge = NbtUtils.test(tag, "from_charge", 0);
    }

    @Nullable
    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public int getTint() {
        return this.propertyDelegate.method_17390(0);
    }

    public class_1799 asStack() {
        class_1799 itemStack = ((class_1792)ModItems.BIOME_BOTTLE_ITEM.get()).method_7854();
        return itemStack;
    }

    public boolean isTicking() {
        return this.from_charge > 0;
    }

    public void startTicking() {
        this.from_charge = this.charge;
    }

    public void empty() {
        this.color = 0xFFFFFF;
        this.biome = BiomeBottleBlock.defaultBiome();
        this.charge = 0;
        this.from_charge = 0;
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, BiomeBottleBlockEntity be) {
        class_3218 w;
        if (be.isTicking() && world instanceof class_3218 && (w = (class_3218)world).method_8510() % 20L == 0L) {
            int level = be.charge / 100;
            if (level <= 0) {
                be.empty();
            } else {
                int diff2 = be.charge > 1500 ? 500 : 100;
                int diff = be.charge % diff2;
                if (diff == 0) {
                    diff = diff2;
                }
                int charge_new = be.charge - diff;
                BiomeBottleBlock.spreadRing(w, pos, be.biome, be.from_charge - be.charge, be.from_charge - charge_new);
                be.charge = charge_new;
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)BiomeBottleBlock.LEVEL, (Comparable)Integer.valueOf(class_3532.method_15340((int)(level - 1), (int)0, (int)10))));
                BiomeBottleBlock.playSploosh(w, pos);
                be.method_5431();
            }
        }
    }
}

