/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.entity;

import java.awt.Color;
import java.util.concurrent.atomic.AtomicBoolean;
import net.lerariemann.infinity.block.custom.Boopable;
import net.lerariemann.infinity.block.entity.TintableBlockEntity;
import net.lerariemann.infinity.registry.core.ModBlockEntities;
import net.lerariemann.infinity.registry.core.ModItems;
import net.lerariemann.infinity.util.var.ColorLogic;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class ChromaticBlockEntity
extends TintableBlockEntity {
    public short hue = 0;
    public short saturation = 0;
    public short brightness = (short)255;
    public int color;

    public ChromaticBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.CHROMATIC.get(), pos, state);
    }

    public void setColor(int colorHex) {
        this.setColor(colorHex, null);
    }

    public void setColor(int hue, int saturation, int brightness, @Nullable AtomicBoolean cancel) {
        if (cancel != null && this.hue == hue && this.saturation == saturation && this.brightness == brightness) {
            cancel.set(true);
            return;
        }
        this.hue = (short)hue;
        this.saturation = (short)saturation;
        this.brightness = (short)brightness;
        this.updateColor();
        this.sync();
    }

    public void setColor(int colorHex, @Nullable AtomicBoolean cancel) {
        if (cancel != null && colorHex == this.color) {
            cancel.set(true);
            return;
        }
        Color c = new Color(colorHex);
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        this.hue = (short)(hsb[0] * 360.0f);
        this.saturation = (short)(hsb[1] * 255.0f);
        this.brightness = (short)(hsb[2] * 255.0f);
        this.color = colorHex;
        this.sync();
    }

    public void updateColor() {
        this.color = Color.HSBtoRGB((float)this.hue / 360.0f, (float)this.saturation / 255.0f, (float)this.brightness / 255.0f) & 0xFFFFFF;
    }

    public short offset(short orig, short amount, AtomicBoolean cancel) {
        if (amount < 0 ? orig == 0 : orig == 255) {
            cancel.set(true);
            return orig;
        }
        if ((orig = (short)(orig + amount)) < 0) {
            orig = 0;
        } else if (orig > 255) {
            orig = (short)255;
        }
        return orig;
    }

    public boolean onUse(class_1937 world, class_2338 pos, class_1799 stack) {
        class_3414 event = (class_3414)class_3417.field_14903.comp_349();
        float pitch = -1.0f;
        float volume = 1.0f;
        AtomicBoolean cancel = new AtomicBoolean(false);
        if (stack.method_31574(class_1802.field_27063)) {
            this.saturation = this.offset(this.saturation, (short)16, cancel);
            pitch = (float)this.saturation / 255.0f;
        } else if (stack.method_31574((class_1792)ModItems.FOOTPRINT.get())) {
            this.saturation = this.offset(this.saturation, (short)-16, cancel);
            pitch = (float)this.saturation / 255.0f;
        } else if (stack.method_31574((class_1792)ModItems.WHITE_MATTER.get())) {
            this.brightness = this.offset(this.brightness, (short)16, cancel);
            pitch = (float)this.brightness / 255.0f;
        } else if (stack.method_31574((class_1792)ModItems.BLACK_MATTER.get())) {
            this.brightness = this.offset(this.brightness, (short)-16, cancel);
            pitch = (float)this.brightness / 255.0f;
        } else {
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1769) {
                class_1769 dye = (class_1769)class_17922;
                this.setColor(ColorLogic.getChromaticColor(dye.method_7802()), cancel);
                event = class_3417.field_28391;
            } else {
                return false;
            }
        }
        if (cancel.get()) {
            return false;
        }
        this.updateColor();
        float f = pitch = pitch < 0.0f ? 1.0f : 0.5f + 1.5f * pitch;
        if (!world.method_8608()) {
            world.method_8396(null, pos, event, class_3419.field_15245, volume, pitch);
        }
        this.sync();
        return true;
    }

    public void onIridStarUse(boolean reverse) {
        if (reverse) {
            this.hue = (short)(this.hue - 10);
            if (this.hue < 0) {
                this.hue = (short)(this.hue + 360);
            }
        } else {
            this.hue = (short)(this.hue + 10);
            if (this.hue > 360) {
                this.hue = (short)(this.hue - 360);
            }
        }
        this.updateColor();
        this.sync();
    }

    void sync() {
        this.method_5431();
        if (this.field_11863 != null) {
            Boopable.boop(this.field_11863, this.field_11867);
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10573("color", 3)) {
            this.setColor(nbt.method_10550("color"));
        } else if (nbt.method_10573("color", 10)) {
            class_2487 color = nbt.method_10562("color");
            this.hue = color.method_10568("h");
            this.saturation = color.method_10568("s");
            this.brightness = color.method_10568("b");
            this.updateColor();
        }
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_2487 color = new class_2487();
        color.method_10575("h", this.hue);
        color.method_10575("s", this.saturation);
        color.method_10575("b", this.brightness);
        nbt.method_10566("color", (class_2520)color);
    }

    @Override
    public int getTint() {
        return this.color;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }
}

