/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.block.entity;

import java.util.Random;
import net.lerariemann.infinity.block.custom.InfinityPortalBlock;
import net.lerariemann.infinity.block.entity.TintableBlockEntity;
import net.lerariemann.infinity.options.PortalColorApplier;
import net.lerariemann.infinity.registry.core.ModBlockEntities;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.teleport.InfinityPortal;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3913;
import net.minecraft.class_5321;
import net.minecraft.class_5459;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class InfinityPortalBlockEntity
extends TintableBlockEntity {
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            if (index == 0) {
                return InfinityPortalBlockEntity.this.portalColor;
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                InfinityPortalBlockEntity.this.portalColor = value & 0xFFFFFF;
            }
        }

        public int method_17389() {
            return 1;
        }
    };
    private class_2960 dimension;
    private int portalColor;
    private boolean isOpen;
    @Nullable
    private class_2338 otherSidePos;

    public InfinityPortalBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.NEITHER_PORTAL.get(), pos, state);
    }

    public InfinityPortalBlockEntity(class_2338 pos, class_2680 state, class_2960 id) {
        this(pos, state, (int)InfinityMethods.getNumericFromId(id), id);
    }

    public InfinityPortalBlockEntity(class_2338 pos, class_2680 state, int i, class_2960 id) {
        this(pos, state);
        this.dimension = id;
        this.portalColor = i & 0xFFFFFF;
        this.isOpen = false;
        this.otherSidePos = null;
    }

    public class_2960 getDimension() {
        return this.dimension;
    }

    public class_3218 getDimensionAsWorld() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            return serverWorld.method_8503().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)this.getDimension()));
        }
        return null;
    }

    public int getPortalColor() {
        return this.portalColor;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Nullable
    public class_2338 getOtherSidePos() {
        return this.otherSidePos;
    }

    public void setDimension(long c) {
        this.setColor((int)c);
        this.setDimension(InfinityMethods.getDimId(c));
    }

    public void setDimension(class_2960 i) {
        this.dimension = i;
    }

    public void setColor(int c) {
        this.portalColor = c & 0xFFFFFF;
        if (this.field_11863 != null) {
            class_2680 bs = this.field_11863.method_8320(this.field_11867);
            this.field_11863.method_8413(this.field_11867, bs, bs, 0);
        }
    }

    public void setOpen(boolean i) {
        this.isOpen = i;
    }

    public void setBlockPos(class_2338 pos) {
        this.otherSidePos = pos;
        this.method_5431();
    }

    public void setData(MinecraftServer server, class_2960 i) {
        if (server == null) {
            this.setData(i);
            return;
        }
        this.setDimension(i);
        this.setColor(PortalColorApplier.of(i, server).apply(this.method_11016()));
        this.setOpen(server.method_29435().contains(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)i)));
    }

    public void setData(class_2960 i) {
        this.setDimension(i);
        this.setColor((int)InfinityMethods.getNumericFromId(i));
        this.setOpen(false);
    }

    public boolean isConnected() {
        class_3218 worldFrom;
        if (!this.isOpen()) {
            return false;
        }
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218 && !InfinityMethods.isTimebombed(worldFrom = (class_3218)class_19372)) {
            return InfinityPortal.isValidDestination(worldFrom, this.getDimensionAsWorld(), this.getOtherSidePos());
        }
        return false;
    }

    public boolean isConnectedBothSides() {
        class_3218 worldFrom;
        if (!this.isOpen()) {
            return false;
        }
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218 && !InfinityMethods.isTimebombed(worldFrom = (class_3218)class_19372)) {
            InfinityPortalBlockEntity ipbe;
            class_3218 worldTo = this.getDimensionAsWorld();
            class_2338 posTo = this.getOtherSidePos();
            if (posTo == null || !InfinityMethods.dimExists(worldTo)) {
                return false;
            }
            class_2586 class_25862 = worldTo.method_8321(posTo);
            return class_25862 instanceof InfinityPortalBlockEntity && (ipbe = (InfinityPortalBlockEntity)class_25862).getDimension().toString().equals(worldFrom.method_27983().method_29177().toString()) && ipbe.isConnected();
        }
        return false;
    }

    public boolean trySync() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 worldFrom = (class_3218)class_19372;
            class_3218 worldTo = this.getDimensionAsWorld();
            if (worldTo == null) {
                return false;
            }
            class_2338 posFrom = this.method_11016();
            class_5459.class_5460 portalTo = InfinityPortalBlock.findOrCreateExitPortal(worldFrom, posFrom, worldTo);
            class_2338 posTo = InfinityPortalBlock.lowerCenterPos(portalTo, (class_1937)worldTo);
            return InfinityPortalBlock.trySyncPortals(worldFrom, posFrom, worldTo, posTo);
        }
        return false;
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("Color", this.portalColor);
        tag.method_10582("Dimension", this.dimension.toString());
        tag.method_10556("Open", this.isOpen);
        if (this.otherSidePos != null) {
            class_2487 pos = new class_2487();
            pos.method_10569("x", this.otherSidePos.method_10263());
            pos.method_10569("y", this.otherSidePos.method_10264());
            pos.method_10569("z", this.otherSidePos.method_10260());
            tag.method_10566("other_side", (class_2520)pos);
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573("Dimension", 99)) {
            this.portalColor = tag.method_10550("Dimension") & 0xFFFFFF;
            this.dimension = tag.method_10545("DimensionName") ? new class_2960(tag.method_10558("DimensionName")) : InfinityMethods.getDimId(this.portalColor);
        } else if (tag.method_10573("Dimension", 8)) {
            this.dimension = new class_2960(tag.method_10558("Dimension"));
            this.portalColor = tag.method_10573("Color", 3) ? tag.method_10550("Color") : (this.field_11863 != null ? PortalColorApplier.of(this.dimension, this.field_11863.method_8503()) : PortalColorApplier.of(this.dimension, new class_2487())).apply(this.field_11867) & 0xFFFFFF;
        } else {
            this.setDimension(InfinityMethods.getRandomSeed(new Random()));
        }
        this.isOpen = tag.method_10577("Open");
        if (tag.method_10545("other_side")) {
            class_2487 pos = tag.method_10562("other_side");
            this.otherSidePos = new class_2338(pos.method_10550("x"), pos.method_10550("y"), pos.method_10550("z"));
        }
    }

    @Nullable
    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public int getTint() {
        return this.propertyDelegate.method_17390(0);
    }
}

