/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.compat.emi;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import net.lerariemann.infinity.compat.emi.EmiCompat;
import net.lerariemann.infinity.util.InfinityMethods;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;

public class ChromaticEmiRecipe
extends BasicEmiRecipe {
    class_2960 infoId;

    public static ChromaticEmiRecipe of(String id, class_1792 item) {
        return new ChromaticEmiRecipe(InfinityMethods.getId("/" + id), item, null);
    }

    public static ChromaticEmiRecipe withInfo(String id, class_1792 item) {
        return new ChromaticEmiRecipe(InfinityMethods.getId("/" + id), item, InfinityMethods.getId(id));
    }

    public ChromaticEmiRecipe(class_2960 id, class_1792 item, @Nullable class_2960 infoId) {
        super(EmiCompat.CHROMATIC, id, 140, 18);
        this.inputs.add(EmiIngredient.of((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{item})));
        this.infoId = infoId;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 0, 0);
        class_5250 text = class_2561.method_43471((String)class_156.method_646((String)"chromatic", (class_2960)this.id));
        HashMap chars = new HashMap();
        text.method_30937().accept((index, style, codepoint) -> {
            chars.put(index, class_2561.method_43470((String)String.valueOf(Character.toChars(codepoint))).method_27696(style));
            return true;
        });
        int len = chars.size();
        class_5250 finalText = class_2561.method_43473();
        for (int i = 0; i < len; ++i) {
            class_5250 ch = (class_5250)chars.get(i);
            if (ch == null) continue;
            class_5250 chStyle = ch.method_10862(class_2583.field_24360.method_36139(this.getCharColor(i, len)));
            finalText.method_10852((class_2561)chStyle);
        }
        if (this.infoId != null) {
            widgets.add((Widget)new TextWidgetWithTooltip(class_2561.method_43470((String)"\u2139").method_27692(class_124.field_1080).method_30937(), 128, 5, 0xFFFFFF, false, (class_2561)class_2561.method_43471((String)class_156.method_646((String)"chromatic_info", (class_2960)this.infoId))));
        }
        widgets.addText((class_2561)finalText, 24, 5, 0xFFFFFF, false);
    }

    public int getCharColor(int chnum, int len) {
        float brightness;
        float saturation;
        float hue = 0.7417f;
        if (this.id.method_12832().contains("hue")) {
            hue = (float)chnum / (float)len;
            saturation = 1.0f;
            brightness = 0.85f;
        } else if (this.id.method_12832().contains("saturation")) {
            saturation = 0.6157f * (float)chnum / (float)len;
            if (this.id.method_12832().contains("minus")) {
                saturation = 0.6157f - saturation;
            }
            brightness = 0.5f;
        } else if (this.id.method_12832().contains("brightness")) {
            brightness = 0.8588f * (float)chnum / (float)len;
            if (this.id.method_12832().contains("minus")) {
                brightness = 0.8588f - brightness;
            }
            saturation = 0.6157f;
        } else {
            return 9524443;
        }
        return Color.HSBtoRGB(hue, saturation, brightness);
    }

    public static class TextWidgetWithTooltip
    extends TextWidget {
        class_2561 tooltip;

        public TextWidgetWithTooltip(class_5481 text, int x, int y, int color, boolean shadow, class_2561 tooltip) {
            super(text, x, y, color, shadow);
            this.tooltip = tooltip;
        }

        public List<class_5684> getTooltip(int mouseX, int mouseY) {
            return List.of(class_5684.method_32662((class_5481)this.tooltip.method_30937()));
        }
    }
}

