/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.lerariemann.infinity.dimensions.RandomCarver;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.dimensions.RandomFeaturesList;
import net.lerariemann.infinity.dimensions.RandomMobsList;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.lerariemann.infinity.util.core.WeighedStructure;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class RandomBiome {
    public RandomDimension parent;
    public final RandomProvider PROVIDER;
    public long id;
    public String name;
    public String fullname;
    public final Random random;
    public Set<String> mobs;
    public class_2487 data;
    public class_2487 colors;

    RandomBiome(long i, RandomDimension dim) {
        this.id = i;
        this.parent = dim;
        this.random = new Random(i);
        this.PROVIDER = dim.PROVIDER;
        this.name = "biome_" + i;
        this.fullname = "infinity:" + this.name;
        this.mobs = new HashSet<String>();
        this.data = new class_2487();
        this.data.method_10549("temperature", (double)(-1.0f + this.random.nextFloat() * 3.0f));
        this.data.method_10556("has_precipitation", this.PROVIDER.roll(this.random, "has_precipitation"));
        this.data.method_10582("temperature_modifier", this.roll("temperature_modifier_frozen") ? "frozen" : "none");
        this.data.method_10549("downfall", this.random.nextDouble());
        this.data.method_10566("effects", (class_2520)this.randomEffects());
        this.data.method_10566("spawners", (class_2520)new RandomMobsList(this).asData());
        this.data.method_10566("spawn_costs", (class_2520)this.spawnCosts());
        this.data.method_10566("features", (class_2520)new RandomFeaturesList((RandomBiome)this).data);
        this.data.method_10566("carvers", (class_2520)this.carvers());
        CommonIO.write(this.data, dim.getStoragePath() + "/worldgen/biome", this.name + ".json");
    }

    boolean roll(String key) {
        return this.PROVIDER.roll(this.random, key);
    }

    void rollAndPutSafe(class_2487 res, String key, class_2520 randomSound) {
        if (this.roll(key) && randomSound != null && !randomSound.method_10714().isBlank()) {
            res.method_10566(key, randomSound);
        }
    }

    public class_2497 randomColor() {
        return class_2497.method_23247((int)this.random.nextInt(0x1000000));
    }

    public class_2499 randomDustColor() {
        class_2499 res = new class_2499();
        res.add((Object)class_2489.method_23241((double)this.random.nextDouble()));
        res.add((Object)class_2489.method_23241((double)this.random.nextDouble()));
        res.add((Object)class_2489.method_23241((double)this.random.nextDouble()));
        return res;
    }

    class_2519 randomSound() {
        return class_2519.method_23256((String)this.PROVIDER.randomName(this.random, "sounds"));
    }

    class_2487 randomEffects() {
        class_2487 res = new class_2487();
        res.method_10566("fog_color", (class_2520)this.randomColor());
        res.method_10566("sky_color", (class_2520)this.randomColor());
        res.method_10566("water_color", (class_2520)this.randomColor());
        res.method_10566("water_fog_color", (class_2520)this.randomColor());
        if (this.random.nextBoolean()) {
            res.method_10566("foliage_color", (class_2520)this.randomColor());
        }
        if (this.random.nextBoolean()) {
            res.method_10566("grass_color", (class_2520)this.randomColor());
        }
        this.colors = res.method_10553();
        if (this.random.nextBoolean()) {
            res.method_10566("grass_color_modifier", (class_2520)class_2519.method_23256((String)(this.random.nextBoolean() ? "dark_forest" : "swamp")));
        }
        if (this.roll("use_particles")) {
            res.method_10566("particle", (class_2520)this.randomParticle());
        }
        this.rollAndPutSafe(res, "ambient_sound", (class_2520)this.randomSound());
        this.rollAndPutSafe(res, "mood_sound", (class_2520)this.randomMoodSound());
        this.rollAndPutSafe(res, "additions_sound", (class_2520)this.randomAdditionSound());
        if (this.roll("music")) {
            res.method_10566("music", (class_2520)this.randomMusic());
        }
        return res;
    }

    class_2487 randomMoodSound() {
        class_2487 res = new class_2487();
        class_2519 sound = this.randomSound();
        if (sound.method_10714().isEmpty()) {
            return null;
        }
        res.method_10566("sound", (class_2520)sound);
        res.method_10569("tick_delay", this.random.nextInt(6000));
        res.method_10569("block_search_extent", this.random.nextInt(32));
        res.method_10549("offset", this.random.nextDouble() * 8.0);
        return res;
    }

    class_2487 randomAdditionSound() {
        class_2487 res = new class_2487();
        class_2519 sound = this.randomSound();
        if (sound.method_10714().isEmpty()) {
            return null;
        }
        res.method_10566("sound", (class_2520)sound);
        res.method_10549("tick_chance", this.random.nextExponential() * 0.01);
        return res;
    }

    class_2487 randomMusic() {
        class_2487 res = new class_2487();
        res.method_10566("sound", (class_2520)class_2519.method_23256((String)this.PROVIDER.randomName(this.random, "music")));
        int a = this.random.nextInt(0, 12000);
        int b = this.random.nextInt(0, 24000);
        res.method_10569("min_delay", Math.min(a, b));
        res.method_10569("max_delay", Math.max(a, b));
        res.method_10556("replace_current_music", this.random.nextBoolean());
        return res;
    }

    class_2487 randomParticle() {
        class_2487 res = new class_2487();
        res.method_10548("probability", (float)(this.random.nextExponential() * 0.01));
        res.method_10566("options", (class_2520)this.particleOptions());
        return res;
    }

    class_2487 particleOptions() {
        class_2487 res = new class_2487();
        String particle = this.PROVIDER.randomName(this.random, "particles");
        res.method_10582("type", particle);
        switch (particle) {
            case "minecraft:block": 
            case "minecraft:block_marker": 
            case "minecraft:falling_dust": {
                class_2487 value = new class_2487();
                value.method_10582("Name", this.PROVIDER.randomName(this.random, "all_blocks"));
                res.method_10566("value", (class_2520)value);
                return res;
            }
            case "minecraft:item": {
                class_2487 value = new class_2487();
                value.method_10582("Name", this.PROVIDER.randomName(this.random, "items"));
                res.method_10566("value", (class_2520)value);
                return res;
            }
            case "minecraft:dust": {
                res.method_10566("color", (class_2520)this.randomDustColor());
                res.method_10548("scale", this.random.nextFloat());
                return res;
            }
            case "minecraft:dust_color_transition": {
                res.method_10566("fromColor", (class_2520)this.randomDustColor());
                res.method_10566("toColor", (class_2520)this.randomDustColor());
                res.method_10548("scale", this.random.nextFloat());
                return res;
            }
            case "minecraft:sculk_charge": {
                res.method_10548("roll", (float)((double)this.random.nextFloat() * Math.PI));
                return res;
            }
            case "minecraft:shriek": {
                res.method_10569("delay", this.random.nextInt(500));
                return res;
            }
        }
        return res;
    }

    class_2487 addMob(String category, boolean add) {
        class_2487 mob = new class_2487();
        String mobname = this.PROVIDER.randomName(this.random, category);
        mob.method_10582("type", mobname);
        if (add) {
            this.mobs.add(mobname);
        }
        mob.method_10569("weight", 1 + this.random.nextInt(20));
        int a = 1 + this.random.nextInt(6);
        int b = 1 + this.random.nextInt(6);
        mob.method_10569("minCount", Math.min(a, b));
        mob.method_10569("maxCount", Math.max(a, b));
        return mob;
    }

    class_2487 spawnCosts() {
        class_2487 res = new class_2487();
        for (String mob : this.mobs) {
            class_2487 mobData = new class_2487();
            mobData.method_10549("energy_budget", this.random.nextDouble() * 0.6);
            mobData.method_10549("charge", 0.5 + this.random.nextDouble() * 0.4);
            res.method_10566(mob, (class_2520)mobData);
        }
        return res;
    }

    class_2487 carvers() {
        class_2487 res = new class_2487();
        class_2499 air = new class_2499();
        if (this.PROVIDER.roll(this.random, "use_random_cave")) {
            air.add((Object)class_2519.method_23256((String)new RandomCarver((RandomBiome)this, (boolean)true).fullname));
        }
        if (this.PROVIDER.roll(this.random, "use_random_canyon")) {
            air.add((Object)class_2519.method_23256((String)new RandomCarver((RandomBiome)this, (boolean)false).fullname));
        }
        WeighedStructure<String> carvers = this.PROVIDER.registry.get("carvers");
        for (int i = 0; i < carvers.keys.size(); ++i) {
            if (!(this.random.nextDouble() < carvers.weights.get(i))) continue;
            air.add((Object)class_2519.method_23256((String)((String)carvers.keys.get(i))));
        }
        res.method_10566("air", (class_2520)air);
        return res;
    }
}

