/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions;

import java.util.Random;
import net.lerariemann.infinity.dimensions.RandomBiome;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class RandomCarver {
    public String name;
    public String fullname;
    private final Random random;
    public RandomBiome parent;

    RandomCarver(RandomBiome b, boolean cave) {
        this.parent = b;
        String s = cave ? "cave" : "canyon";
        this.name = s + "_" + b.id;
        this.fullname = "infinity:" + this.name;
        this.random = b.random;
        class_2487 res = new class_2487();
        res.method_10582("type", "minecraft:" + s);
        class_2487 config = new class_2487();
        config.method_10548("probability", (float)Math.min(1.0, this.random.nextExponential() * (cave ? 0.1 : 0.02)));
        class_2487 lava_level = new class_2487();
        lava_level.method_10569("above_bottom", 0);
        config.method_10566("lava_level", (class_2520)lava_level);
        config.method_10566("y", (class_2520)this.y());
        config.method_10566("replaceable", (class_2520)this.replaceable());
        if (cave) {
            this.putScale(config, "yScale", 3.0f);
            this.putScale(config, "horizontal_radius_multiplier", 2.5f);
            this.putScale(config, "vertical_radius_multiplier", 2.5f);
            config.method_10566("floor_level", (class_2520)NbtUtils.randomFloatProvider(this.random, -1.0f, 1.0f));
        } else {
            this.putScale(config, "yScale", 3.0f);
            config.method_10566("vertical_rotation", (class_2520)NbtUtils.randomFloatProvider(this.random, -1.0f, 1.0f));
            class_2487 shape = new class_2487();
            this.putScale(shape, "distance_factor", 2.0f);
            this.putScale(shape, "thickness", 3.0f);
            this.putScale(shape, "horizontal_radius_factor", 2.0f);
            shape.method_10548("vertical_radius_default_factor", this.random.nextFloat(0.5f, 2.0f));
            shape.method_10548("vertical_radius_center_factor", this.random.nextFloat(0.5f, 2.0f));
            shape.method_10569("width_smoothness", 1 + this.random.nextInt(8));
            config.method_10566("shape", (class_2520)shape);
        }
        res.method_10566("config", (class_2520)config);
        CommonIO.write(res, this.parent.parent.getStoragePath() + "/worldgen/configured_carver", this.name + ".json");
    }

    void putScale(class_2487 config, String key, float bound) {
        config.method_10566(key, (class_2520)NbtUtils.randomFloatProvider(this.random, 1.0f / bound, bound));
    }

    class_2487 y() {
        int min_y = this.parent.parent.min_y;
        return NbtUtils.randomHeightProvider(this.random, min_y, min_y + this.parent.parent.height, true, false);
    }

    class_2499 replaceable() {
        class_2499 res = new class_2499();
        res.add((Object)this.parent.parent.default_block.method_10580("Name"));
        for (class_2487 a : this.parent.parent.additional_blocks) {
            res.add((Object)a.method_10580("Name"));
        }
        res.add((Object)this.parent.parent.default_fluid.method_10580("Name"));
        res.add((Object)class_2519.method_23256((String)this.parent.parent.underwater.get(this.parent.fullname).method_10558("Name")));
        return res;
    }
}

