/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.lerariemann.infinity.InfinityMod;
import net.lerariemann.infinity.dimensions.DimensionData;
import net.lerariemann.infinity.dimensions.RandomBiome;
import net.lerariemann.infinity.dimensions.RandomDimensionType;
import net.lerariemann.infinity.dimensions.RandomNoisePreset;
import net.lerariemann.infinity.dimensions.RandomStructure;
import net.lerariemann.infinity.dimensions.RandomText;
import net.lerariemann.infinity.options.RandomInfinityOptions;
import net.lerariemann.infinity.util.InfinityMethods;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.NbtUtils;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class RandomDimension {
    public final long numericId;
    public final RandomProvider PROVIDER;
    public class_2960 identifier;
    public final Random random;
    public int height;
    public int min_y;
    public int sea_level;
    public boolean randomiseblocks;
    public class_2487 default_block;
    public class_2487 deepslate;
    public class_2487 default_fluid;
    public List<class_2487> additional_blocks;
    public List<String> vanilla_biomes;
    public List<Long> random_biome_ids;
    public List<RandomBiome> random_biomes;
    public Map<String, class_2487> top_blocks;
    public Map<String, List<String>> structure_ids;
    public Map<String, class_2487> underwater;
    public String type_alike;
    public MinecraftServer server;
    public class_2487 data;
    public RandomDimensionType type;

    public RandomDimension(class_2960 id, MinecraftServer server) {
        this.server = server;
        this.PROVIDER = InfinityMod.provider;
        this.identifier = id;
        this.numericId = InfinityMethods.getNumericFromId(this.identifier);
        this.random = new Random(this.numericId);
        this.initializeStorage();
        if (this.PROVIDER.easterizer.easterize(this)) {
            this.wrap_up(true);
            return;
        }
        this.genBasics();
        this.type = new RandomDimensionType(this);
        this.data.method_10582("type", this.type.fullname);
        this.data.method_10566("generator", (class_2520)this.randomDimensionGenerator());
        for (Long l : this.random_biome_ids) {
            if (!this.doesNotContain(class_7924.field_41236, "biome_" + l)) continue;
            RandomBiome b = new RandomBiome(l, this);
            this.random_biomes.add(b);
            this.addStructures(b);
        }
        this.writeTags(this.getRootPath());
        this.wrap_up(false);
    }

    public String getName() {
        return this.identifier.method_12832();
    }

    public String getRootPath() {
        return this.server.method_27050(class_5218.field_24186).resolve(this.getName()).toString();
    }

    public String getStoragePath() {
        return this.server.method_27050(class_5218.field_24186).resolve(this.getName()).resolve("data").resolve("infinity").toString();
    }

    public void initializeStorage() {
        this.data = new class_2487();
        this.vanilla_biomes = new ArrayList<String>();
        this.random_biome_ids = new ArrayList<Long>();
        this.random_biomes = new ArrayList<RandomBiome>();
        this.top_blocks = new HashMap<String, class_2487>();
        this.underwater = new HashMap<String, class_2487>();
        this.structure_ids = new HashMap<String, List<String>>();
        this.additional_blocks = new ArrayList<class_2487>();
    }

    public void genBasics() {
        this.type_alike = this.PROVIDER.randomName(this.random, "noise_presets");
        this.min_y = 16 * class_3532.method_15340((int)((int)Math.floor(this.random.nextExponential() * 2.0)), (int)(this.isOverworldLike() ? -125 : -3), (int)0);
        int avgHeight = class_3532.method_15340((int)RandomProvider.ruleInt("avgDimensionHeight"), (int)64, (int)1024);
        int max_y = 16 * class_3532.method_15340((int)((int)Math.floor(this.random.nextGaussian((double)avgHeight / 16.0, (double)avgHeight / 64.0))), (int)(this.isOverworldLike() ? 1 : 5), (int)125);
        this.randomiseblocks = this.PROVIDER.roll(this.random, "randomise_blocks");
        int sea_level_default = 63;
        if (!this.isOverworldLike()) {
            sea_level_default = switch (this.type_alike) {
                case "minecraft:floating_islands" -> -64;
                case "minecraft:end" -> 0;
                case "minecraft:nether", "minecraft:caves" -> 32;
                default -> 63;
            };
        }
        this.sea_level = this.randomiseblocks ? (int)Math.floor(this.random.nextGaussian(sea_level_default, 8.0)) : sea_level_default;
        max_y = Math.max(max_y, 16 * (int)(1.0 + Math.floor((double)this.sea_level / 16.0)));
        this.height = max_y - this.min_y;
        this.default_block = this.randomiseblocks ? this.PROVIDER.randomElement(this.random, "full_blocks_worldgen") : NbtUtils.nameToElement(this.getDefaultBlock("minecraft:stone"));
        this.default_fluid = this.randomiseblocks ? this.PROVIDER.randomElement(this.random, "fluids") : NbtUtils.nameToFluid(this.getDefaultFluid());
        this.deepslate = Arrays.stream(new String[]{"minecraft:overworld", "minecraft:amplified", "infinity:whack"}).toList().contains(this.type_alike) ? NbtUtils.nameToElement("minecraft:deepslate") : this.default_block;
    }

    void wrap_up(boolean isEasterDim) {
        if (!isEasterDim) {
            new DimensionData(this).save();
        }
        new RandomInfinityOptions(this, isEasterDim).save();
        CommonIO.write(this.data, this.getStoragePath() + "/dimension", this.getName() + ".json");
        if (!Paths.get(this.getRootPath() + "/pack.mcmeta", new String[0]).toFile().exists()) {
            CommonIO.write(this.packMcmeta(), this.getRootPath(), "pack.mcmeta");
        }
    }

    String getDefaultBlock(String fallback) {
        switch (this.type_alike) {
            case "minecraft:end": {
                return "minecraft:end_stone";
            }
            case "minecraft:nether": {
                return "minecraft:netherrack";
            }
        }
        return fallback;
    }

    String getDefaultFluid() {
        switch (this.type_alike) {
            case "minecraft:end": {
                return "minecraft:air";
            }
            case "minecraft:nether": {
                return "minecraft:lava";
            }
        }
        return "minecraft:water";
    }

    public <T> boolean doesNotContain(class_5321<? extends class_2378<T>> key, String name) {
        return !this.server.method_30611().method_30530(key).method_35842(class_5321.method_29179(key, (class_2960)InfinityMethods.getId(name)));
    }

    boolean isOverworldLike() {
        return this.type_alike.equals("minecraft:overworld") || this.type_alike.equals("minecraft:large_biomes") || this.type_alike.equals("minecraft:amplified") || this.type_alike.equals("infinity:whack");
    }

    boolean hasCeiling() {
        return this.type_alike.equals("minecraft:nether") || this.type_alike.equals("minecraft:caves") || this.type_alike.equals("infinity:tangled");
    }

    class_2487 packMcmeta() {
        class_2487 res = new class_2487();
        class_2487 pack = new class_2487();
        pack.method_10569("pack_format", 15);
        pack.method_10582("description", "Dimension #" + this.numericId);
        res.method_10566("pack", (class_2520)pack);
        return res;
    }

    class_2487 randomDimensionGenerator() {
        class_2487 res = new class_2487();
        String type = this.PROVIDER.randomName(this.random, "generator_types");
        res.method_10582("type", type);
        switch (type) {
            case "minecraft:flat": {
                res.method_10566("settings", (class_2520)this.randomSuperflatSettings());
                return res;
            }
            case "minecraft:noise": {
                res.method_10566("biome_source", (class_2520)this.randomBiomeSource());
                res.method_10582("settings", this.randomNoiseSettings());
                res.method_10544("seed", this.numericId ^ this.server.method_30002().method_8412());
                return res;
            }
        }
        return res;
    }

    class_2487 superflatLayer(int h, String block) {
        class_2487 res = new class_2487();
        res.method_10569("height", h);
        res.method_10582("block", block);
        return res;
    }

    class_2487 randomSuperflatSettings() {
        class_2487 res = new class_2487();
        class_2499 layers = new class_2499();
        String biome = this.randomBiome();
        String block = "minecraft:air";
        int layer_count = Math.min(64, 1 + (int)Math.floor(this.random.nextExponential() * 2.0));
        int heightLeft = this.height;
        for (int i = 0; i < layer_count; ++i) {
            int layerHeight = Math.min(heightLeft, 1 + (int)Math.floor(this.random.nextExponential() * 4.0));
            block = this.PROVIDER.randomName(this.random, "full_blocks_worldgen");
            layers.add((Object)this.superflatLayer(layerHeight, block));
            if ((heightLeft -= layerHeight) <= 1) break;
        }
        if (this.random.nextBoolean()) {
            block = this.PROVIDER.randomName(this.random, "top_blocks");
            layers.add((Object)this.superflatLayer(1, block));
        }
        res.method_10582("biome", biome);
        res.method_10566("layers", (class_2520)layers);
        res.method_10556("lakes", this.random.nextBoolean());
        res.method_10556("features", this.random.nextBoolean());
        this.top_blocks.put(biome, NbtUtils.nameToElement(block));
        this.underwater.put(biome, NbtUtils.nameToElement(block));
        return res;
    }

    class_2487 randomBiomeSource() {
        class_2487 res = new class_2487();
        String type = this.PROVIDER.randomName(this.random, "biome_source_types");
        res.method_10582("type", type);
        switch (type) {
            case "minecraft:the_end": {
                return res;
            }
            case "minecraft:checkerboard": {
                res.method_10566("biomes", (class_2520)this.randomBiomesCheckerboard());
                res.method_10569("scale", Math.min(62, (int)Math.floor(this.random.nextExponential() * 2.0)));
                return res;
            }
            case "minecraft:multi_noise": {
                String preset = this.PROVIDER.randomName(this.random, "multinoise_presets");
                if (preset.equals("none") || this.hasCeiling()) {
                    res.method_10566("biomes", (class_2520)this.randomBiomes());
                } else {
                    res.method_10582("preset", preset.replace("_", ":"));
                    this.addPresetBiomes(preset);
                }
                return res;
            }
            case "minecraft:fixed": {
                res.method_10582("biome", this.randomBiome());
            }
        }
        return res;
    }

    void addPresetBiomes(String preset) {
        class_6862 tag = preset.equals("overworld") ? class_6908.field_37393 : class_6908.field_36518;
        class_2378 r = this.server.method_30611().method_30530(class_7924.field_41236);
        r.method_42021().forEach(key -> {
            if (!Objects.equals(key.method_29177().method_12836(), "infinity") && r.method_29107(key) != null && r.method_47983((Object)((class_1959)r.method_29107(key))).method_40220(tag)) {
                this.vanilla_biomes.add(key.method_29177().toString());
            }
        });
    }

    int getBiomeCount() {
        return this.random.nextInt(2, class_3532.method_15340((int)RandomProvider.ruleInt("maxBiomeCount"), (int)2, (int)10));
    }

    class_2499 randomBiomesCheckerboard() {
        class_2499 res = new class_2499();
        int biome_count = this.getBiomeCount();
        for (int i = 0; i < biome_count; ++i) {
            res.add((Object)class_2519.method_23256((String)this.randomBiome()));
        }
        return res;
    }

    class_2499 randomBiomes() {
        class_2499 res = new class_2499();
        int biome_count = this.getBiomeCount();
        for (int i = 0; i < biome_count; ++i) {
            class_2487 element = new class_2487();
            element.method_10582("biome", this.randomBiome());
            element.method_10566("parameters", (class_2520)this.randomMultiNoiseParameters());
            res.add((Object)element);
        }
        return res;
    }

    class_2487 randomMultiNoiseParameters() {
        class_2487 res = new class_2487();
        res.method_10566("temperature", this.randomMultiNoiseParameter());
        res.method_10566("humidity", this.randomMultiNoiseParameter());
        res.method_10566("continentalness", this.randomMultiNoiseParameter());
        res.method_10566("erosion", this.randomMultiNoiseParameter());
        res.method_10566("weirdness", this.randomMultiNoiseParameter());
        res.method_10566("depth", this.randomMultiNoiseParameter());
        res.method_10566("offset", (class_2520)class_2489.method_23241((double)this.random.nextDouble()));
        return res;
    }

    class_2520 randomMultiNoiseParameter() {
        if (this.random.nextBoolean()) {
            class_2487 res = new class_2487();
            double a = ((double)this.random.nextFloat() - 0.5) * 2.0;
            double b = ((double)this.random.nextFloat() - 0.5) * 2.0;
            res.method_10548("min", (float)Math.min(a, b));
            res.method_10548("max", (float)Math.max(a, b));
            return res;
        }
        return class_2489.method_23241((double)((this.random.nextDouble() - 0.5) * 2.0));
    }

    String randomBiome() {
        Object biome;
        if (!this.hasCeiling() && !this.PROVIDER.roll(this.random, "use_random_biome")) {
            biome = this.PROVIDER.randomName(this.random, "biomes");
            this.vanilla_biomes.add((String)biome);
        } else {
            long id = InfinityMethods.getRandomSeed(this.random);
            this.random_biome_ids.add(id);
            biome = "infinity:biome_" + id;
        }
        return biome;
    }

    String randomNoiseSettings() {
        RandomNoisePreset preset = new RandomNoisePreset(this);
        return preset.fullname;
    }

    void addStructures(RandomBiome b) {
        int numstructures = this.random.nextInt(1, 5);
        HashSet<String> temp = new HashSet<String>();
        for (int i = 0; i < numstructures; ++i) {
            this.addStructure(new RandomStructure(this.random.nextInt(), b), temp);
        }
        if (this.PROVIDER.roll(this.random, "text")) {
            this.addStructure(new RandomText(this.random.nextInt(), b), temp);
        }
    }

    void addStructure(RandomStructure s, Set<String> temp) {
        if (!temp.contains(s.name)) {
            temp.add(s.name);
            s.save();
            if (!this.structure_ids.containsKey(s.type)) {
                this.structure_ids.put(s.type, new ArrayList());
            }
            this.structure_ids.get(s.type).add(s.fullname);
        }
    }

    void writeTags(String rootPath) {
        String path = rootPath + "/data/minecraft/tags/worldgen/structure";
        try {
            Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        class_2487 dictionary = CommonIO.read(String.valueOf(InfinityMod.utilPath) + "/structure_tags.json");
        HashMap<String, class_2499> tags = new HashMap<String, class_2499>();
        for (String s : this.structure_ids.keySet()) {
            for (String ss : dictionary.method_10541()) {
                if (!s.contains(ss)) continue;
                for (class_2520 e : (class_2499)Objects.requireNonNull(dictionary.method_10580(ss))) {
                    String t = e.method_10714();
                    if (!tags.containsKey(t)) {
                        tags.put(t, new class_2499());
                    }
                    this.structure_ids.get(s).forEach(fullname -> ((class_2499)tags.get(t)).add((Object)class_2519.method_23256((String)fullname)));
                }
            }
        }
        for (String t : tags.keySet()) {
            class_2487 compound = new class_2487();
            compound.method_10556("replace", false);
            compound.method_10566("values", (class_2520)tags.get(t));
            CommonIO.write(compound, path, t + ".json");
        }
    }
}

