/*
 * Decompiled with CFR 0.152.
 */
package net.lerariemann.infinity.dimensions;

import java.util.Random;
import net.lerariemann.infinity.dimensions.RandomDimension;
import net.lerariemann.infinity.util.core.CommonIO;
import net.lerariemann.infinity.util.core.RandomProvider;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class RandomDimensionType {
    public String name;
    public String fullname;
    private final Random random;
    public RandomDimension parent;
    public class_2487 data;
    public boolean ultrawarm;
    public boolean foggy;
    public static int scaleCap = 100000;

    RandomDimensionType(RandomDimension dim) {
        this.parent = dim;
        this.random = dim.random;
        this.name = "generated_" + dim.numericId;
        this.fullname = "infinity:" + this.name;
        this.data = new class_2487();
        this.ultrawarm = this.roll("ultrawarm");
        this.data.method_10556("ultrawarm", this.ultrawarm);
        this.add_roll(this.data, "natural");
        this.add_roll(this.data, "has_skylight");
        this.add_roll(this.data, "piglin_safe");
        this.add_roll(this.data, "bed_works");
        this.add_roll(this.data, "respawn_anchor_works");
        this.add_roll(this.data, "has_raids");
        this.data.method_10556("has_ceiling", dim.hasCeiling());
        this.data.method_10549("coordinate_scale", this.coordinateScale());
        this.data.method_10548("ambient_light", this.random.nextFloat());
        if (this.roll("fixed_time")) {
            this.data.method_10569("fixed_time", this.random.nextInt(24000));
        }
        this.data.method_10569("min_y", this.parent.min_y);
        this.data.method_10569("height", this.parent.height);
        this.data.method_10569("logical_height", this.parent.height);
        this.data.method_10569("monster_spawn_block_light_limit", this.random.nextInt(16));
        class_2487 lightLevel = new class_2487();
        lightLevel.method_10582("type", "uniform");
        lightLevel.method_10566("value", (class_2520)RandomProvider.genBounds(0, this.random.nextInt(15)));
        this.data.method_10566("monster_spawn_light_level", (class_2520)lightLevel);
        this.data.method_10582("infiniburn", "#" + dim.PROVIDER.randomName(this.random, "tags"));
        String s = dim.PROVIDER.randomName(this.random, "dimension_effects");
        this.foggy = s.equals("minecraft:the_nether");
        this.data.method_10582("effects", s);
        CommonIO.write(this.data, dim.getStoragePath() + "/dimension_type", this.name + ".json");
    }

    boolean roll(String key) {
        return this.parent.PROVIDER.roll(this.random, key);
    }

    void add_roll(class_2487 res, String key) {
        res.method_10556(key, this.roll(key));
    }

    double coordinateScale() {
        int scaleMax = RandomProvider.ruleInt("maxDimensionScale");
        if (scaleMax <= 0 || scaleMax > scaleCap) {
            scaleMax = scaleCap;
        }
        int distribParam = Math.min(scaleMax, 8);
        double scaleMin = 1.0 / (double)scaleMax;
        double random1 = this.random.nextBoolean() ? 1.0 : scaleMin + (Math.sqrt(distribParam) - scaleMin) * this.random.nextDouble();
        double random2 = (double)distribParam / random1;
        return this.random.nextBoolean() ? random1 : random2;
    }
}

